/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.peer.ComponentPeer;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.EmbeddedFrame;
import sun.awt.PeerEvent;
import sun.awt.X11.AwtGraphicsConfigData;
import sun.awt.X11.ComponentAccessor;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XBaseWindow;
import sun.awt.X11.XButtonEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XCrossingEvent;
import sun.awt.X11.XDecoratedPeer;
import sun.awt.X11.XExposeEvent;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XGlobalCursorManager;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XMapEvent;
import sun.awt.X11.XMenuBarPeer;
import sun.awt.X11.XMotionEvent;
import sun.awt.X11.XRepaintArea;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XUnmapEvent;
import sun.awt.X11.XVisualInfo;
import sun.awt.X11.XlibWrapper;
import sun.awt.X11ComponentPeer;
import sun.awt.X11GraphicsConfig;
import sun.java2d.SunGraphics2D;
import sun.java2d.SurfaceData;

public class XWindow
extends XBaseWindow
implements X11ComponentPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XWindow");
    private static Logger insLog = Logger.getLogger("sun.awt.X11.insets.XWindow");
    private static Logger eventLog = Logger.getLogger("sun.awt.X11.event.XWindow");
    private static final Logger focusLog = Logger.getLogger("sun.awt.X11.focus.XWindow");
    static int rbutton = 0;
    static int lastX = 0;
    static int lastY = 0;
    static long lastTime = 0L;
    static long lastButton = 0L;
    static WeakReference lastWindowRef = null;
    static int clickCount = 0;
    int oldWidth = -1;
    int oldHeight = -1;
    protected X11GraphicsConfig graphicsConfig;
    protected AwtGraphicsConfigData graphicsConfigData;
    boolean reparented;
    XWindow parent;
    Component target;
    private static int JAWT_LOCK_ERROR = 1;
    private static int JAWT_LOCK_CLIP_CHANGED = 2;
    private static int JAWT_LOCK_BOUNDS_CHANGED = 4;
    private static int JAWT_LOCK_SURFACE_CHANGED = 8;
    private int drawState = JAWT_LOCK_CLIP_CHANGED | JAWT_LOCK_BOUNDS_CHANGED | JAWT_LOCK_SURFACE_CHANGED;
    public static final String TARGET = "target";
    public static final String REPARENTED = "reparented";
    SurfaceData surfaceData;
    XRepaintArea paintArea;
    static final Font defaultFont = new Font("Dialog", 0, 12);
    private static Field isPostedField;
    static Method m_sendMessage;
    Color backgroundColor;

    native int getNativeColor(Color var1, GraphicsConfiguration var2);

    native void getWMInsets(long var1, long var3, long var5, long var7, long var9, long var11);

    native long getTopWindow(long var1, long var3);

    native void getWindowBounds(long var1, long var3, long var5, long var7, long var9);

    private static native void initIDs();

    XWindow(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    XWindow() {
    }

    XWindow(long l, Rectangle rectangle) {
        super(new XCreateWindowParams(new Object[]{"bounds", rectangle, "parent window", new Long(l)}));
    }

    XWindow(Component component, long l, Rectangle rectangle) {
        super(new XCreateWindowParams(new Object[]{"bounds", rectangle, "parent window", new Long(l), TARGET, component}));
    }

    XWindow(Component component, long l) {
        this(component, l, component.getBounds());
    }

    XWindow(Component component) {
        this(component, component.getParent() == null ? 0L : XWindow.getParentWindow(component), component.getBounds());
    }

    XWindow(Object object) {
        this(null, 0L, null);
    }

    XWindow(long l) {
        super(new XCreateWindowParams(new Object[]{"parent window", new Long(l), REPARENTED, Boolean.TRUE, "embedded", Boolean.TRUE}));
    }

    protected void initGraphicsConfiguration() {
        this.graphicsConfig = (X11GraphicsConfig)this.target.getGraphicsConfiguration();
        this.graphicsConfigData = new AwtGraphicsConfigData(this.graphicsConfig.getAData());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        this.reparented = Boolean.TRUE.equals(xCreateWindowParams.get(REPARENTED));
        this.target = (Component)xCreateWindowParams.get(TARGET);
        this.initGraphicsConfiguration();
        AwtGraphicsConfigData awtGraphicsConfigData = this.getGraphicsConfigurationData();
        X11GraphicsConfig x11GraphicsConfig = (X11GraphicsConfig)this.getGraphicsConfiguration();
        XVisualInfo xVisualInfo = awtGraphicsConfigData.get_awt_visInfo();
        xCreateWindowParams.putIfNull((Object)"event mask", 2269311L);
        if (this.target != null) {
            xCreateWindowParams.putIfNull((Object)"bounds", this.target.getBounds());
        } else {
            xCreateWindowParams.putIfNull((Object)"bounds", new Rectangle(0, 0, 1, 1));
        }
        xCreateWindowParams.putIfNull((Object)"border pixel", new Long(0L));
        this.getColorModel();
        xCreateWindowParams.putIfNull((Object)"color map", awtGraphicsConfigData.get_awt_cmap());
        xCreateWindowParams.putIfNull((Object)"visual depth", awtGraphicsConfigData.get_awt_depth());
        xCreateWindowParams.putIfNull((Object)"visual class", new Integer(1));
        xCreateWindowParams.putIfNull((Object)"visual", xVisualInfo.get_visual());
        xCreateWindowParams.putIfNull((Object)"value mask", 10248L);
        Long l = (Long)xCreateWindowParams.get("parent window");
        if ((l == null || l == 0L) && xVisualInfo != null) {
            Object object = XWindow.getAWTLock();
            synchronized (object) {
                int n = xVisualInfo.get_screen();
                if (n != -1) {
                    xCreateWindowParams.add((Object)"parent window", XlibWrapper.RootWindow(XToolkit.getDisplay(), n));
                } else {
                    xCreateWindowParams.add((Object)"parent window", XToolkit.getDefaultRootWindow());
                }
            }
        }
        this.paintArea = new XRepaintArea();
        if (this.target != null) {
            this.parent = XWindow.getParentXWindowObject(this.target.getParent());
        }
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        Color color;
        super.postInit(xCreateWindowParams);
        this.setWMClass(this.getWMClass());
        this.surfaceData = this.graphicsConfig.createSurfaceData(this);
        if (this.target != null && (color = this.target.getBackground()) != null) {
            this.xSetBackground(color);
        }
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfig == null) {
            this.initGraphicsConfiguration();
        }
        return this.graphicsConfig;
    }

    public AwtGraphicsConfigData getGraphicsConfigurationData() {
        if (this.graphicsConfigData == null) {
            this.initGraphicsConfiguration();
        }
        return this.graphicsConfigData;
    }

    protected String[] getWMClass() {
        return new String[]{XToolkit.getCorrectXIDString(this.getClass().getName()), XToolkit.getAWTAppClassName()};
    }

    static long getParentWindow(Component component) {
        ComponentPeer componentPeer = component.getParent().getPeer();
        Container container = component.getParent();
        while (!(componentPeer instanceof XWindow)) {
            container = container.getParent();
            componentPeer = container.getPeer();
        }
        if (componentPeer != null && componentPeer instanceof XWindow) {
            return ((XWindow)((Object)componentPeer)).getContentWindow();
        }
        return 0L;
    }

    static XWindow getParentXWindowObject(Component component) {
        if (component == null) {
            return null;
        }
        Container container = component.getParent();
        if (container == null) {
            return null;
        }
        ComponentPeer componentPeer = container.getPeer();
        if (componentPeer == null) {
            return null;
        }
        while (componentPeer != null && !(componentPeer instanceof XWindow)) {
            container = container.getParent();
            componentPeer = container.getPeer();
        }
        if (componentPeer != null && componentPeer instanceof XWindow) {
            return (XWindow)((Object)componentPeer);
        }
        return null;
    }

    boolean isParentOf(XWindow xWindow) {
        if (!(this.target instanceof Container) || xWindow == null || xWindow.getTarget() == null) {
            return false;
        }
        Container container = ComponentAccessor.getParent_NoClientCode(xWindow.target);
        while (container != null && container != this.target) {
            container = ComponentAccessor.getParent_NoClientCode(container);
        }
        return container == this.target;
    }

    public Object getTarget() {
        return this.target;
    }

    public Component getEventSource() {
        return this.target;
    }

    public ColorModel getColorModel(int n) {
        return this.graphicsConfig.getColorModel(n);
    }

    public ColorModel getColorModel() {
        if (this.graphicsConfig != null) {
            return this.graphicsConfig.getColorModel();
        }
        return XToolkit.getStaticColorModel();
    }

    Graphics getGraphics(SurfaceData surfaceData, Color color, Color color2, Font font) {
        Font font2;
        Color color3;
        if (surfaceData == null) {
            return null;
        }
        Component component = this.target;
        Color color4 = color2;
        if (color4 == null) {
            color4 = SystemColor.window;
        }
        if ((color3 = color) == null) {
            color3 = SystemColor.windowText;
        }
        if ((font2 = font) == null) {
            font2 = defaultFont;
        }
        return new SunGraphics2D(surfaceData, color3, color4, font2);
    }

    public Graphics getGraphics() {
        return this.getGraphics(this.surfaceData, this.target.getForeground(), this.target.getBackground(), this.target.getFont());
    }

    public FontMetrics getFontMetrics(Font font) {
        return Toolkit.getDefaultToolkit().getFontMetrics(font);
    }

    public Rectangle getTargetBounds() {
        return this.target.getBounds();
    }

    void prePostEvent(AWTEvent aWTEvent) {
    }

    static void sendEvent(final AWTEvent aWTEvent) {
        if (isPostedField == null) {
            isPostedField = XToolkit.getField(AWTEvent.class, "isPosted");
        }
        PeerEvent peerEvent = new PeerEvent(Toolkit.getDefaultToolkit(), new Runnable(){

            public void run() {
                block4: {
                    try {
                        isPostedField.setBoolean(aWTEvent, true);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        assert (false);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        if ($assertionsDisabled) break block4;
                        throw new AssertionError();
                    }
                }
                ((Component)aWTEvent.getSource()).dispatchEvent(aWTEvent);
            }
        }, 2L);
        if (focusLog.isLoggable(Level.FINER) && aWTEvent instanceof FocusEvent) {
            focusLog.finer("Sending " + aWTEvent);
        }
        XToolkit.postEvent(XToolkit.targetToAppContext(aWTEvent.getSource()), peerEvent);
    }

    void postEvent(AWTEvent aWTEvent) {
        XToolkit.postEvent(XToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    static void postEventStatic(AWTEvent aWTEvent) {
        XToolkit.postEvent(XToolkit.targetToAppContext(aWTEvent.getSource()), aWTEvent);
    }

    public void postEventToEventQueue(AWTEvent aWTEvent) {
        this.prePostEvent(aWTEvent);
        this.postEvent(aWTEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void xSetBackground(Color color) {
        int n = 0;
        try {
            XToolkit.awtLock();
            this.winBackground(color);
            n = this.surfaceData.pixelFor(color.getRGB());
            XlibWrapper.XSetWindowBackground(XToolkit.getDisplay(), this.getContentWindow(), n);
        }
        finally {
            XToolkit.awtUnlock();
        }
    }

    public void setBackground(Color color) {
        this.xSetBackground(color);
    }

    void winBackground(Color color) {
        this.backgroundColor = color;
    }

    public Color getWinBackground() {
        Color color = null;
        if (this.backgroundColor != null) {
            color = this.backgroundColor;
        } else if (this.parent != null) {
            color = this.parent.getWinBackground();
        }
        if (color instanceof SystemColor) {
            color = new Color(color.getRGB());
        }
        return color;
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint(int n, int n2, int n3, int n4) {
        if (!this.isVisible()) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                graphics.setClip(n, n2, n3, n4);
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaint() {
        if (!this.isVisible()) {
            return;
        }
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            try {
                this.paint(graphics);
            }
            finally {
                graphics.dispose();
            }
        }
    }

    void paint(Graphics graphics) {
    }

    public void popup(int n, int n2, int n3, int n4) {
        this.xSetBounds(n, n2, n3, n4);
    }

    public void handleExposeEvent(int n, long l) {
        super.handleExposeEvent(n, l);
        XExposeEvent xExposeEvent = new XExposeEvent(l);
        if (this.isEventDisabled(xExposeEvent)) {
            return;
        }
        int n2 = xExposeEvent.get_x();
        int n3 = xExposeEvent.get_y();
        int n4 = xExposeEvent.get_width();
        int n5 = xExposeEvent.get_height();
        Component component = this.getEventSource();
        if (!ComponentAccessor.getIgnoreRepaint(component) && ComponentAccessor.getWidth(component) != 0 && ComponentAccessor.getHeight(component) != 0) {
            PaintEvent paintEvent = new PaintEvent(component, 800, new Rectangle(n2, n3, n4, n5));
            this.postEventToEventQueue(paintEvent);
        }
    }

    static int getModifiers(int n, int n2, int n3) {
        int n4 = 0;
        if ((n & 1) != 0 ^ n3 == 16) {
            n4 |= 0x40;
        }
        if ((n & 4) != 0 ^ n3 == 17) {
            n4 |= 0x80;
        }
        if ((n & XToolkit.metaMask) != 0 ^ n3 == 157) {
            n4 |= 0x100;
        }
        if ((n & XToolkit.altMask) != 0 ^ n3 == 18) {
            n4 |= 0x200;
        }
        if ((n & XToolkit.modeSwitchMask) != 0 ^ n3 == 65406) {
            n4 |= 0x2000;
        }
        if ((n & 0x100) != 0 ^ n2 == 1) {
            n4 |= 0x400;
        }
        if ((n & 0x200) != 0 ^ n2 == 2) {
            n4 |= 0x800;
        }
        if ((n & 0x400) != 0 ^ n2 == 3) {
            n4 |= 0x1000;
        }
        return n4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static int getRightButtonNumber() {
        if (rbutton == 0) {
            try {
                XToolkit.awtLock();
                rbutton = XlibWrapper.XGetPointerMapping(XToolkit.getDisplay(), XlibWrapper.ibuffer, 3);
            }
            finally {
                XToolkit.awtUnlock();
            }
        }
        return rbutton;
    }

    public void handleButtonPressRelease(int n, long l) {
        Serializable serializable;
        super.handleButtonPressRelease(n, l);
        XButtonEvent xButtonEvent = new XButtonEvent(l);
        if (this.isEventDisabled(xButtonEvent)) {
            return;
        }
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xButtonEvent.toString());
        }
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        long l2 = xButtonEvent.get_button();
        long l3 = xButtonEvent.get_time();
        long l4 = XToolkit.nowMillisUTC_offset(l3);
        int n3 = xButtonEvent.get_x();
        int n4 = xButtonEvent.get_y();
        if (xButtonEvent.get_window() != this.window) {
            serializable = this.toLocal(xButtonEvent.get_x_root(), xButtonEvent.get_y_root());
            n3 = serializable.x;
            n4 = serializable.y;
        }
        if (xButtonEvent.get_type() == 4) {
            Point point = serializable = lastWindowRef != null ? (XWindow)lastWindowRef.get() : null;
            if (eventLog.isLoggable(Level.FINEST)) {
                eventLog.finest("lastWindow = " + serializable + ", lastButton " + lastButton + ", lastTime " + lastTime + ", multiClickTime " + XToolkit.getMultiClickTime());
            }
            if (serializable == this && lastButton == l2 && l3 - lastTime < (long)XToolkit.getMultiClickTime()) {
                ++clickCount;
            } else {
                clickCount = 1;
                lastWindowRef = new WeakReference<XWindow>(this);
                lastButton = l2;
                lastX = n3;
                lastY = n4;
            }
            lastTime = l3;
            bl = l2 == (long)XWindow.getRightButtonNumber() || l2 > 2L;
        } else {
            Point point = serializable = lastWindowRef != null ? (XWindow)lastWindowRef.get() : null;
            if (serializable == this) {
                bl2 = true;
            }
        }
        if (l2 == 1L) {
            n2 = 1;
        } else if (l2 == 2L) {
            n2 = 2;
        } else if (l2 == 3L) {
            n2 = 3;
        } else if (l2 == 4L) {
            n2 = 4;
            bl3 = true;
        } else if (l2 == 5L) {
            n2 = 5;
            bl3 = true;
        }
        int n5 = XWindow.getModifiers(xButtonEvent.get_state(), n2, 0);
        if (!bl3) {
            serializable = new MouseEvent(this.getEventSource(), n == 4 ? 501 : 502, l4, n5, n3, n4, clickCount, bl, n2);
            this.postEventToEventQueue((AWTEvent)serializable);
            if (bl2) {
                serializable = new MouseEvent(this.getEventSource(), 500, l4, n5, n3, n4, clickCount, false, n2);
                this.postEventToEventQueue((AWTEvent)serializable);
            }
        } else if (xButtonEvent.get_type() == 4) {
            serializable = new MouseWheelEvent(this.getEventSource(), 507, l4, n5, n3, n4, clickCount, false, 0, 3, n2 == 4 ? -1 : 1);
            this.postEventToEventQueue((AWTEvent)serializable);
        }
    }

    public void handleMotionNotify(long l) {
        Serializable serializable;
        super.handleMotionNotify(l);
        XMotionEvent xMotionEvent = new XMotionEvent(l);
        if (this.isEventDisabled(xMotionEvent)) {
            return;
        }
        clickCount = 0;
        long l2 = XToolkit.nowMillisUTC_offset(xMotionEvent.get_time());
        int n = XWindow.getModifiers(xMotionEvent.get_state(), 0, 0);
        boolean bl = false;
        boolean bl2 = (xMotionEvent.get_state() & 0x700) != 0;
        int n2 = bl2 ? 506 : 503;
        Component component = this.getEventSource();
        int n3 = xMotionEvent.get_x();
        int n4 = xMotionEvent.get_y();
        if (xMotionEvent.get_window() != this.window) {
            serializable = this.toLocal(xMotionEvent.get_x_root(), xMotionEvent.get_y_root());
            n3 = serializable.x;
            n4 = serializable.y;
        }
        if (bl2 && clickCount == 0 || !bl2) {
            serializable = new MouseEvent(component, n2, l2, n, n3, n4, clickCount, bl, 0);
            this.postEventToEventQueue((AWTEvent)serializable);
        }
    }

    public native int nativeHandleKeyEvent(Component var1, int var2, long var3);

    public native int nativeGetKeyCode(Component var1, int var2, long var3);

    public void handleXCrossingEvent(long l) {
        Serializable serializable;
        Object object;
        super.handleXCrossingEvent(l);
        XCrossingEvent xCrossingEvent = new XCrossingEvent(l);
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xCrossingEvent.toString());
        }
        if (xCrossingEvent.get_mode() != 0 && xCrossingEvent.get_mode() != 2) {
            return;
        }
        long l2 = xCrossingEvent.get_subwindow();
        if (l2 != 0L && (object = XToolkit.windowToXWindow(l2)) != null && object instanceof XWindow && !((XBaseWindow)object).isEventDisabled(xCrossingEvent)) {
            return;
        }
        object = XAwtState.getComponentMouseEntered();
        if (xCrossingEvent.get_type() == 7) {
            XAwtState.setComponentMouseEntered(this.getEventSource());
            XGlobalCursorManager.nativeUpdateCursor(this.getEventSource());
        } else {
            XAwtState.setComponentMouseEntered(null);
        }
        if (this.isEventDisabled(xCrossingEvent)) {
            return;
        }
        if (xCrossingEvent.get_mode() == 2) {
            return;
        }
        long l3 = XToolkit.nowMillisUTC_offset(xCrossingEvent.get_time());
        int n = XWindow.getModifiers(xCrossingEvent.get_state(), 0, 0);
        int n2 = 0;
        boolean bl = false;
        int n3 = xCrossingEvent.get_x();
        int n4 = xCrossingEvent.get_y();
        if (xCrossingEvent.get_window() != this.window) {
            serializable = this.toLocal(xCrossingEvent.get_x_root(), xCrossingEvent.get_y_root());
            n3 = serializable.x;
            n4 = serializable.y;
        }
        if (object != null) {
            serializable = new MouseEvent((Component)object, 505, l3, n, xCrossingEvent.get_x(), xCrossingEvent.get_y(), n2, bl, 0);
            this.postEventToEventQueue((AWTEvent)serializable);
            eventLog.finest("Clearing last window ref");
            lastWindowRef = null;
        }
        if (xCrossingEvent.get_type() == 7) {
            serializable = new MouseEvent(this.getEventSource(), 504, l3, n, xCrossingEvent.get_x(), xCrossingEvent.get_y(), n2, bl, 0);
            this.postEventToEventQueue((AWTEvent)serializable);
        }
    }

    public void doLayout(int n, int n2, int n3, int n4) {
    }

    public void handleConfigureNotifyEvent(long l) {
        Rectangle rectangle = this.getBounds();
        super.handleConfigureNotifyEvent(l);
        XConfigureEvent xConfigureEvent = new XConfigureEvent(l);
        if (this.isEventDisabled(xConfigureEvent)) {
            return;
        }
        long l2 = xConfigureEvent.get_window();
        Rectangle rectangle2 = this.getBounds();
        if (!rectangle2.getSize().equals(rectangle.getSize())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 101));
        }
        if (!rectangle2.getLocation().equals(rectangle.getLocation())) {
            this.postEventToEventQueue(new ComponentEvent(this.getEventSource(), 100));
        }
    }

    public void handleMapNotifyEvent(long l) {
        super.handleMapNotifyEvent(l);
        log.log(Level.FINE, "Mapped {0}", new Object[]{this});
        XMapEvent xMapEvent = new XMapEvent(l);
        if (this.isEventDisabled(xMapEvent)) {
            return;
        }
        ComponentEvent componentEvent = new ComponentEvent(this.getEventSource(), 102);
        this.postEventToEventQueue(componentEvent);
    }

    public void handleUnmapNotifyEvent(long l) {
        super.handleUnmapNotifyEvent(l);
        XUnmapEvent xUnmapEvent = new XUnmapEvent(l);
        if (this.isEventDisabled(xUnmapEvent)) {
            return;
        }
        ComponentEvent componentEvent = new ComponentEvent(this.target, 103);
        this.postEventToEventQueue(componentEvent);
    }

    public void handleKeyPress(long l) {
        super.handleKeyPress(l);
        XKeyEvent xKeyEvent = new XKeyEvent(l);
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xKeyEvent.toString());
        }
        if (this.isEventDisabled(xKeyEvent)) {
            return;
        }
        final Component component = this.getEventSource();
        if (this.nativeHandleKeyEvent(component, 401, xKeyEvent.pData) == 121) {
            XToolkit.executeOnEventHandlerThread(component, new Runnable(){

                public void run() {
                    XWindow.this.handleF10onEDT(component);
                }
            });
        }
    }

    void handleF10onEDT(Component component) {
        XMenuBarPeer xMenuBarPeer;
        XFramePeer xFramePeer = XToolkit.getParentFramePeer(component);
        if (xFramePeer != null && (xMenuBarPeer = xFramePeer.getMenubarPeer()) != null) {
            xMenuBarPeer.handleF10KeyPress();
        }
    }

    public void handleKeyRelease(long l) {
        super.handleKeyRelease(l);
        XKeyEvent xKeyEvent = new XKeyEvent(l);
        if (eventLog.isLoggable(Level.FINE)) {
            eventLog.fine(xKeyEvent.toString());
        }
        if (this.isEventDisabled(xKeyEvent)) {
            return;
        }
        this.nativeHandleKeyEvent(this.getEventSource(), 402, l);
    }

    public void reshape(Rectangle rectangle) {
        this.reshape(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public void reshape(int n, int n2, int n3, int n4) {
        if (n3 <= 0) {
            n3 = 1;
        }
        if (n4 <= 0) {
            n4 = 1;
        }
        this.x = n;
        this.y = n2;
        this.width = n3;
        this.height = n4;
        this.xSetBounds(n, n2, n3, n4);
    }

    boolean isShowing() {
        return this.visible;
    }

    public String toString() {
        return super.toString() + "(" + Long.toString(this.getWindow(), 16) + ")";
    }

    boolean isResizable() {
        return true;
    }

    void updateSizeHints() {
        this.updateSizeHints(this.x, this.y, this.width, this.height);
    }

    void updateSizeHints(int n, int n2, int n3, int n4) {
        long l = 13L;
        if (!this.isResizable()) {
            log.log(Level.FINER, "Window {0} is not resizable", new Object[]{this});
            l |= 0x30L;
        } else {
            log.log(Level.FINER, "Window {0} is resizable", new Object[]{this});
        }
        this.setSizeHints(l, n, n2, n3, n4);
    }

    void updateSizeHints(int n, int n2) {
        long l = 5L;
        if (!this.isResizable()) {
            log.log(Level.FINER, "Window {0} is not resizable", new Object[]{this});
            l |= 0x38L;
        } else {
            log.log(Level.FINER, "Window {0} is resizable", new Object[]{this});
        }
        this.setSizeHints(l, n, n2, this.width, this.height);
    }

    void validateSurface() {
        if (this.width != this.oldWidth || this.height != this.oldHeight) {
            SurfaceData surfaceData = this.surfaceData;
            if (surfaceData != null) {
                this.surfaceData = this.graphicsConfig.createSurfaceData(this);
                surfaceData.invalidate();
            }
            this.oldWidth = this.width;
            this.oldHeight = this.height;
        }
    }

    public SurfaceData getSurfaceData() {
        return this.surfaceData;
    }

    public void dispose() {
        SurfaceData surfaceData = this.surfaceData;
        this.surfaceData = null;
        if (surfaceData != null) {
            surfaceData.invalidate();
        }
        XToolkit.targetDisposedPeer(this.target, this);
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Point getLocationOnScreen() {
        Object object = this.target.getTreeLock();
        synchronized (object) {
            Component component = this.target;
            while (component != null && !(component instanceof Window)) {
                component = ComponentAccessor.getParent_NoClientCode(component);
            }
            if (component == null || component instanceof EmbeddedFrame) {
                return this.toGlobal(0, 0);
            }
            Object object2 = XWindow.getAWTLock();
            synchronized (object2) {
                Object object3 = XToolkit.targetToPeer(component);
                if (object3 == null || !(object3 instanceof XDecoratedPeer) || ((XDecoratedPeer)object3).configure_seen) {
                    return this.toGlobal(0, 0);
                }
                Point point = XWindow.toOtherWindow(this.getContentWindow(), ((XDecoratedPeer)object3).getContentWindow(), 0, 0);
                point.x += component.getX();
                point.y += component.getY();
                return point;
            }
        }
    }

    public void postKeyEvent(int n, long l, int n2, char c, int n3, int n4) {
        long l2 = XToolkit.nowMillisUTC_offset(l);
        int n5 = XWindow.getModifiers(n4, 0, n2);
        KeyEvent keyEvent = new KeyEvent(this.getEventSource(), n, l2, n5, n2, c, n3);
        this.postEventToEventQueue(keyEvent);
    }

    static {
        XWindow.initIDs();
    }
}

