/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuBarPeer;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Logger;
import sun.awt.X11.XAwtState;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XFramePeer;
import sun.awt.X11.XMenuComponentPeer;
import sun.awt.X11.XMenuPeer;
import sun.awt.X11.XMenuWindow;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindowAttributesData;
import sun.awt.X11.XWindowPeer;

public class XMenuBarPeer
extends XMenuComponentPeer
implements MenuBarPeer {
    private static Logger log = Logger.getLogger("sun.awt.X11.XMenuBarPeer");
    private static final int GAP = 10;
    private XMenuPeer helpMenu;
    private XMenuPeer menu;
    private int menuSelected = -1;
    private Vector menus = new Vector();
    private static final String FRAME = "Frame";
    private static Field f_helpMenu = XToolkit.getField(MenuBar.class, "helpMenu");
    private static Field f_menus = XToolkit.getField(MenuBar.class, "menus");
    private int lastPaintHeight = 0;
    static final int W_DIFF = 12;
    static final int H_DIFF = 23;

    MenuData[] copyMenus() {
        return this.getMenus().toArray(new MenuData[0]);
    }

    public XMenuBarPeer(MenuBar menuBar) {
        super(menuBar);
    }

    void init(Frame frame) {
        XCreateWindowParams xCreateWindowParams = this.getDelayedParams();
        xCreateWindowParams.add((Object)FRAME, frame);
        xCreateWindowParams.remove("delayed");
        this.init(xCreateWindowParams);
    }

    void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.add((Object)"parent window", ((XFramePeer)this.getPeer(this.getFrame())).getShell());
    }

    Menu[] copyTargetMenus() {
        return this.getTargetMenus().toArray(new Menu[0]);
    }

    void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        Vector<MenuData> vector = new Vector<MenuData>();
        Menu[] menuArray = this.copyTargetMenus();
        int n = menuArray.length;
        for (int i = 0; i < n; ++i) {
            Menu menu = menuArray[i];
            if (menu == null) continue;
            vector.add(new MenuData((XMenuPeer)this.getPeer(menu), i));
        }
        this.setMenus(vector);
        this.addHelpMenu(this.targetGetHelpMenu());
        this.toFront();
    }

    int getHeight() {
        int n = 0;
        MenuData[] menuDataArray = this.copyMenus();
        int n2 = menuDataArray.length;
        for (int i = 0; i < n2; ++i) {
            XMenuPeer xMenuPeer = menuDataArray[i].menu;
            n = Math.max(n, this.getFontMetrics(xMenuPeer.getFont()).getHeight());
        }
        return n + 10;
    }

    public void addMenu(Menu menu) {
        if (this.getHelpMenu() != null) {
            this.getMenus().insertElementAt(new MenuData((XMenuPeer)this.getPeer(menu), this.getMenus().size()), this.getMenus().size() - 1);
        } else {
            this.getMenus().addElement(new MenuData((XMenuPeer)this.getPeer(menu), this.getMenus().size()));
        }
        this.repaint();
    }

    int peerToPeerIndex(XMenuPeer xMenuPeer) {
        for (int i = 0; i < this.getMenus().size(); ++i) {
            if (xMenuPeer != this.getMenu(i)) continue;
            return i;
        }
        return -1;
    }

    int menuIndexToPeerIndex(int n) {
        for (int i = 0; i < this.getMenus().size(); ++i) {
            if (n != this.getMenuIndex(i)) continue;
            return i;
        }
        return -1;
    }

    void updateMenuIndexesAfterDeletion(int n) {
        for (int i = 0; i < this.getMenus().size(); ++i) {
            if (this.getMenuIndex(i) <= n) continue;
            --((MenuData)this.getMenus().elementAt((int)i)).index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delMenu(int n) {
        Vector vector = this.getMenus();
        synchronized (vector) {
            if (n < this.getMenus().size()) {
                int n2;
                if (this.getMenuSelected() >= 0) {
                    XMenuPeer xMenuPeer = this.getMenu();
                    if (xMenuPeer != null) {
                        xMenuPeer.popdown(null, false);
                        xMenuPeer.setPosted(false);
                        this.setMenu(null);
                    }
                    this.setMenuSelected(-1);
                }
                if (this.getMenu(n2 = this.menuIndexToPeerIndex(n)) == this.getHelpMenu()) {
                    this.setHelpMenu(null);
                }
                this.getMenus().removeElementAt(n2);
                this.updateMenuIndexesAfterDeletion(n);
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveHelpMenuToLast() {
        Vector vector = this.getMenus();
        synchronized (vector) {
            int n = this.peerToPeerIndex(this.getHelpMenu());
            if (n >= 0 && n < this.getMenus().size() - 1) {
                MenuData menuData = (MenuData)this.getMenus().elementAt(n);
                this.getMenus().removeElementAt(n);
                this.getMenus().addElement(menuData);
            }
        }
    }

    public void addHelpMenu(Menu menu) {
        if (menu == null) {
            this.setHelpMenu(null);
            return;
        }
        this.setHelpMenu((XMenuPeer)this.getPeer(menu));
        this.moveHelpMenuToLast();
        this.repaint();
    }

    XMenuPeer selectMenuByKeyPress(int n, int n2) {
        if (XAwtState.getGrabWindow() != this) {
            return null;
        }
        this.setMenuSelected(n);
        XMenuPeer xMenuPeer = this.getMenu();
        if (xMenuPeer == null && n2 != 32 && n2 != 10 && n2 != 40) {
            this.repaint();
            return null;
        }
        XMenuPeer xMenuPeer2 = xMenuPeer;
        XMenuPeer xMenuPeer3 = this.getHelpMenu();
        this.setMenu(this.getMenu(n));
        xMenuPeer = this.getMenu();
        if (xMenuPeer != null) {
            MenuData[] menuDataArray = this.copyMenus();
            int n3 = menuDataArray.length;
            int n4 = 0;
            boolean bl = true;
            for (int i = 0; i < n3; ++i) {
                XMenuPeer xMenuPeer4 = menuDataArray[i].menu;
                String string = xMenuPeer4.getLabel();
                FontMetrics fontMetrics = this.getFontMetrics(xMenuPeer4.getFont());
                int n5 = fontMetrics.stringWidth(string) + 20;
                if (i == n) {
                    if (xMenuPeer4 == xMenuPeer3) {
                        n4 = this.getWidth() - n5;
                    }
                    if (xMenuPeer4.isViewable()) {
                        Point point = this.toGlobal(n4 + 1, this.height - 4);
                        xMenuPeer.popup(point.x, point.y);
                        xMenuPeer.select(xMenuPeer.getDownSelected());
                    }
                    if (xMenuPeer2 != null && xMenuPeer2 != xMenuPeer) {
                        xMenuPeer2.setPosted(false);
                        xMenuPeer2.popdown(null, false);
                    }
                    this.repaint();
                    return xMenuPeer;
                }
                n4 += n5;
            }
        }
        return null;
    }

    XMenuPeer selectMenu(MouseEvent mouseEvent, int n, int n2) {
        XMenuPeer xMenuPeer = this.getMenu();
        XMenuPeer xMenuPeer2 = this.getHelpMenu();
        int n3 = this.getWidth();
        if (n2 > this.height) {
            return xMenuPeer;
        }
        if (xMenuPeer != null && xMenuPeer.cascadeContains(this, new Point(n, n2), 0)) {
            return xMenuPeer;
        }
        MenuData[] menuDataArray = this.copyMenus();
        int n4 = menuDataArray.length;
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            XMenuPeer xMenuPeer3 = menuDataArray[i].menu;
            if (!xMenuPeer3.isViewable()) {
                return xMenuPeer;
            }
            String string = xMenuPeer3.getLabel();
            FontMetrics fontMetrics = this.getFontMetrics(xMenuPeer3.getFont());
            int n6 = fontMetrics.stringWidth(string) + 20;
            if (xMenuPeer3 == xMenuPeer2) {
                n5 = n3 - n6;
            }
            if (xMenuPeer3.isEnabled() && n > n5 && n <= n5 + n6) {
                if (xMenuPeer != xMenuPeer3) {
                    XMenuPeer xMenuPeer4 = xMenuPeer;
                    Point point = this.toGlobal(n5 + 1, this.height - 4);
                    xMenuPeer = xMenuPeer3;
                    this.setMenu(xMenuPeer);
                    if (xMenuPeer != null) {
                        xMenuPeer.popup(point.x, point.y);
                    }
                    this.setMenuSelected(i);
                    this.grabInput();
                    if (xMenuPeer4 != null) {
                        xMenuPeer4.setPosted(false);
                        xMenuPeer4.popdown(mouseEvent, false);
                    }
                    this.repaint();
                }
                return xMenuPeer;
            }
            n5 += n6;
        }
        return xMenuPeer;
    }

    void paint(Graphics graphics) {
        int n = this.getWidth();
        int n2 = this.getHeight();
        XMenuPeer xMenuPeer = this.getHelpMenu();
        int n3 = this.getMenuSelected();
        if (graphics == null) {
            return;
        }
        if (n2 != this.lastPaintHeight) {
            this.lastPaintHeight = n2;
            ((XFramePeer)this.getPeer(this.getFrame())).updateChildrenSizes();
        }
        graphics.setColor(this.getBackground());
        graphics.fillRect(1, 1, n - 2, n2 - 2);
        graphics.setColor(this.getLightShadow());
        graphics.drawLine(0, 0, n - 1, 0);
        graphics.drawLine(0, 0, 0, n2 - 1);
        graphics.setColor(this.getDarkShadow());
        graphics.drawLine(n - 1, 0, n - 1, n2 - 1);
        graphics.drawLine(0, n2 - 1, n - 1, n2 - 1);
        int n4 = 0;
        MenuData[] menuDataArray = this.copyMenus();
        int n5 = menuDataArray.length;
        for (int i = 0; i < n5; ++i) {
            XMenuPeer xMenuPeer2 = menuDataArray[i].menu;
            xMenuPeer2.setViewable(true);
            String string = xMenuPeer2.getLabel();
            graphics.setFont(xMenuPeer2.getFont());
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n6 = (n2 + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
            int n7 = fontMetrics.stringWidth(string) + 20;
            if (xMenuPeer2 == xMenuPeer) {
                int n8 = n - n7;
                if (n8 >= n4) {
                    n4 = n8;
                } else {
                    xMenuPeer2.setViewable(false);
                }
            }
            if (n4 >= n) {
                xMenuPeer2.setViewable(false);
            }
            if (xMenuPeer2.isViewable()) {
                if (i == n3) {
                    graphics.setColor(this.getSelect());
                    graphics.fillRect(n4 + 1, 3, n7 - 1, n2 - 6);
                    this.draw3DRect(graphics, n4 + 1, 3, n7 - 2, n2 - 7, false);
                }
                graphics.setColor(xMenuPeer2.isEnabled() ? this.getForeground() : this.getDisabled());
                graphics.drawString(string, n4 + 10, n6);
            }
            n4 += n7;
        }
    }

    boolean contains(int n, int n2, int n3) {
        return n >= n3 && n < this.getWidth() - n3 && n2 >= n3 && n2 < this.getHeight() - n3;
    }

    void handleJavaMouseEvent(MouseEvent mouseEvent) {
        XMenuPeer xMenuPeer = this.getMenu();
        if ((mouseEvent.getModifiers() & 0x10) == 0) {
            return;
        }
        switch (mouseEvent.getID()) {
            case 501: {
                if (!(XAwtState.getGrabWindow() != this || this.contains(mouseEvent.getX(), mouseEvent.getY(), 0) || xMenuPeer != null && xMenuPeer.cascadeContains(this, mouseEvent.getPoint(), 0))) {
                    XMenuBarPeer.ungrabInput();
                    this.setMenuSelected(-1);
                    if (xMenuPeer != null) {
                        xMenuPeer.setPosted(false);
                        xMenuPeer.popdown(mouseEvent, false);
                        this.setMenu(null);
                    }
                    this.repaint();
                    break;
                }
                xMenuPeer = this.selectMenu(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                if (xMenuPeer == null) break;
                Point point = xMenuPeer.toLocal(this.toGlobal(mouseEvent.getX(), mouseEvent.getY()));
                MouseEvent mouseEvent2 = this.makeMouseEvent(mouseEvent, point.x, point.y);
                xMenuPeer.handleJavaMouseEvent(mouseEvent2);
                break;
            }
            case 502: {
                if (xMenuPeer != null && xMenuPeer.lastMenuContains(this, mouseEvent.getPoint(), 0)) {
                    xMenuPeer.setPosted(false);
                    xMenuPeer.popdown(mouseEvent, true);
                    this.setMenu(null);
                    this.setMenuSelected(-1);
                    this.repaint();
                    XMenuBarPeer.ungrabInput();
                    break;
                }
                this.doPosting(this, mouseEvent.getPoint(), 0);
                break;
            }
            case 506: {
                xMenuPeer = this.selectMenu(mouseEvent, mouseEvent.getX(), mouseEvent.getY());
                if (xMenuPeer == null) break;
                Point point = xMenuPeer.toLocal(this.toGlobal(mouseEvent.getX(), mouseEvent.getY()));
                MouseEvent mouseEvent3 = this.makeMouseEvent(mouseEvent, point.x, point.y);
                xMenuPeer.handleJavaMouseEvent(mouseEvent3);
            }
        }
    }

    void handleEscapeKeyPress() {
        this.doPosting(this, new Point(0, 0), 0);
        this.setMenuSelected(-1);
        XMenuBarPeer.ungrabInput();
        this.repaint();
    }

    void handleF10KeyPress() {
        XMenuPeer xMenuPeer = this.getMenu();
        if (this.getMenuSelected() == -1) {
            this.setMenuSelected(0);
            this.grabInput();
        } else {
            if (xMenuPeer != null && xMenuPeer.isPosted()) {
                xMenuPeer.setPosted(false);
                xMenuPeer.popdown(null, false);
                this.setMenu(null);
            }
            this.setMenuSelected(-1);
            XMenuBarPeer.ungrabInput();
        }
        this.repaint();
    }

    int getLeftSelected() {
        XMenuPeer xMenuPeer;
        MenuData[] menuDataArray = this.copyMenus();
        int n = menuDataArray.length;
        int n2 = this.getMenuSelected();
        do {
            int n3 = n2 = n2 == 0 ? n - 1 : n2 - 1;
        } while (!(xMenuPeer = menuDataArray[n2].menu).isEnabled() || !xMenuPeer.isViewable());
        return n2;
    }

    int getRightSelected() {
        XMenuPeer xMenuPeer;
        MenuData[] menuDataArray = this.copyMenus();
        int n = menuDataArray.length;
        int n2 = this.getMenuSelected();
        do {
            n2 = (n2 + 1) % n;
        } while (!(xMenuPeer = menuDataArray[n2].menu).isEnabled() || !xMenuPeer.isViewable());
        return n2;
    }

    public void handleKeyPress(long l) {
        final int n = this.nativeGetKeyCode(this.getFrame(), 401, l);
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                XMenuBarPeer.this.handleKeyPressOnEDT(n);
            }
        });
    }

    void handleKeyPressOnEDT(int n) {
        XMenuPeer xMenuPeer = this.getMenu();
        XMenuPeer xMenuPeer2 = null;
        int n2 = this.getMenuSelected();
        boolean bl = false;
        if (xMenuPeer != null) {
            bl = xMenuPeer.handleKeyPress1(n, null);
        }
        switch (n) {
            case 38: {
                break;
            }
            case 40: {
                if (bl) {
                    return;
                }
                if (n2 == -1 || xMenuPeer != null) break;
                xMenuPeer = this.selectMenuByKeyPress(n2, n);
                this.doPosting(this, new Point(0, 0), 0);
                break;
            }
            case 37: {
                if (bl) {
                    return;
                }
                xMenuPeer2 = this.getMenu();
                xMenuPeer = this.selectMenuByKeyPress(this.getLeftSelected(), n);
                if (xMenuPeer == xMenuPeer2) break;
                this.doPosting(this, new Point(0, 0), 0);
                break;
            }
            case 39: {
                if (bl) {
                    return;
                }
                xMenuPeer2 = this.getMenu();
                xMenuPeer = this.selectMenuByKeyPress(this.getRightSelected(), n);
                if (xMenuPeer == xMenuPeer2) break;
                this.doPosting(this, new Point(0, 0), 0);
                break;
            }
            case 10: 
            case 32: {
                if (bl) {
                    return;
                }
                if (n2 == -1) break;
                if (xMenuPeer == null) {
                    xMenuPeer = this.selectMenuByKeyPress(n2, n);
                    this.doPosting(this, new Point(0, 0), 0);
                    break;
                }
                xMenuPeer.setPosted(false);
                xMenuPeer.popdown(new MouseEvent(this.getEventSource(), 502, 0L, 0, 0, 0, 0, false), true);
                this.setMenu(null);
                this.setMenuSelected(-1);
                this.repaint();
                XMenuBarPeer.ungrabInput();
                break;
            }
            case 27: {
                this.handleEscapeKeyPress();
                break;
            }
            case 121: {
                this.handleF10KeyPress();
                break;
            }
        }
    }

    XMenuPeer doPosting(XMenuWindow xMenuWindow, Point point, int n) {
        XMenuPeer xMenuPeer = this.getMenu();
        Point point2 = new Point(point.x, point.y);
        if (this.contains(point2.x, point2.y, n)) {
            XMenuPeer xMenuPeer2 = xMenuPeer;
            if (xMenuPeer != null) {
                if (xMenuPeer.isPosted()) {
                    xMenuPeer.setPosted(false);
                    xMenuPeer.popdown(null, false);
                    this.setMenu(null);
                    this.setMenuSelected(-1);
                    this.repaint();
                    XMenuBarPeer.ungrabInput();
                } else {
                    xMenuPeer.setPosted(true);
                }
            }
            return xMenuPeer2;
        }
        if (xMenuPeer == null) {
            return null;
        }
        point2 = xMenuPeer.toLocal(xMenuWindow.toGlobal(point2));
        return xMenuPeer.doPosting(this, point2, n);
    }

    void print(Graphics graphics) {
        Object object;
        Frame frame = this.getFrame();
        Dimension dimension = frame.size();
        Insets insets = frame.insets();
        int n = dimension.width;
        int n2 = insets.top;
        if (this.getPeer(frame) instanceof XFramePeer) {
            object = (XFramePeer)this.getPeer(frame);
            if (((XWindowPeer)object).hasDecorations(XWindowAttributesData.AWT_DECOR_BORDER)) {
                n -= 12;
                n2 -= 6;
            }
            if (((XWindowPeer)object).hasDecorations(XWindowAttributesData.AWT_DECOR_MENU)) {
                n2 -= 17;
            }
        }
        object = new Dimension(n, n2);
        Shape shape = graphics.getClip();
        graphics.clipRect(0, 0, ((Dimension)object).width, ((Dimension)object).height);
        Color color = frame.getBackground();
        Color color2 = frame.getForeground();
        Color color3 = color.brighter();
        Color color4 = color.darker();
        if (color3.equals(Color.white)) {
            graphics.setColor(new Color(230, 230, 230));
        } else {
            graphics.setColor(color3);
        }
        graphics.drawLine(0, 0, ((Dimension)object).width, 0);
        graphics.drawLine(1, 1, ((Dimension)object).width - 1, 1);
        graphics.drawLine(0, 0, 0, ((Dimension)object).height);
        graphics.drawLine(1, 1, 1, ((Dimension)object).height - 1);
        graphics.setColor(color4);
        graphics.drawLine(((Dimension)object).width, 1, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(((Dimension)object).width - 1, 2, ((Dimension)object).width - 1, ((Dimension)object).height);
        graphics.drawLine(1, ((Dimension)object).height, ((Dimension)object).width, ((Dimension)object).height);
        graphics.drawLine(2, ((Dimension)object).height - 1, ((Dimension)object).width, ((Dimension)object).height - 1);
        int n3 = 10;
        MenuData[] menuDataArray = this.copyMenus();
        int n4 = menuDataArray.length;
        for (int i = 0; i < n4; ++i) {
            XMenuPeer xMenuPeer = menuDataArray[i].menu;
            String string = xMenuPeer.getLabel();
            Font font = this.getFont();
            graphics.setFont(font);
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n5 = ((Dimension)object).height / 2 + fontMetrics.getMaxDescent();
            int n6 = fontMetrics.stringWidth(string) + 20;
            if (n3 >= ((Dimension)object).width) break;
            if (xMenuPeer.isEnabled()) {
                graphics.setColor(color2);
            } else {
                graphics.setColor(color4);
            }
            if (this.getHelpMenu() == xMenuPeer) {
                graphics.drawString(string, ((Dimension)object).width - n6 + 10, n5);
                continue;
            }
            graphics.drawString(string, n3, n5);
            n3 += n6;
        }
        graphics.setClip(shape);
    }

    public void dispose() {
        Iterator iterator = this.menus.iterator();
        while (iterator.hasNext()) {
            XMenuPeer xMenuPeer = ((MenuData)iterator.next()).menu;
            if (xMenuPeer == null) continue;
            xMenuPeer.dispose();
        }
        super.dispose();
    }

    Menu targetGetHelpMenu() {
        try {
            return (Menu)f_helpMenu.get(this.menuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    XMenuPeer getHelpMenu() {
        return this.helpMenu;
    }

    void setHelpMenu(XMenuPeer xMenuPeer) {
        this.helpMenu = xMenuPeer;
    }

    int getMenuCount() {
        return this.menus.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final XMenuPeer getMenu(int n) {
        Vector vector = this.getMenus();
        synchronized (vector) {
            if (n < this.getMenus().size()) {
                return ((MenuData)this.getMenus().elementAt((int)n)).menu;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final int getMenuIndex(int n) {
        Vector vector = this.getMenus();
        synchronized (vector) {
            if (n < this.getMenus().size()) {
                return ((MenuData)this.getMenus().elementAt((int)n)).index;
            }
            return -1;
        }
    }

    Vector getMenus() {
        return this.menus;
    }

    void setMenus(Vector vector) {
        this.menus = vector;
    }

    Vector getTargetMenus() {
        try {
            return (Vector)f_menus.get(this.menuTarget);
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return null;
        }
    }

    XMenuPeer getMenu() {
        return this.menu;
    }

    void setMenu(XMenuPeer xMenuPeer) {
        this.menu = xMenuPeer;
    }

    int getMenuSelected() {
        return this.menuSelected;
    }

    void setMenuSelected(int n) {
        this.menuSelected = n;
    }

    class MenuData {
        XMenuPeer menu;
        int index;

        MenuData(XMenuPeer xMenuPeer, int n) {
            this.menu = xMenuPeer;
            this.index = n;
        }

        public String toString() {
            return this.getClass().getName() + "[menu=" + this.menu + ",index=" + this.index + "]";
        }
    }
}

