/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.MainSwatchPanel;
import javax.swing.colorchooser.RecentSwatchPanel;
import javax.swing.colorchooser.SwatchPanel;

class DefaultSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    KeyListener mainSwatchKeyListener;
    KeyListener recentSwatchKeyListener;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    public int getMnemonic() {
        return DefaultSwatchChooserPanel.getInt("ColorChooser.swatchesMnemonic", -1);
    }

    public int getDisplayedMnemonicIndex() {
        return DefaultSwatchChooserPanel.getInt("ColorChooser.swatchesDisplayedMnemonicIndex", -1);
    }

    public Icon getSmallDisplayIcon() {
        return null;
    }

    public Icon getLargeDisplayIcon() {
        return null;
    }

    public void installChooserPanel(JColorChooser jColorChooser) {
        super.installChooserPanel(jColorChooser);
    }

    protected void buildChooser() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(gridBagLayout);
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel();
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        this.mainSwatchKeyListener = new MainSwatchKeyListener();
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.swatchPanel.addKeyListener(this.mainSwatchKeyListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchKeyListener = new RecentSwatchKeyListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.addKeyListener(this.recentSwatchKeyListener);
        CompoundBorder compoundBorder = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        this.swatchPanel.setBorder(compoundBorder);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)this.swatchPanel, gridBagConstraints);
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        this.recentSwatchPanel.setBorder(compoundBorder);
        JPanel jPanel2 = new JPanel(new BorderLayout());
        JLabel jLabel = new JLabel(recentStr);
        jLabel.setLabelFor(this.recentSwatchPanel);
        jPanel2.add((Component)jLabel, "North");
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.gridheight = 1;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        jPanel.add((Component)this.recentSwatchPanel, gridBagConstraints);
        this.add(jPanel);
    }

    public void uninstallChooserPanel(JColorChooser jColorChooser) {
        super.uninstallChooserPanel(jColorChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.swatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            DefaultSwatchChooserPanel.this.swatchPanel.setSelectedColorFromLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
            DefaultSwatchChooserPanel.this.swatchPanel.requestFocus();
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.recentSwatchPanel.setSelectedColorFromLocation(mouseEvent.getX(), mouseEvent.getY());
            DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
            DefaultSwatchChooserPanel.this.recentSwatchPanel.requestFocus();
        }
    }

    class MainSwatchKeyListener
    extends KeyAdapter
    implements Serializable {
        MainSwatchKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 32: {
                    Color color = DefaultSwatchChooserPanel.this.swatchPanel.getSelectedColor();
                    DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
                    DefaultSwatchChooserPanel.this.recentSwatchPanel.setMostRecentColor(color);
                    break;
                }
            }
        }
    }

    class RecentSwatchKeyListener
    extends KeyAdapter
    implements Serializable {
        RecentSwatchKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 32: {
                    Color color = DefaultSwatchChooserPanel.this.recentSwatchPanel.getSelectedColor();
                    DefaultSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
                    break;
                }
            }
        }
    }
}

