/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.RectIterator;
import java.awt.geom.RectangularShape;

public abstract class Rectangle2D
extends RectangularShape {
    public static final int OUT_LEFT = 1;
    public static final int OUT_TOP = 2;
    public static final int OUT_RIGHT = 4;
    public static final int OUT_BOTTOM = 8;

    protected Rectangle2D() {
    }

    public abstract void setRect(double var1, double var3, double var5, double var7);

    public void setRect(Rectangle2D rectangle2D) {
        this.setRect(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean intersectsLine(double d, double d2, double d3, double d4) {
        int n;
        int n2 = this.outcode(d3, d4);
        if (n2 == 0) {
            return true;
        }
        while ((n = this.outcode(d, d2)) != 0) {
            double d5;
            if ((n & n2) != 0) {
                return false;
            }
            if ((n & 5) != 0) {
                d5 = this.getX();
                if ((n & 4) != 0) {
                    d5 += this.getWidth();
                }
                d2 += (d5 - d) * (d4 - d2) / (d3 - d);
                d = d5;
                continue;
            }
            d5 = this.getY();
            if ((n & 8) != 0) {
                d5 += this.getHeight();
            }
            d += (d5 - d2) * (d3 - d) / (d4 - d2);
            d2 = d5;
        }
        return true;
    }

    public boolean intersectsLine(Line2D line2D) {
        return this.intersectsLine(line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    public abstract int outcode(double var1, double var3);

    public int outcode(Point2D point2D) {
        return this.outcode(point2D.getX(), point2D.getY());
    }

    public void setFrame(double d, double d2, double d3, double d4) {
        this.setRect(d, d2, d3, d4);
    }

    public Rectangle2D getBounds2D() {
        return (Rectangle2D)this.clone();
    }

    public boolean contains(double d, double d2) {
        double d3 = this.getX();
        double d4 = this.getY();
        double d5 = this.getWidth();
        double d6 = this.getHeight();
        if (d5 < 0.0) {
            d3 += d5;
            d5 = 0.0 - d5;
        }
        if (d6 < 0.0) {
            d4 += d6;
            d6 = 0.0 - d6;
        }
        return d >= d3 && d2 >= d4 && d < d3 + d5 && d2 < d4 + d6;
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        if (this.isEmpty() || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getX();
        double d6 = this.getY();
        return d + d3 > d5 && d2 + d4 > d6 && d < d5 + this.getWidth() && d2 < d6 + this.getHeight();
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        if (this.isEmpty() || d3 <= 0.0 || d4 <= 0.0) {
            return false;
        }
        double d5 = this.getX();
        double d6 = this.getY();
        return d >= d5 && d2 >= d6 && d + d3 <= d5 + this.getWidth() && d2 + d4 <= d6 + this.getHeight();
    }

    public abstract Rectangle2D createIntersection(Rectangle2D var1);

    public static void intersect(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.max(rectangle2D.getMinX(), rectangle2D2.getMinX());
        double d2 = Math.max(rectangle2D.getMinY(), rectangle2D2.getMinY());
        double d3 = Math.min(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
        double d4 = Math.min(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
        rectangle2D3.setFrame(d, d2, d3 - d, d4 - d2);
    }

    public abstract Rectangle2D createUnion(Rectangle2D var1);

    public static void union(Rectangle2D rectangle2D, Rectangle2D rectangle2D2, Rectangle2D rectangle2D3) {
        double d = Math.min(rectangle2D.getMinX(), rectangle2D2.getMinX());
        double d2 = Math.min(rectangle2D.getMinY(), rectangle2D2.getMinY());
        double d3 = Math.max(rectangle2D.getMaxX(), rectangle2D2.getMaxX());
        double d4 = Math.max(rectangle2D.getMaxY(), rectangle2D2.getMaxY());
        rectangle2D3.setFrameFromDiagonal(d, d2, d3, d4);
    }

    public void add(double d, double d2) {
        double d3 = Math.min(this.getMinX(), d);
        double d4 = Math.max(this.getMaxX(), d);
        double d5 = Math.min(this.getMinY(), d2);
        double d6 = Math.max(this.getMaxY(), d2);
        this.setRect(d3, d5, d4 - d3, d6 - d5);
    }

    public void add(Point2D point2D) {
        this.add(point2D.getX(), point2D.getY());
    }

    public void add(Rectangle2D rectangle2D) {
        double d = Math.min(this.getMinX(), rectangle2D.getMinX());
        double d2 = Math.max(this.getMaxX(), rectangle2D.getMaxX());
        double d3 = Math.min(this.getMinY(), rectangle2D.getMinY());
        double d4 = Math.max(this.getMaxY(), rectangle2D.getMaxY());
        this.setRect(d, d3, d2 - d, d4 - d3);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new RectIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d) {
        return new RectIterator(this, affineTransform);
    }

    public int hashCode() {
        long l = java.lang.Double.doubleToLongBits(this.getX());
        l += java.lang.Double.doubleToLongBits(this.getY()) * 37L;
        l += java.lang.Double.doubleToLongBits(this.getWidth()) * 43L;
        return (int)(l += java.lang.Double.doubleToLongBits(this.getHeight()) * 47L) ^ (int)(l >> 32);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof Rectangle2D) {
            Rectangle2D rectangle2D = (Rectangle2D)object;
            return this.getX() == rectangle2D.getX() && this.getY() == rectangle2D.getY() && this.getWidth() == rectangle2D.getWidth() && this.getHeight() == rectangle2D.getHeight();
        }
        return false;
    }

    public static class Double
    extends Rectangle2D {
        public double x;
        public double y;
        public double width;
        public double height;

        public Double() {
        }

        public Double(double d, double d2, double d3, double d4) {
            this.setRect(d, d2, d3, d4);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0 || this.height <= 0.0;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = d;
            this.y = d2;
            this.width = d3;
            this.height = d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = rectangle2D.getX();
            this.y = rectangle2D.getY();
            this.width = rectangle2D.getWidth();
            this.height = rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (this.width <= 0.0) {
                n |= 5;
            } else if (d < this.x) {
                n |= 1;
            } else if (d > this.x + this.width) {
                n |= 4;
            }
            if (this.height <= 0.0) {
                n |= 0xA;
            } else if (d2 < this.y) {
                n |= 2;
            } else if (d2 > this.y + this.height) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D getBounds2D() {
            return new Double(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.intersect(this, rectangle2D, double_);
            return double_;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Double double_ = new Double();
            Rectangle2D.union(this, rectangle2D, double_);
            return double_;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }

    public static class Float
    extends Rectangle2D {
        public float x;
        public float y;
        public float width;
        public float height;

        public Float() {
        }

        public Float(float f, float f2, float f3, float f4) {
            this.setRect(f, f2, f3, f4);
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getWidth() {
            return this.width;
        }

        public double getHeight() {
            return this.height;
        }

        public boolean isEmpty() {
            return this.width <= 0.0f || this.height <= 0.0f;
        }

        public void setRect(float f, float f2, float f3, float f4) {
            this.x = f;
            this.y = f2;
            this.width = f3;
            this.height = f4;
        }

        public void setRect(double d, double d2, double d3, double d4) {
            this.x = (float)d;
            this.y = (float)d2;
            this.width = (float)d3;
            this.height = (float)d4;
        }

        public void setRect(Rectangle2D rectangle2D) {
            this.x = (float)rectangle2D.getX();
            this.y = (float)rectangle2D.getY();
            this.width = (float)rectangle2D.getWidth();
            this.height = (float)rectangle2D.getHeight();
        }

        public int outcode(double d, double d2) {
            int n = 0;
            if (this.width <= 0.0f) {
                n |= 5;
            } else if (d < (double)this.x) {
                n |= 1;
            } else if (d > (double)this.x + (double)this.width) {
                n |= 4;
            }
            if (this.height <= 0.0f) {
                n |= 0xA;
            } else if (d2 < (double)this.y) {
                n |= 2;
            } else if (d2 > (double)this.y + (double)this.height) {
                n |= 8;
            }
            return n;
        }

        public Rectangle2D getBounds2D() {
            return new Float(this.x, this.y, this.width, this.height);
        }

        public Rectangle2D createIntersection(Rectangle2D rectangle2D) {
            Rectangle2D rectangle2D2 = rectangle2D instanceof Float ? new Float() : new Double();
            Rectangle2D.intersect(this, rectangle2D, rectangle2D2);
            return rectangle2D2;
        }

        public Rectangle2D createUnion(Rectangle2D rectangle2D) {
            Rectangle2D rectangle2D2 = rectangle2D instanceof Float ? new Float() : new Double();
            Rectangle2D.union(this, rectangle2D, rectangle2D2);
            return rectangle2D2;
        }

        public String toString() {
            return this.getClass().getName() + "[x=" + this.x + ",y=" + this.y + ",w=" + this.width + ",h=" + this.height + "]";
        }
    }
}

