/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.WindowsGraphicsUtils;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicRadioButtonUI;

public class WindowsRadioButtonUI
extends BasicRadioButtonUI {
    private static final WindowsRadioButtonUI windowsRadioButtonUI = new WindowsRadioButtonUI();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    protected Color focusColor;
    private boolean initialized = false;

    public static ComponentUI createUI(JComponent jComponent) {
        return windowsRadioButtonUI;
    }

    public void installDefaults(AbstractButton abstractButton) {
        super.installDefaults(abstractButton);
        if (!this.initialized) {
            this.dashedRectGapX = (Integer)UIManager.get("Button.dashedRectGapX");
            this.dashedRectGapY = (Integer)UIManager.get("Button.dashedRectGapY");
            this.dashedRectGapWidth = (Integer)UIManager.get("Button.dashedRectGapWidth");
            this.dashedRectGapHeight = (Integer)UIManager.get("Button.dashedRectGapHeight");
            this.focusColor = UIManager.getColor(this.getPropertyPrefix() + "focus");
            this.initialized = true;
        }
        if (XPStyle.getXP() != null) {
            LookAndFeel.installProperty(abstractButton, "rolloverEnabled", Boolean.TRUE);
        }
    }

    protected void uninstallDefaults(AbstractButton abstractButton) {
        super.uninstallDefaults(abstractButton);
        this.initialized = false;
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    protected void paintText(Graphics graphics, AbstractButton abstractButton, Rectangle rectangle, String string) {
        WindowsGraphicsUtils.paintText(graphics, abstractButton, rectangle, string, this.getTextShiftOffset());
    }

    protected void paintFocus(Graphics graphics, Rectangle rectangle, Dimension dimension) {
        graphics.setColor(this.getFocusColor());
        BasicGraphicsUtils.drawDashedRect(graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        AbstractButton abstractButton = (AbstractButton)jComponent;
        if (dimension != null && abstractButton.isFocusPainted()) {
            if (dimension.width % 2 == 0) {
                ++dimension.width;
            }
            if (dimension.height % 2 == 0) {
                ++dimension.height;
            }
        }
        return dimension;
    }
}

