/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.gtk;

import com.sun.java.swing.plaf.gtk.GTKConstants;
import com.sun.java.swing.plaf.gtk.GTKEngine;
import com.sun.java.swing.plaf.gtk.GTKPainter;
import com.sun.java.swing.plaf.gtk.PixmapStyle;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.security.AccessController;
import javax.swing.JScrollBar;
import javax.swing.JSlider;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import sun.security.action.GetPropertyAction;

class PixmapEngine
extends GTKEngine
implements GTKConstants {
    private static final Object RENDERING_HINT = "true".equals(AccessController.doPrivileged(new GetPropertyAction("swing.pixmap.smoothScaling"))) ? RenderingHints.VALUE_INTERPOLATION_BILINEAR : null;
    private int _clipX1;
    private int _clipX2;
    private int _clipY1;
    private int _clipY2;

    PixmapEngine() {
    }

    public void paintSlider(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("SLIDER", string, n, n2, n7, -100, -100), true)) {
            super.paintSlider(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7);
        }
    }

    public void paintHline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (!this.paintPixmap(graphics, n2, n3, n4, n5, ((PixmapStyle)synthContext.getStyle()).getInfo("HLINE", string, n, -100, -100, -100, -100), true)) {
            super.paintHline(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    public void paintVline(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (!this.paintPixmap(graphics, n2, n3, n4, n5, ((PixmapStyle)synthContext.getStyle()).getInfo("VLINE", string, n, -100, -100, -100, -100), true)) {
            super.paintVline(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    public void paintArrow(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, String string, int n4, int n5, int n6, int n7) {
        if (!this.paintPixmap(graphics, n4, n5, n6, n7, ((PixmapStyle)synthContext.getStyle()).getInfo("ARROW", string, n, n2, -100, -100, n3), true)) {
            super.paintArrow(synthContext, graphics, n, n2, n3, string, n4, n5, n6, n7);
        }
    }

    public void paintBox(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        Region region = synthContext.getRegion();
        int n7 = region == Region.SCROLL_BAR ? (((JScrollBar)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1) : (region == Region.SLIDER_TRACK ? (((JSlider)synthContext.getComponent()).getOrientation() == 0 ? 0 : 1) : -100);
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("BOX", string, n, n2, n7, -100, -100), true)) {
            super.paintBox(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintBoxGap(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        PixmapStyle.Info info = ((PixmapStyle)synthContext.getStyle()).getInfo("BOX_GAP", string, n, n2, -100, n7, -100);
        if (info != null) {
            this.paintPixmap(graphics, n3, n4, n5, n6, info, true);
            int n10 = 0;
            Image image = info.getGapStartImage();
            Image image2 = info.getGapImage();
            Image image3 = info.getGapEndImage();
            if (n7 == 0 || n7 == 1) {
                if (image != null) {
                    n10 = image.getWidth(null);
                } else if (image2 != null) {
                    n10 = image2.getWidth(null);
                } else if (image3 != null) {
                    n10 = image3.getWidth(null);
                }
            } else if (image != null) {
                n10 = image.getHeight(null);
            } else if (image2 != null) {
                n10 = image2.getHeight(null);
            } else if (image3 != null) {
                n10 = image3.getHeight(null);
            }
            if (n10 <= 0) {
                return;
            }
            this.paintGapImage(graphics, n3, n4, n5, n6, image, info.getGapStartInsets(), n7, n10, 0, n8);
            this.paintGapImage(graphics, n3, n4, n5, n6, image2, info.getGapInsets(), n7, n10, n8, n9);
            this.paintGapImage(graphics, n3, n4, n5, n6, image3, info.getGapEndInsets(), n7, n10, n8 + n9, Integer.MAX_VALUE);
        } else {
            super.paintBoxGap(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7, n8, n9);
        }
    }

    public void paintHandle(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("HANDLE", string, n, n2, n7, -100, -100), true)) {
            super.paintHandle(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7);
        }
    }

    public void paintOption(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("OPTION", string, n, n2, -100, -100, -100), true)) {
            super.paintOption(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintFocus(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (!this.paintPixmap(graphics, n2, n3, n4, n5, ((PixmapStyle)synthContext.getStyle()).getInfo("FOCUS", string, n, -100, -100, -100, -100), true)) {
            super.paintFocus(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    public void paintShadow(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("SHADOW", string, n, n2, -100, -100, -100), false)) {
            super.paintShadow(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintExpander(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        super.paintExpander(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
    }

    public void paintCheck(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("CHECK", string, n, n2, -100, -100, -100), true)) {
            super.paintCheck(synthContext, graphics, n, n2, string, n3, n4, n5, n6);
        }
    }

    public void paintExtension(SynthContext synthContext, Graphics graphics, int n, int n2, String string, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (!this.paintPixmap(graphics, n3, n4, n5, n6, ((PixmapStyle)synthContext.getStyle()).getInfo("EXTENSION", string, n, n2, -100, n7, -100), true)) {
            super.paintExtension(synthContext, graphics, n, n2, string, n3, n4, n5, n6, n7, n8);
        }
    }

    public void paintFlatBox(SynthContext synthContext, Graphics graphics, int n, String string, int n2, int n3, int n4, int n5) {
        if (!this.paintPixmap(graphics, n2, n3, n4, n5, ((PixmapStyle)synthContext.getStyle()).getInfo("FLAT_BOX", string, n, -100, -100, -100, -100), true)) {
            super.paintFlatBox(synthContext, graphics, n, string, n2, n3, n4, n5);
        }
    }

    private void paintGapImage(Graphics graphics, int n, int n2, int n3, int n4, Image image, Insets insets, int n5, int n6, int n7, int n8) {
        if (image != null && n8 > 0) {
            switch (n5) {
                case 0: {
                    this.paintImage(graphics, n, n2 + n7, Math.min(n3, n6), Math.min(n4 - n2 - n7, n8), image, insets, true, false, true);
                    break;
                }
                case 1: {
                    this.paintImage(graphics, n + n3 - Math.min(n3, n6), n2 + n7, Math.min(n3, n6), Math.min(n4 - n2 - n7, n8), image, insets, true, false, true);
                    break;
                }
                case 2: {
                    this.paintImage(graphics, n + n7, n2, Math.min(n3 - n - n7, n8), Math.min(n4, n6), image, insets, true, false, true);
                    break;
                }
                case 3: {
                    this.paintImage(graphics, n + n7, n2 + n4 - Math.min(n4, n6), Math.min(n3 - n - n7, n8), Math.min(n4, n6), image, insets, true, false, true);
                }
            }
        }
    }

    private boolean paintPixmap(Graphics graphics, int n, int n2, int n3, int n4, PixmapStyle.Info info, boolean bl) {
        if (info != null) {
            Rectangle rectangle = graphics.getClipBounds();
            this._clipX1 = rectangle.x;
            this._clipY1 = rectangle.y;
            this._clipX2 = this._clipX1 + rectangle.width;
            this._clipY2 = this._clipY1 + rectangle.height;
            this.paintImage(graphics, n, n2, n3, n4, info.getImage(), info.getImageInsets(), info.getStretch(), false, bl);
            this.paintImage(graphics, n, n2, n3, n4, info.getOverlayImage(), info.getOverlayInsets(), info.getOverlayStretch(), true, bl);
            return true;
        }
        return false;
    }

    private void paintImage(Graphics graphics, int n, int n2, int n3, int n4, Image image, Insets insets, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (image == null) {
            return;
        }
        if (insets == null) {
            insets = GTKPainter.EMPTY_INSETS;
        }
        int n5 = image.getWidth(null);
        int n6 = image.getHeight(null);
        if (n5 <= 0 || n6 <= 0) {
            return;
        }
        Object object2 = RENDERING_HINT;
        if (object2 != null && bl) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            object = graphics2D.getRenderingHint(RenderingHints.KEY_INTERPOLATION);
            if (object == null) {
                object = RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
            }
            graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, object2);
        } else {
            object = null;
        }
        if (!bl) {
            if (bl2) {
                graphics.drawImage(image, n + n3 / 2 - n5 / 2, n2 + n4 / 2 - n6 / 2, null);
            } else {
                int n7 = 0;
                int n8 = n2 + n4;
                for (int i = n2; i < n8; i += n6 - n7) {
                    int n9 = 0;
                    int n10 = n + n3;
                    for (int j = n; j < n10; j += n5 - n9) {
                        int n11;
                        int n12 = Math.min(n10, j + n5 - n9);
                        if (this.intersectsClip(j, i, n12, n11 = Math.min(n8, i + n6 - n7))) {
                            graphics.drawImage(image, j, i, n12, n11, n9, n7, n9 + n12 - j, n7 + n11 - i, null);
                        }
                        n9 = 0;
                    }
                    n7 = 0;
                }
            }
        } else {
            int n13 = insets.top;
            int n14 = insets.left;
            int n15 = insets.bottom;
            int n16 = insets.right;
            if (n13 + n15 >= n6) {
                n15 = n13 = Math.max(0, n6 / 2 - 1);
            }
            if (n14 + n16 >= n5) {
                n14 = n16 = Math.max(0, n5 / 2 - 1);
            }
            if (n13 + n15 > n4) {
                n13 = n15 = Math.max(2, n4 / 2 - 1);
            }
            if (n14 + n16 > n3) {
                n14 = n16 = Math.max(2, n3 / 2 - 1);
            }
            if (n14 > 0 && n13 + n15 < n6) {
                this.drawChunk(image, graphics, bl, n, n2 + n13, n + n14, n2 + n4 - n15, 0, n13, n14, n6 - n15, false);
            }
            if (n14 > 0 && n13 > 0) {
                graphics.drawImage(image, n, n2, n + n14, n2 + n13, 0, 0, n14, n13, null);
            }
            if (n13 > 0 && n14 + n16 < n5) {
                this.drawChunk(image, graphics, bl, n + n14, n2, n + n3 - n16, n2 + n13, n14, 0, n5 - n16, n13, true);
            }
            if (n16 < n5 && n13 > 0) {
                graphics.drawImage(image, n + n3 - n16, n2, n + n3, n2 + n13, n5 - n16, 0, n5, n13, null);
            }
            if (n16 < n5 && n13 + n15 < n6) {
                this.drawChunk(image, graphics, bl, n + n3 - n16, n2 + n13, n + n3, n2 + n4 - n15, n5 - n16, n13, n5, n6 - n15, false);
            }
            if (n16 < n5 && n15 < n6) {
                graphics.drawImage(image, n + n3 - n16, n2 + n4 - n15, n + n3, n2 + n4, n5 - n16, n6 - n15, n5, n6, null);
            }
            if (n14 + n16 < n5 && n15 > 0) {
                this.drawChunk(image, graphics, bl, n + n14, n2 + n4 - n15, n + n3 - n16, n2 + n4, n14, n6 - n15, n5 - n16, n6, true);
            }
            if (n14 > 0 && n15 > 0) {
                graphics.drawImage(image, n, n2 + n4 - n15, n + n14, n2 + n4, 0, n6 - n15, n14, n6, null);
            }
            if (bl3 && n14 + n16 < n5 && n13 + n15 < n6) {
                graphics.drawImage(image, n + n14, n2 + n13, n + n3 - n16, n2 + n4 - n15, n14, n13, n5 - n16, n6 - n15, null);
            }
        }
        if (object != null) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_INTERPOLATION, object);
        }
    }

    private void drawChunk(Image image, Graphics graphics, boolean bl, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl2) {
        if (n3 - n <= 0 || n4 - n2 <= 0 || !this.intersectsClip(n, n2, n3, n4)) {
            return;
        }
        if (bl) {
            graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, null);
        } else {
            int n9;
            int n10;
            int n11 = n7 - n5;
            int n12 = n8 - n6;
            if (bl2) {
                n10 = n11;
                n9 = 0;
            } else {
                n10 = 0;
                n9 = n12;
            }
            while (n < n3 && n2 < n4) {
                int n13;
                int n14 = Math.min(n3, n + n11);
                if (this.intersectsClip(n, n2, n14, n13 = Math.min(n4, n2 + n12))) {
                    graphics.drawImage(image, n, n2, n14, n13, n5, n6, n5 + n14 - n, n6 + n13 - n2, null);
                }
                n += n10;
                n2 += n9;
            }
        }
    }

    private boolean intersectsClip(int n, int n2, int n3, int n4) {
        return !(n3 >= n && n3 <= this._clipX1 || n4 >= n2 && n4 <= this._clipY1 || this._clipX2 >= this._clipX1 && this._clipX2 <= n || this._clipY2 >= this._clipY1 && this._clipY2 <= n2);
    }
}

