/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.Reference;
import sun.misc.Cleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceQueue<T> {
    private Reference[] references = new Reference[128];
    private int head = 0;
    private int tail = 0;
    private boolean empty = true;
    private static final int DEFAULT_QUEUE_SIZE = 128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> poll() {
        Reference reference;
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                return null;
            }
            reference = this.references[this.head];
            this.references[this.head++] = null;
            reference.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            }
        }
        return reference;
    }

    public Reference<? extends T> remove() throws InterruptedException {
        return this.remove(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reference<? extends T> remove(long l) throws IllegalArgumentException, InterruptedException {
        Reference reference;
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (this.empty) {
                this.wait(l);
                if (this.empty) {
                    return null;
                }
            }
            reference = this.references[this.head];
            this.references[this.head++] = null;
            reference.dequeue();
            if (this.head == this.references.length) {
                this.head = 0;
            }
            if (this.head == this.tail) {
                this.empty = true;
            } else {
                this.notifyAll();
            }
        }
        return reference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean enqueue(Reference reference) {
        if (reference instanceof Cleaner) {
            reference.dequeue();
            ((Cleaner)reference).clean();
            return true;
        }
        ReferenceQueue referenceQueue = this;
        synchronized (referenceQueue) {
            if (!this.empty && this.head == this.tail) {
                int n = (int)((double)this.references.length * 1.1);
                Reference[] referenceArray = new Reference[n];
                System.arraycopy((Object)this.references, this.head, (Object)referenceArray, 0, this.references.length - this.head);
                if (this.tail > 0) {
                    System.arraycopy((Object)this.references, 0, (Object)referenceArray, this.references.length - this.head, this.tail);
                }
                this.head = 0;
                this.tail = this.references.length;
                this.references = referenceArray;
            }
            this.references[this.tail++] = reference;
            if (this.tail == this.references.length) {
                this.tail = 0;
            }
            this.empty = false;
            this.notifyAll();
        }
        return true;
    }
}

