/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

class J9VMInternals {
    private static final int UNINITIALIZED = 0;
    private static final int INITIALIZED = 1;
    private static final int FAILED = 2;
    private static final int UNVERIFIED = 3;
    private static Map exceptions;

    J9VMInternals() {
    }

    private static void completeInitialization() {
        exceptions = new WeakHashMap();
        ClassLoader.completeInitialization();
        Thread.currentThread().completeInitialization();
    }

    private static native void sendClassPrepareEvent(Class var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void verify(Class clazz) {
        block24: while (true) {
            Class clazz2;
            switch (J9VMInternals.getInitStatus(clazz)) {
                case 0: 
                case 1: 
                case 2: {
                    return;
                }
                case 3: {
                    Class clazz3 = clazz;
                    synchronized (clazz3) {
                        if (J9VMInternals.getInitStatus(clazz) != 3) {
                            continue block24;
                        }
                        J9VMInternals.setInitThread(clazz);
                    }
                    clazz2 = clazz.getSuperclass();
                    try {
                        if (clazz2 != null) {
                            J9VMInternals.verify(clazz2);
                        }
                        J9VMInternals.verifyImpl(clazz);
                    }
                    catch (Error error) {
                        J9VMInternals.setInitStatus(clazz, 3);
                        throw error;
                    }
                    catch (Throwable throwable) {
                        J9VMInternals.setInitStatus(clazz, 3);
                        throw new VerifyError(throwable.toString());
                    }
                    clazz3 = clazz;
                    synchronized (clazz3) {
                        if (J9VMInternals.getInitThread(clazz) && (J9VMInternals.getInitStatus(clazz) & 3) == 3) {
                            J9VMInternals.setInitStatus(clazz, 0);
                        }
                    }
                    return;
                }
            }
            clazz2 = clazz;
            synchronized (clazz2) {
                int n = J9VMInternals.getInitStatus(clazz);
                if ((n & 0xFFFFFFFC) == 0) {
                    continue;
                }
                if ((n & 3) != 3) {
                    return;
                }
                if (!J9VMInternals.getInitThread(clazz)) {
                    try {
                        clazz.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            try {
                J9VMInternals.verifyImpl(clazz);
            }
            catch (Error error) {
                J9VMInternals.setInitStatus(clazz, 3);
                throw error;
            }
            catch (Throwable throwable) {
                J9VMInternals.setInitStatus(clazz, 3);
                throw new VerifyError(throwable.toString());
            }
            clazz2 = clazz;
            synchronized (clazz2) {
                if (J9VMInternals.getInitThread(clazz) && (J9VMInternals.getInitStatus(clazz) & 3) == 3) {
                    J9VMInternals.setInitStatus(clazz, 0);
                }
            }
        }
    }

    private static native void verifyImpl(Class var0) throws Throwable;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initialize(Class clazz) throws Throwable {
        block31: while (true) {
            Object object;
            switch (J9VMInternals.getInitStatus(clazz)) {
                case 1: {
                    return;
                }
                case 3: {
                    J9VMInternals.verify(clazz);
                    continue block31;
                }
                case 2: {
                    NoClassDefFoundError noClassDefFoundError = new NoClassDefFoundError(clazz.getName() + " (initialization failure)");
                    if (exceptions != null) {
                        object = exceptions;
                        synchronized (object) {
                            Throwable throwable = (Throwable)exceptions.get(clazz);
                            if (throwable != null) {
                                noClassDefFoundError.initCause(throwable);
                            }
                        }
                    }
                    throw noClassDefFoundError;
                }
                case 0: {
                    Class clazz2 = clazz;
                    synchronized (clazz2) {
                        if (J9VMInternals.getInitStatus(clazz) != 0) {
                            continue block31;
                        }
                        J9VMInternals.setInitThread(clazz);
                    }
                    object = clazz.getSuperclass();
                    if (object != null) {
                        try {
                            J9VMInternals.initialize((Class)object);
                        }
                        catch (Error error) {
                            J9VMInternals.setInitStatus(clazz, 2);
                            if (exceptions == null) {
                                exceptions = new WeakHashMap();
                            }
                            Map map = exceptions;
                            synchronized (map) {
                                Throwable throwable = error;
                                if (error instanceof ExceptionInInitializerError) {
                                    throwable = ((ExceptionInInitializerError)error).getException();
                                }
                                exceptions.put(clazz, J9VMInternals.copyThrowable(throwable));
                            }
                            throw error;
                        }
                    }
                    J9VMInternals.sendClassPrepareEvent(clazz);
                    try {
                        J9VMInternals.initializeImpl(clazz);
                    }
                    catch (Error error) {
                        J9VMInternals.setInitStatus(clazz, 2);
                        if (exceptions == null) {
                            exceptions = new WeakHashMap();
                        }
                        Map map = exceptions;
                        synchronized (map) {
                            exceptions.put(clazz, J9VMInternals.copyThrowable(error));
                        }
                        throw error;
                    }
                    catch (Throwable throwable) {
                        J9VMInternals.setInitStatus(clazz, 2);
                        if (exceptions == null) {
                            exceptions = new WeakHashMap();
                        }
                        Map map = exceptions;
                        synchronized (map) {
                            exceptions.put(clazz, J9VMInternals.copyThrowable(throwable));
                        }
                        throw new ExceptionInInitializerError(throwable);
                    }
                    J9VMInternals.setInitStatus(clazz, 1);
                    return;
                }
            }
            object = clazz;
            synchronized (object) {
                int n = J9VMInternals.getInitStatus(clazz);
                if ((n & 0xFFFFFFFC) == 0) {
                    continue;
                }
                if ((n & 3) == 0) {
                    if (J9VMInternals.getInitThread(clazz)) {
                        return;
                    }
                    try {
                        clazz.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            J9VMInternals.verify(clazz);
        }
    }

    private static Throwable copyThrowable(Throwable throwable) {
        Throwable throwable2 = new Throwable(throwable.toString());
        throwable2.setStackTrace(throwable.getStackTrace());
        Throwable throwable3 = throwable2;
        HashMap<Throwable, Throwable> hashMap = new HashMap<Throwable, Throwable>();
        hashMap.put(throwable, throwable);
        for (Throwable throwable4 = throwable.getCause(); throwable4 != null && hashMap.get(throwable4) == null; throwable4 = throwable4.getCause()) {
            hashMap.put(throwable4, throwable4);
            Throwable throwable5 = new Throwable(throwable4.toString());
            throwable5.setStackTrace(throwable4.getStackTrace());
            throwable3.initCause(throwable5);
            throwable3 = throwable5;
        }
        return throwable2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInitStatus(Class clazz, int n) {
        Class clazz2 = clazz;
        synchronized (clazz2) {
            J9VMInternals.setInitStatusImpl(clazz, n);
            clazz.notifyAll();
        }
    }

    private static native int getInitStatus(Class var0);

    private static native void setInitStatusImpl(Class var0, int var1);

    private static native void initializeImpl(Class var0) throws Throwable;

    private static native boolean getInitThread(Class var0);

    private static native void setInitThread(Class var0);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void threadCleanup(Thread thread) {
        try {
            thread.threadGroup.remove(thread);
        }
        finally {
            thread.threadGroup = null;
            Object object = thread.lock;
            synchronized (object) {
                thread.threadRef = 0L;
            }
            object = thread;
            synchronized (object) {
                thread.notifyAll();
            }
        }
    }

    private static void checkPackageAccess(Class clazz) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPackageAccess(clazz.getPackageName());
        }
    }
}

