/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Msg;
import com.ibm.oti.util.Util;
import com.ibm.oti.vm.JxeException;
import com.ibm.oti.vm.JxeMetaData;
import com.ibm.oti.vm.JxePermission;
import com.ibm.oti.vm.JxeResource;
import com.ibm.oti.vm.JxeResourceTable;
import com.ibm.oti.vm.JxeUtil;
import com.ibm.oti.vm.MemInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public final class Jxe {
    long romSegmentPointer;
    private boolean allocated;
    private String uuid;
    private long jxePointer;
    private Hashtable resTable;
    static final int DEFLATED = 8;
    static final int STORED = 0;

    public static Jxe fromInputStream(InputStream inputStream, int n) throws JxeException, IOException {
        Jxe jxe;
        long l = Jxe.nativeMalloc(n + 7);
        if (0L == l) {
            throw new OutOfMemoryError(Msg.getString("K019a", n + 7));
        }
        int n2 = (int)(l & 7L);
        long l2 = n2 == 0 ? l : l + (long)(8 - n2);
        try {
            Jxe.copyStreamToMemory(inputStream, n, l2);
        }
        catch (IOException iOException) {
            Jxe.nativeFree(l);
            throw iOException;
        }
        try {
            jxe = new Jxe(l, true);
            JxeMetaData jxeMetaData = jxe.getJxeMetaData();
            JxeUtil.relocateJxeInPlace(l2);
            jxe.uuid = jxeMetaData.getUuid();
        }
        catch (JxeException jxeException) {
            Jxe.nativeFree(l);
            throw jxeException;
        }
        JxeUtil.registerJxe(jxe);
        return jxe;
    }

    static void copyStreamToMemory(InputStream inputStream, int n, long l) throws IOException {
        int n2;
        byte[] byArray = new byte[n < 4096 ? n : 4096];
        for (int i = 0; i < n; i += n2) {
            int n3 = n - i;
            n2 = inputStream.read(byArray, 0, n3 <= byArray.length ? n3 : byArray.length);
            if (-1 == n2) {
                throw new IOException(Msg.getString("K019b", i));
            }
            Jxe.nativeMemcpy(l + (long)i, byArray, 0, n2);
        }
    }

    public static Jxe fromFile(File file) throws JxeException, IOException {
        if (!file.exists()) {
            throw new FileNotFoundException(file.getPath());
        }
        byte[] byArray = Util.getBytes(file.getPath());
        long l = Jxe.nativeLoadJxeFromFileByteArray(byArray);
        Jxe jxe = new Jxe(l, false);
        JxeMetaData jxeMetaData = jxe.getJxeMetaData();
        jxe.uuid = jxeMetaData.getUuid();
        return jxe;
    }

    Jxe(long l, boolean bl) {
        this.jxePointer = l;
        this.allocated = bl;
    }

    public static Jxe fromPointer(long l) throws JxeException {
        JxeUtil.relocateJxeInPlace(l);
        return new Jxe(l, false);
    }

    long getJxePointer() {
        int n;
        if (this.allocated && (n = (int)(this.jxePointer & 7L)) != 0) {
            return this.jxePointer + (long)(8 - n);
        }
        return this.jxePointer;
    }

    long getJxeAlloc() {
        return this.allocated ? this.jxePointer : 0L;
    }

    public JxeMetaData getJxeMetaData() {
        return new JxeMetaData(this);
    }

    public String[] getClassList() {
        return Jxe.nativeGetClassList(this.jxePointer);
    }

    public InputStream getResourceAsStream(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new JxePermission(this.getUuid()));
        }
        return this.internalGetResourceAsStream(string);
    }

    InputStream internalGetResourceAsStream(String string) {
        if (this.jxePointer == 0L) {
            return null;
        }
        this.initializeResTable();
        while (true) {
            JxeResource jxeResource;
            if (null != (jxeResource = (JxeResource)this.resTable.get(string))) {
                MemInputStream memInputStream = new MemInputStream(jxeResource.getPointer(), jxeResource.getSize(), this);
                if (jxeResource.getMethod() != 0) {
                    return new InflaterInputStream(memInputStream, new Inflater(true));
                }
                return memInputStream;
            }
            if (!string.startsWith("/", 0)) {
                return null;
            }
            string = string.substring(1);
        }
    }

    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = this.getJxeMetaData().getUuid();
        }
        return this.uuid;
    }

    private void free() {
        if (this.allocated && this.jxePointer != 0L && this.romSegmentPointer == 0L) {
            Jxe.nativeFree(this.jxePointer);
            this.jxePointer = 0L;
        }
    }

    public void finalize() {
        if (!JxeUtil.unregisterJxe(this)) {
            this.free();
        }
    }

    private void initializeResTable() {
        JxeResourceTable jxeResourceTable;
        if (null != this.resTable) {
            return;
        }
        try {
            jxeResourceTable = new JxeResourceTable(new MemInputStream(this.getJxePointer(), Integer.MAX_VALUE, null));
        }
        catch (IOException iOException) {
            this.resTable = new Hashtable(0);
            return;
        }
        this.resTable = jxeResourceTable.getTable();
    }

    private static native String[] nativeGetClassList(long var0);

    private static native long nativeLoadJxeFromFileByteArray(byte[] var0);

    private static native void nativeMemcpy(long var0, byte[] var2, int var3, int var4);

    private static native long nativeMalloc(int var0);

    private static native void nativeFree(long var0);
}

