/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public abstract class AbstractClassLoader
extends ClassLoader {
    private static ClassLoader systemClassLoader;
    String[] parsedPath;
    int[] types;
    Object[] cache;
    FilePermission[] permissions;

    public AbstractClassLoader() {
    }

    public AbstractClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    void fillCache(int n) {
        this.types[n] = VM.getClassPathEntryType(this, n);
        switch (this.types[n]) {
            case 0: {
                this.cache[n] = this.cache;
                return;
            }
            case 1: 
            case 2: {
                String string;
                if (this.parsedPath[n] == null) {
                    this.parsedPath[n] = Util.toString(VM.getPathFromClassPath(n));
                }
                File file = new File(this.parsedPath[n]);
                try {
                    string = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    string = file.getAbsolutePath();
                }
                if (this.types[n] == 1) {
                    if (string.charAt(string.length() - 1) != File.separatorChar) {
                        string = new StringBuffer(string.length() + 1).append(string).append(File.separatorChar).toString();
                    }
                    this.parsedPath[n] = string;
                    this.cache[n] = this.cache;
                } else {
                    this.parsedPath[n] = string;
                    try {
                        JarFile jarFile = new JarFile(this.parsedPath[n]);
                        this.cache[n] = jarFile;
                        return;
                    }
                    catch (IOException iOException) {
                        this.types[n] = 5;
                        this.cache[n] = this.cache;
                    }
                }
                return;
            }
            case 4: {
                this.types[n] = 5;
            }
            case 3: 
            case 5: {
                this.cache[n] = this.cache;
                return;
            }
        }
    }

    public InputStream getResourceAsStream(String string) {
        InputStream inputStream;
        if (string == null || string.length() < 1 || string.charAt(0) == '/') {
            return null;
        }
        if (this != systemClassLoader && (inputStream = this.getParent() == null ? systemClassLoader.getResourceAsStream(string) : this.getParent().getResourceAsStream(string)) != null) {
            return inputStream;
        }
        block10: for (int i = 0; i < this.cache.length; ++i) {
            try {
                if (this.cache[i] == null) {
                    this.fillCache(i);
                }
                switch (this.types[i]) {
                    case 2: {
                        Serializable serializable;
                        ZipFile zipFile = (ZipFile)this.cache[i];
                        ZipEntry zipEntry = zipFile.getEntry(string);
                        if (zipEntry == null) continue block10;
                        Object object = System.getSecurityManager();
                        if (object != null) {
                            if (this.permissions == null) {
                                this.permissions = new FilePermission[this.cache.length];
                            }
                            if ((serializable = this.permissions[i]) == null) {
                                this.permissions[i] = new FilePermission(this.parsedPath[i], "read");
                                serializable = this.permissions[i];
                            }
                            ((SecurityManager)object).checkPermission((Permission)serializable);
                        }
                        try {
                            return zipFile.getInputStream(zipEntry);
                        }
                        catch (IOException iOException) {
                            break;
                        }
                    }
                    case 1: {
                        Object object = new StringBuffer(this.parsedPath[i].length() + string.length()).append(this.parsedPath[i]).append(string).toString();
                        Serializable serializable = new File((String)object);
                        if (!((File)serializable).exists()) continue block10;
                        try {
                            return new BufferedInputStream(new FileInputStream((File)serializable));
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            break;
                        }
                    }
                }
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    protected URL findResource(final String string) {
        SecurityManager securityManager;
        URL uRL = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL uRL = AbstractClassLoader.this.findResourceImpl(i, string);
                    if (uRL == null) continue;
                    return uRL;
                }
                return null;
            }
        });
        if (uRL != null && (securityManager = System.getSecurityManager()) != null) {
            try {
                securityManager.checkPermission(uRL.openConnection().getPermission());
            }
            catch (IOException iOException) {
                return null;
            }
            catch (SecurityException securityException) {
                return null;
            }
        }
        return uRL;
    }

    private URL findResourceImpl(int n, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        if (string.charAt(0) == '/') {
            return null;
        }
        if (this.cache[n] == null) {
            this.fillCache(n);
        }
        try {
            switch (this.types[n]) {
                case 2: {
                    ZipFile zipFile = (ZipFile)this.cache[n];
                    if (zipFile.getEntry(string) != null) {
                        return new URL("jar", null, -1, AbstractClassLoader.toURLString(this.parsedPath[n]) + "!/" + string, null);
                    }
                    return null;
                }
                case 1: {
                    String string2 = new StringBuffer(this.parsedPath[n].length() + string.length()).append(this.parsedPath[n]).append(string).toString();
                    File file = new File(string2);
                    if (file.exists()) {
                        return new URL(AbstractClassLoader.toURLString(string2));
                    }
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    protected Enumeration findResources(final String string) throws IOException {
        SecurityManager securityManager;
        Vector<URL> vector = (Vector<URL>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Vector<URL> vector = new Vector<URL>();
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL uRL = AbstractClassLoader.this.findResourceImpl(i, string);
                    if (uRL == null) continue;
                    vector.addElement(uRL);
                }
                return vector;
            }
        });
        int n = vector.size();
        if (n > 0 && (securityManager = System.getSecurityManager()) != null) {
            Vector<URL> vector2 = new Vector<URL>(n);
            for (int i = 0; i < n; ++i) {
                URL uRL = (URL)vector.elementAt(i);
                try {
                    securityManager.checkPermission(uRL.openConnection().getPermission());
                    vector2.addElement(uRL);
                    continue;
                }
                catch (IOException iOException) {
                    continue;
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            vector = vector2;
        }
        return vector.elements();
    }

    static String toURLString(String string) {
        String string2 = string;
        if (File.separatorChar != '/') {
            string2 = string2.replace(File.separatorChar, '/');
        }
        StringBuffer stringBuffer = new StringBuffer(string2.length() + 6).append("file:");
        if (!string2.startsWith("/")) {
            stringBuffer.append('/');
        }
        string2 = stringBuffer.append(string2).toString();
        return string2;
    }

    public static void setBootstrapClassLoader(ClassLoader classLoader) {
        if (systemClassLoader != null) {
            throw new IllegalArgumentException();
        }
        systemClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void definePackage(String string, final int n) {
        Object object;
        if (n >= 0 && this.cache[n] == null) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AbstractClassLoader.this.fillCache(n);
                    return null;
                }
            });
        }
        if (n >= 0 && this.types[n] == 2) {
            Object object2;
            object = null;
            try {
                object2 = (JarFile)this.cache[n];
                object = ((JarFile)object2).getManifest();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (object != null) {
                object2 = this.types;
                synchronized (this.types) {
                    if (super.getPackage(string) != null) {
                        // ** MonitorExit[var4_4] (shouldn't be in output)
                        return;
                    }
                    Attributes attributes = ((Manifest)object).getMainAttributes();
                    String string2 = attributes.getValue(Attributes.Name.SEALED);
                    boolean bl = string2 != null && string2.toLowerCase().equals("true");
                    String string3 = string.replace('.', '/') + "/";
                    Attributes attributes2 = ((Manifest)object).getAttributes(string3);
                    if (attributes2 != null && (string2 = attributes2.getValue(Attributes.Name.SEALED)) != null) {
                        bl = string2.toLowerCase().equals("true");
                    }
                    URL uRL = null;
                    try {
                        if (bl) {
                            uRL = new URL(AbstractClassLoader.toURLString(this.parsedPath[n]));
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                    this.definePackage(string, attributes.getValue(Attributes.Name.SPECIFICATION_TITLE), attributes.getValue(Attributes.Name.SPECIFICATION_VERSION), attributes.getValue(Attributes.Name.SPECIFICATION_VENDOR), attributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), attributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION), attributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR), uRL);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return;
                }
            }
        }
        object = this.types;
        synchronized (this.types) {
            if (super.getPackage(string) != null) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            this.definePackage(string, null, null, null, null, null, null, null);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    String getPackageName(Class clazz) {
        String string = clazz.getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return null;
        }
        return string.substring(0, n);
    }
}

