/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.util;

import com.ibm.oti.util.Msg;
import com.ibm.oti.vm.VM;
import java.io.ByteArrayOutputStream;
import java.io.UTFDataFormatException;
import java.io.UnsupportedEncodingException;

public final class Util {
    private static final boolean useNative = VM.useNatives();
    private static final String defaultEncoding;

    public static byte[] getBytes(String string) {
        if (defaultEncoding != null) {
            try {
                return string.getBytes(defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return string.getBytes();
    }

    public static String toString(byte[] byArray) {
        if (defaultEncoding != null) {
            try {
                return new String(byArray, 0, byArray.length, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(byArray, 0, byArray.length);
    }

    public static String toString(byte[] byArray, int n, int n2) {
        if (defaultEncoding != null) {
            try {
                return new String(byArray, n, n2, defaultEncoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return new String(byArray, n, n2);
    }

    private static native String convertUTF8(byte[] var0, int var1, int var2);

    public static String convertFromUTF8(byte[] byArray, int n, int n2) throws UTFDataFormatException {
        if (useNative) {
            String string = Util.convertUTF8(byArray, n, n2);
            if (string != null) {
                return string;
            }
            throw new UTFDataFormatException();
        }
        return Util.convertUTF8WithBuf(byArray, new char[n2], n, n2);
    }

    public static String convertUTF8WithBuf(byte[] byArray, char[] cArray, int n, int n2) throws UTFDataFormatException {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            byte by;
            if ((cArray[n4] = (char)byArray[n + n3++]) < '\u0080') {
                ++n4;
                continue;
            }
            char c = cArray[n4];
            if ((c & 0xE0) == 192) {
                if (n3 >= n2) {
                    throw new UTFDataFormatException(Msg.getString("K0062", n3));
                }
                if (((by = byArray[n3++]) & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0062", n3 - 1));
                }
                cArray[n4++] = (char)((c & 0x1F) << 6 | by & 0x3F);
                continue;
            }
            if ((c & 0xF0) == 224) {
                if (n3 + 1 >= n2) {
                    throw new UTFDataFormatException(Msg.getString("K0063", n3 + 1));
                }
                by = byArray[n3++];
                byte by2 = byArray[n3++];
                if ((by & 0xC0) != 128 || (by2 & 0xC0) != 128) {
                    throw new UTFDataFormatException(Msg.getString("K0064", n3 - 2));
                }
                cArray[n4++] = (char)((c & 0xF) << 12 | (by & 0x3F) << 6 | by2 & 0x3F);
                continue;
            }
            throw new UTFDataFormatException(Msg.getString("K0065", n3 - 1));
        }
        return new String(cArray, 0, n4);
    }

    public static String decode(String string, boolean bl) {
        if (!bl && string.indexOf(37) == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (bl && c == '+') {
                stringBuffer.append(' ');
            } else {
                if (c == '%') {
                    byteArrayOutputStream.reset();
                    do {
                        if (n + 2 >= string.length()) {
                            throw new IllegalArgumentException(Msg.getString("K01fe", n));
                        }
                        int n2 = Character.digit(string.charAt(n + 1), 16);
                        int n3 = Character.digit(string.charAt(n + 2), 16);
                        if (n2 == -1 || n3 == -1) {
                            throw new IllegalArgumentException(Msg.getString("K01ff", string.substring(n, n + 3), String.valueOf(n)));
                        }
                        byteArrayOutputStream.write((byte)((n2 << 4) + n3));
                    } while ((n += 3) < string.length() && string.charAt(n) == '%');
                    stringBuffer.append(byteArrayOutputStream.toString());
                    continue;
                }
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        String string = System.getProperty("os.encoding");
        if (string != null) {
            try {
                "".getBytes(string);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                string = null;
            }
        }
        defaultEncoding = string;
    }
}

