/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.ui;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertificateDialog;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.ui.FancyButton;
import com.sun.deploy.ui.MoreInfoDialog;
import com.sun.deploy.ui.UIFactory;
import com.sun.deploy.ui.UITextArea;
import com.sun.deploy.util.DialogListener;
import com.sun.deploy.util.Trace;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Iterator;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;

public class DialogTemplate
implements ActionListener {
    private JDialog dialog = null;
    private AppInfo ainfo = null;
    private String topText = null;
    private String appTitle = null;
    private String appPublisher = null;
    private URL appURL = null;
    private Frame dummyFrame = null;
    private boolean useErrorIcon = false;
    private boolean useSevereWarningIcon = false;
    private boolean useWarningIcon = false;
    private boolean useInfoIcon = false;
    private JPanel topPanel;
    private JPanel centerPanel;
    private JPanel bottomPanel;
    private JLabel topIcon;
    private JLabel securityIcon;
    private JLabel nameInfo;
    private JLabel publisherInfo;
    private JLabel urlInfo;
    private JButton okBtn;
    private JButton cancelBtn;
    private JCheckBox always;
    private UITextArea masthead = null;
    private static final int ICON_SIZE = 48;
    private int userAnswer = -1;
    private final int DIALOG_WIDTH = 510;
    private final int MAX_LARGE_SCROLL_WIDTH = 600;
    private final Color BG = Color.white;
    private final String SECURITY_ALERT_HIGH = "com/sun/deploy/resources/image/security_high.png";
    private final String SECURITY_ALERT_LOW = "com/sun/deploy/resources/image/security_low.png";
    private static int MAIN_TEXT_WIDTH = 426;
    private final String OK_ACTION = "OK";
    private final int MAX_BUTTONS = 2;
    private int start;
    private int end;
    private Certificate[] certs;
    private String[] alertStrs;
    private String[] infoStrs;
    private int securityInfoCount;
    private Color originalColor;
    private Cursor handCursor = new Cursor(12);
    private Cursor originalCursor = null;
    private String contentString = null;
    private String contentLabel = null;
    private String alwaysString = null;
    private boolean contentScroll = false;
    private boolean includeMasthead = true;
    private boolean includeAppInfo = true;
    private boolean largeScroll = false;
    private Throwable throwable = null;
    private JPanel detailPanel = null;
    private JList scrollList;
    private boolean showDetails = false;
    HashMap clientAuthCertsMap;
    int minFontSize = ResourceManager.getMinFontSize();

    DialogTemplate(AppInfo appInfo, Component component, String string, String string2) {
        Component component2 = this.deriveParent(component, string);
        this.dialog = component2 instanceof Dialog ? new JDialog((Dialog)component2, true) : new JDialog((Frame)component2, true);
        this.dialog.setTitle(string);
        this.ainfo = appInfo;
        this.topText = string2;
        this.appTitle = appInfo.getTitle();
        this.appPublisher = appInfo.getVendor();
        this.appURL = appInfo.getFrom();
    }

    void setSecurityContent(boolean bl, boolean bl2, String string, String string2, String[] stringArray, String[] stringArray2, int n, boolean bl3, Certificate[] certificateArray, int n2, int n3, boolean bl4) {
        this.certs = certificateArray;
        this.start = n2;
        this.end = n3;
        this.alertStrs = stringArray;
        this.infoStrs = stringArray2;
        this.securityInfoCount = n;
        if (stringArray != null && stringArray.length > 0) {
            this.useWarningIcon = true;
            if (bl4) {
                this.useSevereWarningIcon = true;
            }
        }
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(), "North");
            if (bl) {
                this.alwaysString = ResourceManager.getString("security.dialog.always");
            }
            this.dialog.getContentPane().add((Component)this.createCenterPanel(bl2, string, string2), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(bl3), "South");
            this.dialog.pack();
            this.dialog.setResizable(false);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    void setSimpleContent(String string, boolean bl, String string2, String string3, String string4, boolean bl2, boolean bl3) {
        this.contentString = string;
        this.contentScroll = bl;
        this.throwable = this.throwable;
        this.detailPanel = this.detailPanel;
        this.includeMasthead = bl2;
        this.includeAppInfo = bl2;
        this.largeScroll = !bl2;
        this.useWarningIcon = bl3;
        if (string2 != null) {
            String[] stringArray = new String[]{string2};
            if (bl3) {
                this.alertStrs = stringArray;
            } else {
                this.infoStrs = stringArray;
            }
        }
        try {
            this.dialog.getContentPane().setLayout(new BorderLayout());
            this.dialog.getContentPane().add((Component)this.createTopPanel(), "North");
            this.dialog.getContentPane().add((Component)this.createCenterPanel(false, string3, string4), "Center");
            this.dialog.getContentPane().add((Component)this.createBottomPanel(false), "South");
            this.dialog.pack();
            boolean bl4 = bl;
            this.dialog.setResizable(bl4);
        }
        catch (Throwable throwable) {
            Trace.ignored(throwable);
        }
    }

    private JPanel createTopPanel() {
        Accessible accessible;
        this.topPanel = new JPanel();
        this.topPanel.setBackground(this.BG);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.topPanel.setLayout(gridBagLayout);
        int n = ResourceManager.getUIFont().getSize() + 4;
        this.masthead = new UITextArea(n, MAIN_TEXT_WIDTH, true);
        this.masthead.setText(this.topText);
        Dimension dimension = this.masthead.getPreferredSize();
        this.masthead.setSize(dimension.width, dimension.height);
        this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
        if (this.includeMasthead) {
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridwidth = -1;
            gridBagConstraints.anchor = 17;
            gridBagLayout.setConstraints(this.masthead, gridBagConstraints);
            this.topPanel.add(this.masthead);
            this.topPanel.setBackground(Color.white);
            this.topPanel.setForeground(Color.white);
            this.topPanel.setOpaque(true);
            this.topIcon = new JLabel();
            this.topIcon.setHorizontalAlignment(0);
            this.topIcon.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 12));
            accessible = ResourceManager.getIcon("java48.image");
            if (this.useErrorIcon) {
                accessible = ResourceManager.getIcon("error48.image");
            }
            if (this.useInfoIcon) {
                accessible = ResourceManager.getIcon("info48.image");
            }
            this.topIcon.setIcon((Icon)((Object)accessible));
            if (this.useWarningIcon) {
                accessible = this.useSevereWarningIcon ? ResourceManager.getIcon("major-warning48.image") : ResourceManager.getIcon("warning48.image");
                this.topIcon.setIcon((Icon)((Object)accessible));
            } else if (this.ainfo.getIconRef() != null) {
                // empty if block
            }
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.anchor = 13;
            gridBagLayout.setConstraints(this.topIcon, gridBagConstraints);
            this.topPanel.add(this.topIcon);
        }
        accessible = new JSeparator();
        accessible.setPreferredSize(new Dimension(510, 1));
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints((Component)((Object)accessible), gridBagConstraints);
        this.topPanel.add((Component)((Object)accessible));
        return this.topPanel;
    }

    private JPanel createCenterPanel(boolean bl, String string, String string2) {
        JComponent jComponent;
        int n;
        Object object;
        this.centerPanel = new JPanel();
        this.centerPanel.setLayout(new BoxLayout(this.centerPanel, 1));
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(24, 24, 12, 12));
        this.centerPanel.setAlignmentX(1.0f);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setAlignmentX(0.0f);
        JLabel jLabel = new JLabel(ResourceManager.getMessage("dialog.template.name"));
        Font font = jLabel.getFont().deriveFont(1);
        Font font2 = jLabel.getFont().deriveFont(0);
        jLabel.setFont(font);
        JLabel jLabel2 = new JLabel(ResourceManager.getMessage("dialog.template.publisher"));
        jLabel2.setFont(font);
        JLabel jLabel3 = new JLabel(ResourceManager.getMessage("dialog.template.from"));
        jLabel3.setFont(font);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel2.setAlignmentX(0.0f);
        this.nameInfo = new JLabel();
        this.publisherInfo = new JLabel();
        this.urlInfo = new JLabel();
        this.nameInfo.setFont(font2);
        this.publisherInfo.setFont(font2);
        this.urlInfo.setFont(font2);
        if (this.appTitle != null) {
            jPanel.add(jLabel);
            jPanel.add(Box.createVerticalStrut(12));
            jPanel2.add(this.nameInfo);
            jPanel2.add(Box.createVerticalStrut(12));
        }
        if (this.appPublisher != null) {
            jPanel.add(jLabel2);
            jPanel.add(Box.createVerticalStrut(12));
            jPanel2.add(this.publisherInfo);
            jPanel2.add(Box.createVerticalStrut(12));
        }
        if (this.appTitle != null && this.appURL != null) {
            jPanel.add(jLabel3);
            jPanel2.add(this.urlInfo);
        }
        this.setInfo(this.appTitle, this.appPublisher, this.appURL);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(3, 0, 0));
        jPanel3.add(jPanel);
        jPanel3.add(Box.createHorizontalStrut(12));
        jPanel3.add(jPanel2);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new FlowLayout(3, 0, 0));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        if (this.alwaysString != null) {
            object = "security.dialog.always";
            this.always = new JCheckBox(this.alwaysString);
            this.always.setMnemonic(ResourceManager.getVKCode((String)object + ".mnemonic"));
            this.always.setSelected(bl);
            this.always.setFont(font2);
            n = this.always.getBorder().getBorderInsets((Component)this.always).left;
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, n, 0, 0));
            jPanel4.add(this.always);
            jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.contentString != null) {
            if (this.contentLabel != null) {
                object = new JPanel(new BorderLayout());
                ((Container)object).add((Component)new JLabel(this.contentLabel), "West");
                jPanel5.add((Component)object, "North");
            }
            if (this.contentScroll) {
                n = this.largeScroll;
                object = this.largeScroll ? new JTextArea(this.contentString, 20, 80) : new JTextArea(this.contentString, 4, 40);
                ((JTextComponent)object).setEditable(false);
                jComponent = new JScrollPane((Component)object, 20, 30, n != 0){
                    final /* synthetic */ boolean val$limitWidth;
                    {
                        this.val$limitWidth = bl;
                        super(component, n, n2);
                    }

                    public Dimension getPreferredSize() {
                        Dimension dimension = super.getPreferredSize();
                        if (this.val$limitWidth) {
                            dimension.width = Math.min(dimension.width, 600);
                        }
                        return dimension;
                    }
                };
                jPanel5.add((Component)jComponent, "Center");
            } else {
                jPanel5.add((Component)new UITextArea(this.contentString), "Center");
            }
            jPanel5.setBorder(BorderFactory.createEmptyBorder(0, 0, 12, 0));
        }
        if (this.scrollList != null) {
            if (this.contentLabel != null) {
                object = new JPanel(new BorderLayout());
                ((Container)object).add((Component)new JLabel(this.contentLabel), "West");
                jPanel5.add((Component)object, "North");
            }
            if (this.contentScroll) {
                object = new JScrollPane(this.scrollList, 20, 30);
                jPanel5.add((Component)object, "Center");
            }
            if (this.showDetails) {
                object = new FancyButton("security.more.info.details", Color.blue);
                Font font3 = ResourceManager.getUIFont();
                int n2 = font3.getSize() - 1;
                if (n2 < this.minFontSize) {
                    n2 = this.minFontSize;
                }
                Font font4 = new Font(font3.getName(), font3.getStyle(), n2);
                ((JComponent)object).setFont(font4);
                ((Component)object).addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showCertificateDetails();
                        }
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
                JPanel jPanel6 = new JPanel();
                jPanel6.setBorder(BorderFactory.createEmptyBorder(12, 0, 12, 0));
                jPanel6.setLayout(new FlowLayout(4, 0, 0));
                jPanel6.add((Component)object);
                jPanel6.add(Box.createGlue());
                jPanel5.add((Component)jPanel6, "South");
            }
        }
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout(4, 0, 0));
        this.okBtn = new JButton(string == null ? "" : ResourceManager.getMessage(string));
        this.okBtn.addActionListener(this);
        this.okBtn.setActionCommand("OK");
        ((Container)object).add(this.okBtn);
        this.okBtn.setVisible(string != null);
        this.cancelBtn = new JButton(string2 == null ? "" : ResourceManager.getMessage(string2));
        this.cancelBtn.addActionListener(this);
        ((Container)object).add(Box.createHorizontalStrut(12));
        ((Container)object).add(this.cancelBtn);
        this.cancelBtn.setVisible(string2 != null);
        if (this.okBtn.isVisible()) {
            this.dialog.getRootPane().setDefaultButton(this.okBtn);
        } else if (this.cancelBtn.isVisible()) {
            this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
        }
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        if (this.includeAppInfo) {
            this.centerPanel.add(jPanel3);
            this.centerPanel.add(Box.createVerticalStrut(12));
        }
        if (this.alwaysString != null) {
            this.centerPanel.add(jPanel4);
        }
        if (this.contentString != null || this.scrollList != null) {
            this.centerPanel.add(jPanel5);
        }
        jComponent = new JPanel(new BorderLayout());
        jComponent.add((Component)object, "East");
        this.centerPanel.add(jComponent);
        if (Config.isJavaVersionAtLeast13()) {
            this.dialog.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "cancel");
            this.dialog.getRootPane().getActionMap().put("cancel", new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DialogTemplate.this.cancelAction();
                }
            });
        }
        return this.centerPanel;
    }

    private JPanel createBottomPanel(boolean bl) {
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        if (this.alertStrs != null || this.infoStrs != null) {
            JPanel jPanel;
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BorderLayout());
            int n = 12;
            jPanel2.setBorder(BorderFactory.createEmptyBorder(n, n, n, n));
            JSeparator jSeparator = new JSeparator();
            this.securityIcon = new JLabel();
            String string = "com/sun/deploy/resources/image/security_high.png";
            if (this.alertStrs == null || this.alertStrs.length == 0) {
                string = "com/sun/deploy/resources/image/security_low.png";
                if (this.always != null) {
                    this.always.setSelected(true);
                }
            } else {
                this.dialog.getRootPane().setDefaultButton(this.cancelBtn);
            }
            this.securityIcon.setIcon(new ImageIcon(ClassLoader.getSystemResource(string)));
            Font font = ResourceManager.getUIFont();
            int n2 = font.getSize() - 1;
            if (n2 < this.minFontSize) {
                n2 = this.minFontSize;
            }
            int n3 = 0;
            if (bl) {
                jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 1));
                jPanel.setBorder(BorderFactory.createEmptyBorder());
                FancyButton fancyButton = new FancyButton("dialog.template.more.info", Color.blue);
                Font font2 = new Font(font.getName(), font.getStyle(), n2);
                fancyButton.setFont(font2);
                fancyButton.addMouseListener(new MouseListener(){

                    public void mouseClicked(MouseEvent mouseEvent) {
                        if (mouseEvent.getComponent() instanceof FancyButton) {
                            DialogTemplate.this.showMoreInfo();
                        }
                    }

                    public void mousePressed(MouseEvent mouseEvent) {
                    }

                    public void mouseReleased(MouseEvent mouseEvent) {
                    }

                    public void mouseEntered(MouseEvent mouseEvent) {
                    }

                    public void mouseExited(MouseEvent mouseEvent) {
                    }
                });
                fancyButton.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        DialogTemplate.this.showMoreInfo();
                    }
                });
                jPanel.add(Box.createVerticalGlue());
                jPanel.add(fancyButton);
                jPanel.add(Box.createVerticalGlue());
                jPanel2.add((Component)jPanel, "East");
                n3 = fancyButton.getPreferredSize().width;
            }
            jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            int n4 = 20;
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, n4, 0, 0));
            int n5 = 510 - n * 2 - this.securityIcon.getPreferredSize().width - n4 - n3;
            UITextArea uITextArea = new UITextArea(n2, n5, false);
            if ((this.alertStrs == null || this.alertStrs.length == 0) && this.infoStrs != null && this.infoStrs.length != 0) {
                Font font3 = new JLabel().getFont().deriveFont(0);
                uITextArea.setFont(font3);
                uITextArea.setText(this.infoStrs[0] != null ? this.infoStrs[0] : " ");
                Dimension dimension = uITextArea.getPreferredSize();
                uITextArea.setSize(dimension.width, dimension.height);
            } else if (this.alertStrs != null && this.alertStrs.length != 0) {
                uITextArea.setText(this.alertStrs[0] != null ? this.alertStrs[0] : " ");
                Dimension dimension = uITextArea.getPreferredSize();
                uITextArea.setSize(dimension.width, dimension.height);
            }
            jPanel.add(uITextArea);
            jPanel.add(Box.createHorizontalStrut(6));
            jPanel2.add((Component)this.securityIcon, "West");
            jPanel2.add((Component)jPanel, "Center");
            this.bottomPanel.add((Component)jSeparator, "North");
            this.bottomPanel.add((Component)jPanel2, "Center");
        } else {
            this.bottomPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 2, 0));
        }
        return this.bottomPanel;
    }

    void showMoreInfo() {
        MoreInfoDialog moreInfoDialog = this.throwable == null && this.detailPanel == null ? new MoreInfoDialog(this.dialog, this.alertStrs, this.infoStrs, this.securityInfoCount, this.certs, this.start, this.end) : new MoreInfoDialog(this.dialog, this.detailPanel, this.throwable, this.certs);
        moreInfoDialog.setVisible(true);
    }

    void showCertificateDetails() {
        Certificate[] certificateArray = null;
        Iterator iterator = this.clientAuthCertsMap.values().iterator();
        for (int i = this.scrollList.getSelectedIndex(); i >= 0 && iterator.hasNext(); --i) {
            certificateArray = (X509Certificate[])iterator.next();
        }
        if (certificateArray != null) {
            new CertificateDialog(this.dialog, certificateArray, 0, certificateArray.length).DoModal();
        }
    }

    public void setVisible(boolean bl) {
        if (bl) {
            final DialogListener dialogListener = UIFactory.getDialogListener();
            final JDialog jDialog = this.dialog;
            final Frame frame = this.dummyFrame;
            Runnable runnable = new Runnable(){

                public void run() {
                    if (dialogListener != null) {
                        dialogListener.beforeShow();
                    }
                    jDialog.pack();
                    if (frame != null) {
                        frame.setVisible(true);
                    }
                    jDialog.setVisible(true);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                try {
                    SwingUtilities.invokeAndWait(runnable);
                }
                catch (Exception exception) {
                    Trace.ignored(exception);
                }
            }
        } else {
            this.dialog.setVisible(false);
            if (this.dummyFrame != null) {
                this.dummyFrame.setVisible(false);
            }
        }
    }

    public void setMasthead(String string, boolean bl) {
        if (this.masthead != null) {
            this.topText = string;
            this.masthead.setText(string);
            if (bl) {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(16, 12, 16, 6));
            } else {
                this.masthead.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 6));
            }
        }
    }

    public void setIcon(Image image) {
        this.topIcon.setIcon(new ImageIcon(image));
    }

    public static void resizeButtons(JButton[] jButtonArray) {
        int n;
        int n2 = jButtonArray.length;
        int n3 = 50;
        for (n = 0; n < n2; ++n) {
            if (jButtonArray[n].getPreferredSize().width <= n3) continue;
            n3 = jButtonArray[n].getPreferredSize().width;
        }
        for (n = 0; n < n2; ++n) {
            Dimension dimension = jButtonArray[n].getPreferredSize();
            dimension.width = n3;
            jButtonArray[n].setPreferredSize(dimension);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("OK")) {
            this.userAnswer = 0;
            if (this.always != null && this.always.isSelected()) {
                this.userAnswer = 2;
            }
            if (this.scrollList != null) {
                this.userAnswer = this.scrollList.getSelectedIndex();
            }
        } else {
            if (this.throwable != null || this.detailPanel != null) {
                this.showMoreInfo();
                return;
            }
            this.userAnswer = 1;
            if (this.scrollList != null) {
                this.userAnswer = -1;
            }
        }
        this.setVisible(false);
    }

    public void cancelAction() {
        this.userAnswer = 1;
        this.setVisible(false);
    }

    public int getUserAnswer() {
        return this.userAnswer;
    }

    void setUserAnswer(int n) {
        this.userAnswer = n;
    }

    void setMastheadBackground(Image image) {
        if (this.masthead != null) {
            this.masthead.setBackgroundImage(image);
        }
    }

    public void disposeDialog() {
        this.dialog.dispose();
    }

    public Component deriveParent(Component component, String string) {
        if (component == null && Config.getOSName().equals("Windows")) {
            this.dummyFrame = new Frame(string);
            this.dummyFrame.setLocation(-4096, -4096);
            return this.dummyFrame;
        }
        for (Component component2 = component; component2 != null; component2 = component2.getParent()) {
            if (!(component2 instanceof Dialog) && !(component2 instanceof Frame)) continue;
            return component2;
        }
        return null;
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void setInfo(String string, String string2, URL uRL) {
        if (this.nameInfo != null) {
            this.nameInfo.setText(string);
        }
        if (this.publisherInfo != null) {
            this.appPublisher = string2;
            this.publisherInfo.setText(string2);
        }
        if (this.urlInfo != null) {
            this.appURL = uRL;
            String string3 = " ";
            String string4 = "";
            if (uRL != null) {
                string3 = uRL.getProtocol() + "://" + uRL.getHost();
                int n = uRL.getPort();
                if (n != -1) {
                    string3 = string3 + ":" + Integer.toString(n);
                }
                string4 = uRL.toString();
            }
            this.urlInfo.setText(string3);
            this.urlInfo.setToolTipText(string4);
        }
    }

    void showOk(boolean bl) {
        JButton[] jButtonArray = new JButton[]{this.okBtn, this.cancelBtn};
        DialogTemplate.resizeButtons(jButtonArray);
        this.okBtn.setVisible(bl);
    }

    public void imageAvailable(URL uRL, String string, Image image, File file) {
        final int n = image.getWidth(null);
        final int n2 = image.getHeight(null);
        final Image image2 = image;
        final JLabel jLabel = this.topIcon;
        new Thread(new Runnable(){

            public void run() {
                Image image = image2;
                if (48 != n || 48 != n2) {
                    image = image2.getScaledInstance(48, 48, 1);
                }
                jLabel.setIcon(new ImageIcon(image));
            }
        }).start();
    }

    public void finalImageAvailable(URL uRL, String string, Image image, File file) {
        this.imageAvailable(uRL, string, image, file);
    }
}

