/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.services.Service;
import com.sun.deploy.services.ServiceManager;
import com.sun.deploy.util.DeploySysAction;
import com.sun.deploy.util.DeploySysRun;
import com.sun.deploy.util.DeployUIManager;
import com.sun.deploy.util.DialogFactory;
import com.sun.deploy.util.Trace;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Provider;
import java.security.Security;
import java.text.MessageFormat;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JPasswordField;
import javax.swing.LookAndFeel;

public class BrowserKeystore {
    private static final String _javaVersionProperty = System.getProperty("java.version");
    private static final boolean atLeast14 = !_javaVersionProperty.startsWith("1.2") && !_javaVersionProperty.startsWith("1.3");
    private static final boolean atLeast15 = atLeast14 && !_javaVersionProperty.startsWith("1.4");
    private static Object cryptoManager = null;
    private static boolean initializeJSS = false;

    public static void registerSecurityProviders() {
        if (atLeast15) {
            Provider provider;
            Class<?> clazz;
            Service service = ServiceManager.getService();
            if (service.isIExplorer()) {
                try {
                    clazz = Class.forName("com.sun.deploy.security.MSCryptoProvider", true, ClassLoader.getSystemClassLoader());
                    if (clazz != null) {
                        provider = (Provider)clazz.newInstance();
                        Security.insertProviderAt(provider, Security.getProviders().length + 1);
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            if (service.isNetscape()) {
                if (BrowserKeystore.isJSSCryptoConfigured()) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.config");
                    try {
                        clazz = Class.forName("com.sun.deploy.security.MozillaJSSProvider", true, ClassLoader.getSystemClassLoader());
                        if (clazz != null) {
                            provider = (Provider)clazz.newInstance();
                            Security.insertProviderAt(provider, Security.getProviders().length + 1);
                        }
                    }
                    catch (Throwable throwable) {
                        Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
                    }
                } else {
                    Trace.msgSecurityPrintln("browserkeystore.jss.notconfig");
                }
            }
        }
    }

    public static synchronized Object getJSSCryptoManager() {
        if (cryptoManager == null && !initializeJSS) {
            initializeJSS = true;
            String string = Config.getInstance().getMozillaUserProfileDirectory();
            Trace.msgSecurityPrintln("browserkeystore.mozilla.dir", new Object[]{string});
            if (string != null) {
                try {
                    Class<?> clazz = Class.forName("org.mozilla.jss.CryptoManager$InitializationValues", true, ClassLoader.getSystemClassLoader());
                    Constructor<?> constructor = clazz.getConstructor(String.class);
                    Object obj = constructor.newInstance(string);
                    Field field = clazz.getField("installJSSProvider");
                    field.setBoolean(obj, false);
                    Class<?> clazz2 = Class.forName("org.mozilla.jss.CryptoManager", true, ClassLoader.getSystemClassLoader());
                    Method method = clazz2.getMethod("initialize", clazz);
                    Object object = method.invoke(null, obj);
                    Method method2 = clazz2.getMethod("getInstance", null);
                    Object object2 = method2.invoke(null, (Object[])null);
                    Class<?> clazz3 = Class.forName("org.mozilla.jss.util.PasswordCallback", true, ClassLoader.getSystemClassLoader());
                    Method method3 = clazz2.getMethod("setPasswordCallback", clazz3);
                    JSSPasswordCallbackInvocationHandler jSSPasswordCallbackInvocationHandler = new JSSPasswordCallbackInvocationHandler();
                    Class<?> clazz4 = Proxy.getProxyClass(ClassLoader.getSystemClassLoader(), clazz3);
                    Object obj2 = clazz4.getConstructor(InvocationHandler.class).newInstance(jSSPasswordCallbackInvocationHandler);
                    method3.invoke(object2, obj2);
                    cryptoManager = object2;
                    Trace.msgSecurityPrintln("browserkeystore.jss.yes");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Trace.msgSecurityPrintln("browserkeystore.jss.no");
                    return null;
                }
            }
        }
        return cryptoManager;
    }

    public static boolean isJSSCryptoConfigured() {
        return BrowserKeystore.getJSSCryptoManager() != null;
    }

    private static class JSSPasswordCallbackInvocationHandler
    implements InvocationHandler {
        private HashMap passwordAttempts = new HashMap();

        private JSSPasswordCallbackInvocationHandler() {
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            Object object2;
            if (objectArray != null && objectArray[0] != null) {
                object2 = objectArray[0];
                Class<?> clazz = object2.getClass();
                Method method2 = clazz.getMethod("getName", null);
                String string = (String)method2.invoke(object2, (Object[])null);
                String string2 = method.getName();
                Integer n = (Integer)this.passwordAttempts.get(string);
                if (n == null || n < 2) {
                    if (n == null) {
                        this.passwordAttempts.put(string, new Integer(1));
                    } else {
                        this.passwordAttempts.put(string, new Integer(n + 1));
                    }
                    char[] cArray = this.getPasswordDialog(string);
                    Class<?> clazz2 = Class.forName("org.mozilla.jss.util.Password", true, ClassLoader.getSystemClassLoader());
                    Class[] classArray = new Class[]{char[].class};
                    Constructor<?> constructor = clazz2.getConstructor(classArray);
                    if (cArray != null) {
                        Object[] objectArray2 = new Object[]{cArray};
                        return constructor.newInstance(objectArray2);
                    }
                }
            }
            object2 = Class.forName("org.mozilla.jss.util.PasswordCallback$GiveUpException", true, ClassLoader.getSystemClassLoader());
            throw (Throwable)((Class)object2).newInstance();
        }

        private char[] getPasswordDialog(final String string) {
            try {
                char[] cArray = (char[])DeploySysRun.execute(new DeploySysAction(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Object execute() throws Exception {
                        LookAndFeel lookAndFeel = null;
                        try {
                            lookAndFeel = DeployUIManager.setLookAndFeel();
                            char[] cArray = JSSPasswordCallbackInvocationHandler.this.getPasswordDialogImp(string);
                            return cArray;
                        }
                        finally {
                            DeployUIManager.restoreLookAndFeel(lookAndFeel);
                        }
                    }
                });
                return cArray;
            }
            catch (Exception exception) {
                Trace.ignoredException(exception);
                return null;
            }
        }

        private char[] getPasswordDialogImp(String string) {
            MessageFormat messageFormat = new MessageFormat(ResourceManager.getMessage("browserkeystore.password.dialog.text"));
            Object[] objectArray = new Object[]{string};
            String string2 = messageFormat.format(objectArray);
            JPasswordField jPasswordField = new JPasswordField();
            Object[] objectArray2 = new Object[]{string2.toString(), jPasswordField};
            JButton jButton = new JButton(ResourceManager.getMessage("browserkeystore.password.dialog.buttonOK"));
            JButton jButton2 = new JButton(ResourceManager.getMessage("browserkeystore.password.dialog.buttonCancel"));
            jButton.setMnemonic(ResourceManager.getAcceleratorKey("browserkeystore.password.dialog.buttonOK"));
            jButton2.setMnemonic(ResourceManager.getAcceleratorKey("browserkeystore.password.dialog.buttonCancel"));
            String string3 = ResourceManager.getMessage("browserkeystore.password.dialog.caption");
            Object[] objectArray3 = new Object[]{jButton, jButton2};
            int n = DialogFactory.showOptionDialog(3, (Object)objectArray2, string3, objectArray3, objectArray3[0]);
            char[] cArray = jPasswordField.getPassword();
            if (n == 0) {
                return cArray;
            }
            return null;
        }
    }
}

