/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.HostAddress;
import com.ibm.security.krb5.internal.ccache.b;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Vector;

public class HostAddresses
implements Cloneable {
    public HostAddress[] addresses;
    private static String[] z;

    public HostAddresses(HostAddress[] hostAddressArray) {
        this.addresses = hostAddressArray;
    }

    public HostAddresses() throws UnknownHostException {
        this.addresses = new HostAddress[1];
        this.addresses[0] = new HostAddress();
    }

    private HostAddresses(int n2) {
    }

    public HostAddresses(PrincipalName principalName) throws UnknownHostException, KrbException {
        String[] stringArray = principalName.getNameStrings();
        if (principalName.getNameType() != 3 || stringArray.length < 2) {
            throw new KrbException(z[5], null);
        }
        String string = stringArray[1];
        InetAddress[] inetAddressArray = InetAddress.getAllByName(string);
        HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
        }
        this.addresses = hostAddressArray;
    }

    public Object clone() {
        HostAddresses hostAddresses = new HostAddresses(0);
        if (this.addresses != null) {
            hostAddresses.addresses = new HostAddress[this.addresses.length];
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                hostAddresses.addresses[i2] = (HostAddress)this.addresses[i2].clone();
            }
        }
        return hostAddresses;
    }

    public boolean inList(HostAddress hostAddress) {
        if (this.addresses != null) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (!this.addresses[i2].equals(hostAddress)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean equals(HostAddresses hostAddresses) {
        if (this.addresses == null && hostAddresses.addresses != null || this.addresses != null && hostAddresses.addresses == null) {
            return false;
        }
        if (this.addresses != null && hostAddresses.addresses != null) {
            if (this.addresses.length != hostAddresses.addresses.length) {
                return false;
            }
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                if (this.addresses[i2].equals(hostAddresses.addresses[i2])) continue;
                return false;
            }
        }
        return true;
    }

    public HostAddresses(DerValue derValue) throws Asn1Exception, IOException {
        Vector<HostAddress> vector = new Vector<HostAddress>();
        DerValue derValue2 = null;
        while (derValue.getData().available() > 0) {
            derValue2 = derValue.getData().getDerValue();
            vector.addElement(new HostAddress(derValue2));
        }
        if (vector.size() > 0) {
            this.addresses = new HostAddress[vector.size()];
            vector.copyInto(this.addresses);
        }
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        if (this.addresses != null && this.addresses.length > 0) {
            for (int i2 = 0; i2 < this.addresses.length; ++i2) {
                derOutputStream.write(this.addresses[i2].asn1Encode());
            }
        }
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public static HostAddresses parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new HostAddresses(derValue2);
    }

    public void writeAddrs(b b2) throws IOException {
        b2.a(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            b2.b(this.addresses[i2].addrType);
            b2.a(this.addresses[i2].address.length);
            b2.write(this.addresses[i2].address, 0, this.addresses[i2].address.length);
        }
    }

    public InetAddress[] getInetAddresses() {
        if (this.addresses == null || this.addresses.length == 0) {
            return null;
        }
        ArrayList<InetAddress> arrayList = new ArrayList<InetAddress>(this.addresses.length);
        for (int i2 = 0; i2 < this.addresses.length; ++i2) {
            try {
                if (this.addresses[i2].addrType != 2 && this.addresses[i2].addrType != 23) continue;
                arrayList.add(this.addresses[i2].getInetAddress());
                continue;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        InetAddress[] inetAddressArray = new InetAddress[arrayList.size()];
        return arrayList.toArray(inetAddressArray);
    }

    public static HostAddresses getLocalAddresses() throws IOException {
        Object object;
        String string = null;
        InetAddress[] inetAddressArray = null;
        HostAddresses hostAddresses = null;
        try {
            object = InetAddress.getLocalHost();
            string = ((InetAddress)object).getHostName();
            inetAddressArray = InetAddress.getAllByName(string);
            HostAddress[] hostAddressArray = new HostAddress[inetAddressArray.length];
            for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
                hostAddressArray[i2] = new HostAddress(inetAddressArray[i2]);
            }
            hostAddresses = new HostAddresses(hostAddressArray);
        }
        catch (Exception exception) {
            throw new IOException(exception.toString());
        }
        if (Krb5Debug.on(9)) {
            object = new Krb5Debug(z[0] + Thread.currentThread().getName() + z[3]);
            ((Krb5Debug)object).out(9, z[1] + string + z[4]);
            for (int i3 = 0; i3 < inetAddressArray.length; ++i3) {
                ((Krb5Debug)object).out(9, z[2] + inetAddressArray[i3]);
            }
        }
        return hostAddresses;
    }

    public HostAddresses(InetAddress[] inetAddressArray) {
        if (inetAddressArray == null) {
            this.addresses = null;
            return;
        }
        this.addresses = new HostAddress[inetAddressArray.length];
        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
            this.addresses[i2] = new HostAddress(inetAddressArray[i2]);
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block65: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block64: {
                char[] cArray3;
                Object var0;
                block63: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block62: {
                        char[] cArray5;
                        block61: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block60: {
                                char[] cArray7;
                                block59: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block58: {
                                        char[] cArray9;
                                        block57: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block56: {
                                                char[] cArray11;
                                                block55: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block54: {
                                                        stringArray = new String[6];
                                                        var0 = null;
                                                        char[] cArray13 = "\u0001\u001e!%T-\u0015 4f:\u0014!k".toCharArray();
                                                        n4 = 0;
                                                        int n15 = cArray13.length;
                                                        cArray12 = cArray13;
                                                        n14 = n15;
                                                        if (n15 <= 1) break block54;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block55;
                                                    }
                                                    do {
                                                        char[] cArray14 = cArray12;
                                                        char[] cArray15 = cArray12;
                                                        int n16 = n4;
                                                        while (true) {
                                                            int n17;
                                                            char c2 = cArray14[n16];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n17 = 73;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n17 = 113;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n17 = 82;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n17 = 81;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n17 = 21;
                                                                }
                                                            }
                                                            cArray14[n16] = (char)(c2 ^ n17);
                                                            ++n4;
                                                            cArray12 = cArray15;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray15 = cArray12;
                                                            n13 = n14;
                                                            n16 = n14;
                                                            cArray14 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[0] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray16 = "wOlq^;\u0013\u00195v\u001b\u0014#qy&\u00123=5(\u00156#p:\u00027\"5/\u001e q".toCharArray();
                                                n4 = 0;
                                                int n18 = cArray16.length;
                                                cArray10 = cArray16;
                                                n12 = n18;
                                                if (n18 <= 1) break block56;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block57;
                                            }
                                            do {
                                                char[] cArray17 = cArray10;
                                                char[] cArray18 = cArray10;
                                                int n19 = n4;
                                                while (true) {
                                                    int n20;
                                                    char c3 = cArray17[n19];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n20 = 73;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n20 = 113;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n20 = 82;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n20 = 81;
                                                            break;
                                                        }
                                                        default: {
                                                            n20 = 21;
                                                        }
                                                    }
                                                    cArray17[n19] = (char)(c3 ^ n20);
                                                    ++n4;
                                                    cArray10 = cArray18;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray18 = cArray10;
                                                    n11 = n12;
                                                    n19 = n12;
                                                    cArray17 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[1] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray19 = "Cx".toCharArray();
                                        n4 = 0;
                                        int n21 = cArray19.length;
                                        cArray8 = cArray19;
                                        n10 = n21;
                                        if (n21 <= 1) break block58;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block59;
                                    }
                                    do {
                                        char[] cArray20 = cArray8;
                                        char[] cArray21 = cArray8;
                                        int n22 = n4;
                                        while (true) {
                                            int n23;
                                            char c4 = cArray20[n22];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n23 = 73;
                                                    break;
                                                }
                                                case 1: {
                                                    n23 = 113;
                                                    break;
                                                }
                                                case 2: {
                                                    n23 = 82;
                                                    break;
                                                }
                                                case 3: {
                                                    n23 = 81;
                                                    break;
                                                }
                                                default: {
                                                    n23 = 21;
                                                }
                                            }
                                            cArray20[n22] = (char)(c4 ^ n23);
                                            ++n4;
                                            cArray8 = cArray21;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray21 = cArray8;
                                            n9 = n10;
                                            n22 = n10;
                                            cArray20 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[2] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray22 = "sQ".toCharArray();
                                n4 = 0;
                                int n24 = cArray22.length;
                                cArray6 = cArray22;
                                n8 = n24;
                                if (n24 <= 1) break block60;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block61;
                            }
                            do {
                                char[] cArray23 = cArray6;
                                char[] cArray24 = cArray6;
                                int n25 = n4;
                                while (true) {
                                    int n26;
                                    char c5 = cArray23[n25];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n26 = 73;
                                            break;
                                        }
                                        case 1: {
                                            n26 = 113;
                                            break;
                                        }
                                        case 2: {
                                            n26 = 82;
                                            break;
                                        }
                                        case 3: {
                                            n26 = 81;
                                            break;
                                        }
                                        default: {
                                            n26 = 21;
                                        }
                                    }
                                    cArray23[n25] = (char)(c5 ^ n26);
                                    ++n4;
                                    cArray6 = cArray24;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray24 = cArray6;
                                    n7 = n8;
                                    n25 = n8;
                                    cArray23 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[3] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray25 = "i\u0010 4/i".toCharArray();
                        n4 = 0;
                        int n27 = cArray25.length;
                        cArray4 = cArray25;
                        n6 = n27;
                        if (n27 <= 1) break block62;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block63;
                    }
                    do {
                        char[] cArray26 = cArray4;
                        char[] cArray27 = cArray4;
                        int n28 = n4;
                        while (true) {
                            int n29;
                            char c6 = cArray26[n28];
                            switch (n4 % 5) {
                                case 0: {
                                    n29 = 73;
                                    break;
                                }
                                case 1: {
                                    n29 = 113;
                                    break;
                                }
                                case 2: {
                                    n29 = 82;
                                    break;
                                }
                                case 3: {
                                    n29 = 81;
                                    break;
                                }
                                default: {
                                    n29 = 21;
                                }
                            }
                            cArray26[n28] = (char)(c6 ^ n29);
                            ++n4;
                            cArray4 = cArray27;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray27 = cArray4;
                            n5 = n6;
                            n28 = n6;
                            cArray26 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[4] = new String(cArray3).intern();
                var0 = null;
                char[] cArray28 = "\u0007\u001e&\u0002p;\u0007;2p\u0007\u0010?4".toCharArray();
                n4 = 0;
                int n30 = cArray28.length;
                cArray2 = cArray28;
                n3 = n30;
                if (n30 <= 1) break block64;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block65;
            }
            do {
                char[] cArray29 = cArray2;
                char[] cArray30 = cArray2;
                int n31 = n4;
                while (true) {
                    int n32;
                    char c7 = cArray29[n31];
                    switch (n4 % 5) {
                        case 0: {
                            n32 = 73;
                            break;
                        }
                        case 1: {
                            n32 = 113;
                            break;
                        }
                        case 2: {
                            n32 = 82;
                            break;
                        }
                        case 3: {
                            n32 = 81;
                            break;
                        }
                        default: {
                            n32 = 21;
                        }
                    }
                    cArray29[n31] = (char)(c7 ^ n32);
                    ++n4;
                    cArray2 = cArray30;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray30 = cArray2;
                    n2 = n3;
                    n31 = n3;
                    cArray29 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[5] = new String(cArray).intern();
        z = stringArray;
    }
}

