/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.krb5;

import com.ibm.security.jgss.i18n.I18NException;
import com.ibm.security.krb5.Asn1Exception;
import com.ibm.security.krb5.EncryptedData;
import com.ibm.security.krb5.Krb5Debug;
import com.ibm.security.krb5.KrbException;
import com.ibm.security.krb5.PrincipalName;
import com.ibm.security.krb5.internal.Config;
import com.ibm.security.krb5.internal.ccache.b;
import com.ibm.security.krb5.internal.crypto.Des3EType;
import com.ibm.security.krb5.internal.crypto.KrbCryptoException;
import com.ibm.security.krb5.internal.crypto.n;
import com.ibm.security.krb5.internal.crypto.q;
import com.ibm.security.krb5.internal.crypto.r;
import com.ibm.security.krb5.internal.crypto.x;
import com.ibm.security.krb5.internal.ktab.KeyTab;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import java.io.IOException;

public class EncryptionKey
implements Cloneable {
    public static EncryptionKey NULL_KEY;
    private int a;
    private byte[] b;
    private Integer c;
    public static final int KEYTYPE_DEFAULT;
    private static String[] z;

    private static int a() {
        int n2 = 16;
        try {
            int[] nArray = Config.getInstance().defaultEtype(z[6]);
            if (nArray != null && nArray.length > 0) {
                if (EncryptedData.isSupportedEncType(nArray[0])) {
                    n2 = nArray[0];
                    if (Krb5Debug.on(9)) {
                        Krb5Debug krb5Debug = new Krb5Debug(z[4] + Thread.currentThread().getName() + z[2]);
                        krb5Debug.out(9, z[5] + EncryptedData.encTypeToString(n2));
                    }
                } else if (Krb5Debug.on(9)) {
                    Krb5Debug krb5Debug = new Krb5Debug(z[4] + Thread.currentThread().getName() + z[2]);
                    krb5Debug.out(9, z[3] + nArray[0]);
                }
            }
        }
        catch (Exception exception) {
            n2 = 16;
        }
        return n2;
    }

    public synchronized int getEType() {
        return this.a;
    }

    public final Integer getKeyVersionNumber() {
        return this.c;
    }

    public final byte[] getBytes() {
        byte[] byArray = null;
        if (this.b != null) {
            byArray = new byte[this.b.length];
            System.arraycopy(this.b, 0, byArray, 0, this.b.length);
        }
        return byArray;
    }

    public int getKeyType() {
        return this.a;
    }

    public synchronized Object clone() {
        return new EncryptionKey(this.b, this.a, this.c);
    }

    public static EncryptionKey acquireSecretKey(PrincipalName principalName, String string) throws KrbException, IOException {
        KeyTab keyTab;
        if (principalName == null) {
            I18NException.throwIllegalArgumentException(z[1]);
        }
        if ((keyTab = KeyTab.getInstance(string)) == null) {
            return null;
        }
        return keyTab.readServiceKey(principalName);
    }

    public EncryptionKey(byte[] byArray, int n2, Integer n3) {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(z[0], new Integer[]{new Integer(n2)});
        }
        this.a = n2;
        this.c = n3;
        if (byArray != null) {
            this.b = new byte[byArray.length];
            System.arraycopy(byArray, 0, this.b, 0, this.b.length);
        }
    }

    public EncryptionKey(int n2, byte[] byArray) {
        this(byArray, n2, null);
    }

    public EncryptionKey(byte[] byArray) {
        this(byArray, KEYTYPE_DEFAULT, null);
    }

    public EncryptionKey(String string) throws KrbCryptoException {
        this.a = KEYTYPE_DEFAULT;
        this.b = this.a(string, this.a);
    }

    public EncryptionKey(String string, String string2) throws KrbCryptoException {
        this.a = KEYTYPE_DEFAULT;
        this.b = this.a(string, string2, this.a);
    }

    public EncryptionKey(String string, String string2, int n2) throws KrbCryptoException {
        this.a = n2;
        this.b = this.a(string, string2, this.a);
    }

    public EncryptionKey(String string, int n2, Integer n3) throws KrbCryptoException {
        this.b = this.a(string, n2);
        this.a = n2;
        this.c = n3;
    }

    public EncryptionKey(String string, int n2, String string2, Integer n3) throws KrbCryptoException {
        this.b = this.a(string, string2, n2);
        this.a = n2;
        this.c = n3;
    }

    public EncryptionKey(EncryptionKey encryptionKey) throws KrbCryptoException {
        this.b = (byte[])encryptionKey.b.clone();
        this.a = encryptionKey.a;
    }

    public EncryptionKey(DerValue derValue) throws Asn1Exception, IOException {
        if (derValue.getTag() != 48) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 0) {
            throw new Asn1Exception(906);
        }
        this.a = derValue2.getData().getBigInteger().intValue();
        derValue2 = derValue.getData().getDerValue();
        if ((derValue2.getTag() & 0x1F) != 1) {
            throw new Asn1Exception(906);
        }
        this.b = derValue2.getData().getOctetString();
        if (derValue2.getData().available() > 0) {
            throw new Asn1Exception(906);
        }
    }

    public synchronized byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream2.putInteger(this.a);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.putOctetString(this.b);
        derOutputStream.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), derOutputStream2);
        derOutputStream2 = new DerOutputStream();
        derOutputStream2.write((byte)48, derOutputStream);
        return derOutputStream2.toByteArray();
    }

    public synchronized void destroy() {
        if (this.b != null) {
            for (int i2 = 0; i2 < this.b.length; ++i2) {
                this.b[i2] = 0;
            }
        }
    }

    public static EncryptionKey parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new EncryptionKey(derValue2);
    }

    public void writeKey(b b2) throws IOException {
        b2.b(this.a);
        b2.b(this.a);
        b2.a(this.b.length);
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            b2.c(this.b[i2]);
        }
    }

    private byte[] a(String string, int n2) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(z[0], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (n2 == 16) {
                return Des3EType.stringToKey(string);
            }
            return n.c(string);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return x.a(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            return q.a(string);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            return r.a(string);
        }
        return new byte[0];
    }

    private byte[] a(String string, String string2, int n2) throws KrbCryptoException {
        if (!EncryptedData.isSupportedEncType(n2)) {
            I18NException.throwIllegalArgumentException(z[0], new Integer[]{new Integer(n2)});
        }
        if (EncryptedData.isDesEncType(n2)) {
            if (string2 == null) {
                I18NException.throwIllegalArgumentException(z[7]);
            }
            if (n2 == 16) {
                return Des3EType.stringToKey(string, string2);
            }
            return n.c(string + string2);
        }
        if (EncryptedData.isRc4HMacEncType(n2)) {
            return x.a(string);
        }
        if (EncryptedData.isAES128EncType(n2)) {
            return q.a(string, string2);
        }
        if (EncryptedData.isAES256EncType(n2)) {
            return r.a(string, string2);
        }
        return new byte[0];
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block87: {
            int n2;
            int n3;
            char[] cArray2;
            int n4;
            block86: {
                char[] cArray3;
                Object var0;
                block85: {
                    int n5;
                    int n6;
                    char[] cArray4;
                    block84: {
                        char[] cArray5;
                        block83: {
                            int n7;
                            int n8;
                            char[] cArray6;
                            block82: {
                                char[] cArray7;
                                block81: {
                                    int n9;
                                    int n10;
                                    char[] cArray8;
                                    block80: {
                                        char[] cArray9;
                                        block79: {
                                            int n11;
                                            int n12;
                                            char[] cArray10;
                                            block78: {
                                                char[] cArray11;
                                                block77: {
                                                    int n13;
                                                    int n14;
                                                    char[] cArray12;
                                                    block76: {
                                                        char[] cArray13;
                                                        block75: {
                                                            int n15;
                                                            int n16;
                                                            char[] cArray14;
                                                            block74: {
                                                                char[] cArray15;
                                                                block73: {
                                                                    int n17;
                                                                    int n18;
                                                                    char[] cArray16;
                                                                    block72: {
                                                                        stringArray = new String[8];
                                                                        var0 = null;
                                                                        char[] cArray17 = "=\u00166yI\u0006#+BI".toCharArray();
                                                                        n4 = 0;
                                                                        int n19 = cArray17.length;
                                                                        cArray16 = cArray17;
                                                                        n18 = n19;
                                                                        if (n19 <= 1) break block72;
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                        if (n18 <= n4) break block73;
                                                                    }
                                                                    do {
                                                                        char[] cArray18 = cArray16;
                                                                        char[] cArray19 = cArray16;
                                                                        int n20 = n4;
                                                                        while (true) {
                                                                            int n21;
                                                                            char c2 = cArray18[n20];
                                                                            switch (n4 % 5) {
                                                                                case 0: {
                                                                                    n21 = 127;
                                                                                    break;
                                                                                }
                                                                                case 1: {
                                                                                    n21 = 119;
                                                                                    break;
                                                                                }
                                                                                case 2: {
                                                                                    n21 = 82;
                                                                                    break;
                                                                                }
                                                                                case 3: {
                                                                                    n21 = 50;
                                                                                    break;
                                                                                }
                                                                                default: {
                                                                                    n21 = 44;
                                                                                }
                                                                            }
                                                                            cArray18[n20] = (char)(c2 ^ n21);
                                                                            ++n4;
                                                                            cArray16 = cArray19;
                                                                            n18 = n18;
                                                                            if (n18 != 0) break;
                                                                            cArray19 = cArray16;
                                                                            n17 = n18;
                                                                            n20 = n18;
                                                                            cArray18 = cArray16;
                                                                        }
                                                                        cArray15 = cArray16;
                                                                        n17 = n18;
                                                                    } while (n18 > n4);
                                                                }
                                                                stringArray[0] = new String(cArray15).intern();
                                                                var0 = null;
                                                                char[] cArray20 = "1\u0002>^g\u001a\u000e".toCharArray();
                                                                n4 = 0;
                                                                int n22 = cArray20.length;
                                                                cArray14 = cArray20;
                                                                n16 = n22;
                                                                if (n22 <= 1) break block74;
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                                if (n16 <= n4) break block75;
                                                            }
                                                            do {
                                                                char[] cArray21 = cArray14;
                                                                char[] cArray22 = cArray14;
                                                                int n23 = n4;
                                                                while (true) {
                                                                    int n24;
                                                                    char c3 = cArray21[n23];
                                                                    switch (n4 % 5) {
                                                                        case 0: {
                                                                            n24 = 127;
                                                                            break;
                                                                        }
                                                                        case 1: {
                                                                            n24 = 119;
                                                                            break;
                                                                        }
                                                                        case 2: {
                                                                            n24 = 82;
                                                                            break;
                                                                        }
                                                                        case 3: {
                                                                            n24 = 50;
                                                                            break;
                                                                        }
                                                                        default: {
                                                                            n24 = 44;
                                                                        }
                                                                    }
                                                                    cArray21[n23] = (char)(c3 ^ n24);
                                                                    ++n4;
                                                                    cArray14 = cArray22;
                                                                    n16 = n16;
                                                                    if (n16 != 0) break;
                                                                    cArray22 = cArray14;
                                                                    n15 = n16;
                                                                    n23 = n16;
                                                                    cArray21 = cArray14;
                                                                }
                                                                cArray13 = cArray14;
                                                                n15 = n16;
                                                            } while (n16 > n4);
                                                        }
                                                        stringArray[1] = new String(cArray13).intern();
                                                        var0 = null;
                                                        char[] cArray23 = "EW".toCharArray();
                                                        n4 = 0;
                                                        int n25 = cArray23.length;
                                                        cArray12 = cArray23;
                                                        n14 = n25;
                                                        if (n25 <= 1) break block76;
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                        if (n14 <= n4) break block77;
                                                    }
                                                    do {
                                                        char[] cArray24 = cArray12;
                                                        char[] cArray25 = cArray12;
                                                        int n26 = n4;
                                                        while (true) {
                                                            int n27;
                                                            char c4 = cArray24[n26];
                                                            switch (n4 % 5) {
                                                                case 0: {
                                                                    n27 = 127;
                                                                    break;
                                                                }
                                                                case 1: {
                                                                    n27 = 119;
                                                                    break;
                                                                }
                                                                case 2: {
                                                                    n27 = 82;
                                                                    break;
                                                                }
                                                                case 3: {
                                                                    n27 = 50;
                                                                    break;
                                                                }
                                                                default: {
                                                                    n27 = 44;
                                                                }
                                                            }
                                                            cArray24[n26] = (char)(c4 ^ n27);
                                                            ++n4;
                                                            cArray12 = cArray25;
                                                            n14 = n14;
                                                            if (n14 != 0) break;
                                                            cArray25 = cArray12;
                                                            n13 = n14;
                                                            n26 = n14;
                                                            cArray24 = cArray12;
                                                        }
                                                        cArray11 = cArray12;
                                                        n13 = n14;
                                                    } while (n14 > n4);
                                                }
                                                stringArray[2] = new String(cArray11).intern();
                                                var0 = null;
                                                char[] cArray26 = "AIl\u0012i\u0011\u0014 K\\\u000b\u001e=\\g\u001a\u000e~\u0012{>%\u001c{b8W\u007f\u0012Y\u0011\u0004'B\\\u0010\u0005&WH_\u0012<Q\f\u000b\u000e\"W\f\u0016\u0019rQC\u0011\u0011;U\u0016_".toCharArray();
                                                n4 = 0;
                                                int n28 = cArray26.length;
                                                cArray10 = cArray26;
                                                n12 = n28;
                                                if (n28 <= 1) break block78;
                                                cArray9 = cArray10;
                                                n11 = n12;
                                                if (n12 <= n4) break block79;
                                            }
                                            do {
                                                char[] cArray27 = cArray10;
                                                char[] cArray28 = cArray10;
                                                int n29 = n4;
                                                while (true) {
                                                    int n30;
                                                    char c5 = cArray27[n29];
                                                    switch (n4 % 5) {
                                                        case 0: {
                                                            n30 = 127;
                                                            break;
                                                        }
                                                        case 1: {
                                                            n30 = 119;
                                                            break;
                                                        }
                                                        case 2: {
                                                            n30 = 82;
                                                            break;
                                                        }
                                                        case 3: {
                                                            n30 = 50;
                                                            break;
                                                        }
                                                        default: {
                                                            n30 = 44;
                                                        }
                                                    }
                                                    cArray27[n29] = (char)(c5 ^ n30);
                                                    ++n4;
                                                    cArray10 = cArray28;
                                                    n12 = n12;
                                                    if (n12 != 0) break;
                                                    cArray28 = cArray10;
                                                    n11 = n12;
                                                    n29 = n12;
                                                    cArray27 = cArray10;
                                                }
                                                cArray9 = cArray10;
                                                n11 = n12;
                                            } while (n12 > n4);
                                        }
                                        stringArray[3] = new String(cArray9).intern();
                                        var0 = null;
                                        char[] cArray29 = ":\u00191@U\u000f\u0003;]B4\u0012+\b".toCharArray();
                                        n4 = 0;
                                        int n31 = cArray29.length;
                                        cArray8 = cArray29;
                                        n10 = n31;
                                        if (n31 <= 1) break block80;
                                        cArray7 = cArray8;
                                        n9 = n10;
                                        if (n10 <= n4) break block81;
                                    }
                                    do {
                                        char[] cArray30 = cArray8;
                                        char[] cArray31 = cArray8;
                                        int n32 = n4;
                                        while (true) {
                                            int n33;
                                            char c6 = cArray30[n32];
                                            switch (n4 % 5) {
                                                case 0: {
                                                    n33 = 127;
                                                    break;
                                                }
                                                case 1: {
                                                    n33 = 119;
                                                    break;
                                                }
                                                case 2: {
                                                    n33 = 82;
                                                    break;
                                                }
                                                case 3: {
                                                    n33 = 50;
                                                    break;
                                                }
                                                default: {
                                                    n33 = 44;
                                                }
                                            }
                                            cArray30[n32] = (char)(c6 ^ n33);
                                            ++n4;
                                            cArray8 = cArray31;
                                            n10 = n10;
                                            if (n10 != 0) break;
                                            cArray31 = cArray8;
                                            n9 = n10;
                                            n32 = n10;
                                            cArray30 = cArray8;
                                        }
                                        cArray7 = cArray8;
                                        n9 = n10;
                                    } while (n10 > n4);
                                }
                                stringArray[4] = new String(cArray7).intern();
                                var0 = null;
                                char[] cArray32 = "AIl\u0012i\u0011\u0014 K\\\u000b\u001e=\\g\u001a\u000eh\u0012O\u0010\u00194[K_\u00137TM\n\u001b&\u0012G\u001a\u000erFU\u000f\u0012r[__".toCharArray();
                                n4 = 0;
                                int n34 = cArray32.length;
                                cArray6 = cArray32;
                                n8 = n34;
                                if (n34 <= 1) break block82;
                                cArray5 = cArray6;
                                n7 = n8;
                                if (n8 <= n4) break block83;
                            }
                            do {
                                char[] cArray33 = cArray6;
                                char[] cArray34 = cArray6;
                                int n35 = n4;
                                while (true) {
                                    int n36;
                                    char c7 = cArray33[n35];
                                    switch (n4 % 5) {
                                        case 0: {
                                            n36 = 127;
                                            break;
                                        }
                                        case 1: {
                                            n36 = 119;
                                            break;
                                        }
                                        case 2: {
                                            n36 = 82;
                                            break;
                                        }
                                        case 3: {
                                            n36 = 50;
                                            break;
                                        }
                                        default: {
                                            n36 = 44;
                                        }
                                    }
                                    cArray33[n35] = (char)(c7 ^ n36);
                                    ++n4;
                                    cArray6 = cArray34;
                                    n8 = n8;
                                    if (n8 != 0) break;
                                    cArray34 = cArray6;
                                    n7 = n8;
                                    n35 = n8;
                                    cArray33 = cArray6;
                                }
                                cArray5 = cArray6;
                                n7 = n8;
                            } while (n8 > n4);
                        }
                        stringArray[5] = new String(cArray5).intern();
                        var0 = null;
                        char[] cArray35 = "\u001b\u00124SY\u0013\u0003\rFG\u000b(7\\O\u000b\u000e\"W_".toCharArray();
                        n4 = 0;
                        int n37 = cArray35.length;
                        cArray4 = cArray35;
                        n6 = n37;
                        if (n37 <= 1) break block84;
                        cArray3 = cArray4;
                        n5 = n6;
                        if (n6 <= n4) break block85;
                    }
                    do {
                        char[] cArray36 = cArray4;
                        char[] cArray37 = cArray4;
                        int n38 = n4;
                        while (true) {
                            int n39;
                            char c8 = cArray36[n38];
                            switch (n4 % 5) {
                                case 0: {
                                    n39 = 127;
                                    break;
                                }
                                case 1: {
                                    n39 = 119;
                                    break;
                                }
                                case 2: {
                                    n39 = 82;
                                    break;
                                }
                                case 3: {
                                    n39 = 50;
                                    break;
                                }
                                default: {
                                    n39 = 44;
                                }
                            }
                            cArray36[n38] = (char)(c8 ^ n39);
                            ++n4;
                            cArray4 = cArray37;
                            n6 = n6;
                            if (n6 != 0) break;
                            cArray37 = cArray4;
                            n5 = n6;
                            n38 = n6;
                            cArray36 = cArray4;
                        }
                        cArray3 = cArray4;
                        n5 = n6;
                    } while (n6 > n4);
                }
                stringArray[6] = new String(cArray3).intern();
                var0 = null;
                char[] cArray38 = "1\u0002>^\u007f\u001e\u001b&".toCharArray();
                n4 = 0;
                int n40 = cArray38.length;
                cArray2 = cArray38;
                n3 = n40;
                if (n40 <= 1) break block86;
                cArray = cArray2;
                n2 = n3;
                if (n3 <= n4) break block87;
            }
            do {
                char[] cArray39 = cArray2;
                char[] cArray40 = cArray2;
                int n41 = n4;
                while (true) {
                    int n42;
                    char c9 = cArray39[n41];
                    switch (n4 % 5) {
                        case 0: {
                            n42 = 127;
                            break;
                        }
                        case 1: {
                            n42 = 119;
                            break;
                        }
                        case 2: {
                            n42 = 82;
                            break;
                        }
                        case 3: {
                            n42 = 50;
                            break;
                        }
                        default: {
                            n42 = 44;
                        }
                    }
                    cArray39[n41] = (char)(c9 ^ n42);
                    ++n4;
                    cArray2 = cArray40;
                    n3 = n3;
                    if (n3 != 0) break;
                    cArray40 = cArray2;
                    n2 = n3;
                    n41 = n3;
                    cArray39 = cArray2;
                }
                cArray = cArray2;
                n2 = n3;
            } while (n3 > n4);
        }
        stringArray[7] = new String(cArray).intern();
        z = stringArray;
        NULL_KEY = new EncryptionKey(new byte[0], 0, new Integer(0));
        KEYTYPE_DEFAULT = EncryptionKey.a();
    }
}

