/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cache;

import com.sun.deploy.config.Config;
import com.sun.deploy.si.DeploySIListener;
import com.sun.deploy.si.SingleInstanceImpl;
import com.sun.deploy.si.SingleInstanceManager;
import com.sun.deploy.util.AboutDialog;
import com.sun.deploy.util.DeployUIManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import sun.plugin.cache.JarCacheTable;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.util.UserProfile;

public class JarCacheViewer
extends JFrame
implements DeploySIListener {
    private JarCacheTable viewerTable;
    private static String cacheLocation;
    private ActionListener closeViewer;
    private ActionListener refreshViewer;
    private ActionListener removeEntry;
    private JCheckBox disableCache;
    private SingleInstanceImpl _sil = new SingleInstanceImpl();
    private AbstractAction close_key;
    JMenu file_menu;
    JMenu options_menu;
    JMenu help_menu;
    JMenuItem exit_mi;
    JMenuItem refresh_mi;
    JMenuItem about_mi;
    JCheckBoxMenuItem disable_mi;
    private static final String VIEWER_ID;

    public JarCacheViewer(String string) {
        this._sil.addSingleInstanceListener((DeploySIListener)this, VIEWER_ID);
        cacheLocation = string != null ? string : JarCacheViewer.getPluginCacheLocation();
        Container container = this.getContentPane();
        this.setTitle(ResourceHandler.getMessage("cache_viewer.caption"));
        this.viewerTable = new JarCacheTable();
        this.viewerTable.getAccessibleContext().setAccessibleName(ResourceHandler.getMessage("cache_viewer.viewertable"));
        JScrollPane jScrollPane = new JScrollPane(this.viewerTable);
        container.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        this.disableCache = new JCheckBox(ResourceHandler.getMessage("cache_viewer.disable"));
        this.disableCache.setSelected(Config.getBooleanProperty((String)"deployment.javapi.cache.enabled"));
        this.disableCache.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.disable"));
        this.disableCache.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                Config.setBooleanProperty((String)"deployment.javapi.cache.enabled", (boolean)JarCacheViewer.this.disableCache.isSelected());
                JarCacheViewer.this.disable_mi.setSelected(JarCacheViewer.this.disableCache.isSelected());
            }
        });
        jPanel2.add((Component)this.disableCache, "Center");
        jPanel.add((Component)jPanel2, "Center");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(1));
        final JButton jButton = new JButton(ResourceHandler.getMessage("cache_viewer.refresh"));
        JButton jButton2 = new JButton(ResourceHandler.getMessage("cache_viewer.remove"));
        JButton jButton3 = new JButton(ResourceHandler.getMessage("cache_viewer.OK"));
        this.close_key = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.setVisible(false);
                JarCacheViewer.this.dispose();
            }
        };
        this.getRootPane().registerKeyboardAction(this.close_key, KeyStroke.getKeyStroke(27, 0), 2);
        jButton.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.refresh"));
        jButton2.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.remove"));
        jButton3.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.OK"));
        jPanel3.setLayout(new FlowLayout(2));
        jPanel3.add(jButton);
        jPanel3.add(jButton2);
        jPanel3.add(jButton3);
        jPanel.add((Component)jPanel3, "South");
        container.add((Component)jPanel, "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                JarCacheViewer.this.exitForm();
            }

            public void windowOpened(WindowEvent windowEvent) {
                jButton.requestFocus();
            }
        });
        this.refreshViewer = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.viewerTable.refresh();
            }
        };
        this.removeEntry = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.viewerTable.removeRows();
            }
        };
        this.closeViewer = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Config.store();
                JarCacheViewer.this.exitForm();
            }
        };
        jButton.addActionListener(this.refreshViewer);
        jButton2.addActionListener(this.removeEntry);
        jButton3.addActionListener(this.closeViewer);
        this.getRootPane().addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                JarCacheViewer.this.viewerTable.adjustColumnSize((Container)componentEvent.getComponent());
            }
        });
        this.createMenuBar();
        this.getRootPane().setDefaultButton(jButton3);
        this.setSize(800, 400);
        this.setVisible(true);
    }

    private void exitForm() {
        this._sil.removeSingleInstanceListener((DeploySIListener)this);
        this.dispose();
        System.exit(0);
    }

    private void createMenuBar() {
        this.file_menu = new JMenu(ResourceHandler.getMessage("cache_viewer.menu.file"));
        this.file_menu.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.menu.file"));
        this.options_menu = new JMenu(ResourceHandler.getMessage("cache_viewer.menu.options"));
        this.options_menu.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.menu.options"));
        this.help_menu = new JMenu(ResourceHandler.getMessage("cache_viewer.menu.help"));
        this.help_menu.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.menu.help"));
        this.exit_mi = new JMenuItem(ResourceHandler.getMessage("cache_viewer.menu.item.exit"));
        this.exit_mi.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.menu.item.exit"));
        this.exit_mi.addActionListener(this.closeViewer);
        this.disable_mi = new JCheckBoxMenuItem(ResourceHandler.getMessage("cache_viewer.disable"));
        this.disable_mi.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.disable"));
        this.disable_mi.setSelected(this.disableCache.isSelected());
        this.disable_mi.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    JarCacheViewer.this.disableCache.setSelected(true);
                } else {
                    JarCacheViewer.this.disableCache.setSelected(false);
                }
            }
        });
        this.refresh_mi = new JMenuItem(ResourceHandler.getMessage("cache_viewer.refresh"));
        this.refresh_mi.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.refresh"));
        this.refresh_mi.addActionListener(this.refreshViewer);
        this.about_mi = new JMenuItem(ResourceHandler.getMessage("cache_viewer.menu.item.about"));
        this.about_mi.setMnemonic(ResourceHandler.getAcceleratorKey("cache_viewer.menu.item.about"));
        this.about_mi.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JarCacheViewer.this.aboutActionPerformed(actionEvent);
            }
        });
        this.file_menu.add(this.exit_mi);
        this.options_menu.add(this.disable_mi);
        this.options_menu.add(this.refresh_mi);
        this.help_menu.add(this.about_mi);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.add(this.file_menu);
        jMenuBar.add(this.options_menu);
        jMenuBar.add(Box.createHorizontalGlue());
        jMenuBar.add(this.help_menu);
        this.setJMenuBar(jMenuBar);
    }

    private void aboutActionPerformed(ActionEvent actionEvent) {
        AboutDialog aboutDialog = new AboutDialog((JFrame)this, true);
        aboutDialog.setVisible(true);
    }

    public static String getPluginCacheLocation() {
        if (cacheLocation != null) {
            return cacheLocation;
        }
        return UserProfile.getPluginCacheDirectory();
    }

    public static void main(String[] stringArray) {
        String string = null;
        if (stringArray.length != 0) {
            string = stringArray[0];
        }
        if (SingleInstanceManager.isServerRunning((String)VIEWER_ID) && SingleInstanceManager.connectToServer((String)"")) {
            System.exit(0);
        }
        JarCacheViewer jarCacheViewer = new JarCacheViewer(string);
    }

    public void newActivation(String[] stringArray) {
        this.setExtendedState(this.getExtendedState() & 0xFFFFFFFE);
        this.toFront();
    }

    public Object getSingleInstanceListener() {
        return this;
    }

    static {
        DeployUIManager.setLookAndFeel();
        VIEWER_ID = "JarCacheViewer" + Config.getInstance().getSessionSpecificString();
    }
}

