/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.AlgorithmStatus;
import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.RSAPrivateCrtKey;
import com.ibm.crypto.fips.provider.RSAPublicKey;
import com.ibm.crypto.fips.provider.SHA1withRSA;
import com.ibm.crypto.fips.provider.SelfTest;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;

public final class RSAKeyPairGenerator
extends KeyPairGeneratorSpi
implements AlgorithmStatus {
    private int a = 1024;
    SecureRandom b = null;

    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException(RSAKeyPairGenerator.a("(*m\u001c)\u001d?z\u000f7X%p\td\u000b>o\r+\n?z\u0019"));
    }

    public void initialize(int n2, SecureRandom secureRandom) {
        if (n2 < 512) {
            throw new InvalidParameterException(RSAKeyPairGenerator.a("5${\b(\r8?\u000e-\u0002.?\u00101\u000b??\u001f!X*k](\u001d*l\tdMz-"));
        }
        if (n2 > 2048) {
            throw new InvalidParameterException(RSAKeyPairGenerator.a("5${\b(\r8?\u000e-\u0002.?\u00101\u000b??\u001f!X*k])\u00178k]vH\u007f'"));
        }
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(RSAKeyPairGenerator.a("5${\b(\r8?\u000e-\u0002.?\u00101\u000b??\u001f!X&j\u00110\u0011;s\u0018d\u0017-?E"));
        }
        this.a = n2;
        this.b = secureRandom;
    }

    public void initialize(int n2) {
        if (n2 < 512) {
            throw new InvalidParameterException(RSAKeyPairGenerator.a("5${\b(\r8?\u000e-\u0002.?\u00101\u000b??\u001f!X*k](\u001d*l\tdMz-"));
        }
        if (n2 > 2048) {
            throw new InvalidParameterException(RSAKeyPairGenerator.a("5${\b(\r8?\u000e-\u0002.?\u00101\u000b??\u001f!X*k])\u00178k]vH\u007f'"));
        }
        if (n2 % 8 != 0) {
            throw new InvalidParameterException(RSAKeyPairGenerator.a("5${\b(\r8?\u000e-\u0002.?\u00101\u000b??\u001f!X&j\u00110\u0011;s\u0018d\u0017-?E"));
        }
        this.a = n2;
        try {
            this.b = SecureRandom.getInstance(RSAKeyPairGenerator.a("1\tR.!\u001b>m\u0018\u0016\u0019%{\u0012)"), RSAKeyPairGenerator.a("1\tR7\u0007=\rV-\u0017"));
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new FIPSRuntimeException(RSAKeyPairGenerator.a(">\u0002O.d9;o\u000f+\u000e.{]\u00166\f?3+\fk^\u000b%\u0011'~\u001f(\u001d"));
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new FIPSRuntimeException(RSAKeyPairGenerator.a(">\u0002O.d9;o\u000f+\u000e.{]\u00166\f?3+\fk^\u000b%\u0011'~\u001f(\u001d"));
        }
    }

    public boolean isFipsApproved() {
        return true;
    }

    public KeyPair generateKeyPair() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        KeyPair keyPair = this.a();
        if (!this.a(keyPair)) {
            SelfTest.failure = new FIPSRuntimeException(RSAKeyPairGenerator.a("*\u0018^]\u0017\u0011,q]bX\u001dz\u000f-\u001e2?)!\u000b??;%\u0011'z\u0019"));
            throw new FIPSRuntimeException(RSAKeyPairGenerator.a("*\u0018^]\u0017\u0011,q]bX\u001dz\u000f-\u001e2?)!\u000b??;%\u0011'z\u0019"));
        }
        return keyPair;
    }

    protected KeyPair a() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        if (this.b == null) {
            this.b = null;
            try {
                this.b = SecureRandom.getInstance(RSAKeyPairGenerator.a("1\tR.!\u001b>m\u0018\u0016\u0019%{\u0012)"), RSAKeyPairGenerator.a("1\tR7\u0007=\rV-\u0017"));
            }
            catch (NoSuchProviderException noSuchProviderException) {
                throw new FIPSRuntimeException(RSAKeyPairGenerator.a(">\u0002O.d9;o\u000f+\u000e.{]\u00166\f?3+\fk^\u000b%\u0011'~\u001f(\u001d"));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new FIPSRuntimeException(RSAKeyPairGenerator.a(">\u0002O.d9;o\u000f+\u000e.{]\u00166\f?3+\fk^\u000b%\u0011'~\u001f(\u001d"));
            }
        }
        BigInteger bigInteger = new BigInteger(this.a / 2, 10, this.b);
        BigInteger bigInteger2 = new BigInteger(this.a / 2, 10, this.b);
        BigInteger bigInteger3 = bigInteger.multiply(bigInteger2);
        BigInteger bigInteger4 = new BigInteger(RSAKeyPairGenerator.a("N~*Ns"));
        BigInteger bigInteger5 = bigInteger.subtract(BigInteger.ONE).multiply(bigInteger2.subtract(BigInteger.ONE));
        BigInteger bigInteger6 = bigInteger4.modInverse(bigInteger5);
        try {
            RSAPublicKey rSAPublicKey = new RSAPublicKey(bigInteger3, bigInteger4);
            RSAPrivateCrtKey rSAPrivateCrtKey = new RSAPrivateCrtKey(bigInteger3, bigInteger6, bigInteger4, bigInteger, bigInteger2, BigInteger.valueOf(0L), BigInteger.valueOf(0L), BigInteger.valueOf(0L));
            return new KeyPair(rSAPublicKey, rSAPrivateCrtKey);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new ProviderException(invalidKeyException.getMessage());
        }
    }

    private boolean a(KeyPair keyPair) {
        PrivateKey privateKey;
        PublicKey publicKey;
        byte[] byArray = RSAKeyPairGenerator.a("9\t\\9\u0001>\fW4\u000e3\u0007R3\u000b(\u001aM.\u0010-\u001dH%\u0013\"").getBytes();
        try {
            publicKey = keyPair.getPublic();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            privateKey = keyPair.getPrivate();
        }
        catch (Exception exception) {
            return false;
        }
        try {
            SHA1withRSA sHA1withRSA = new SHA1withRSA();
            sHA1withRSA.a(privateKey);
            sHA1withRSA.a(byArray, 0, byArray.length);
            byte[] byArray2 = sHA1withRSA.a();
            sHA1withRSA.a(publicKey);
            sHA1withRSA.a(byArray, 0, byArray.length);
            if (!sHA1withRSA.a(byArray2)) {
                ((RSAPublicKey)publicKey).zeroize();
                ((RSAPrivateCrtKey)privateKey).zeroize();
                return false;
            }
        }
        catch (Exception exception) {
            ((RSAPublicKey)publicKey).zeroize();
            ((RSAPrivateCrtKey)privateKey).zeroize();
            return false;
        }
        return true;
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String a(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 120;
                        break;
                    }
                    case 1: {
                        n5 = 75;
                        break;
                    }
                    case 2: {
                        n5 = 31;
                        break;
                    }
                    case 3: {
                        n5 = 125;
                        break;
                    }
                    default: {
                        n5 = 68;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

