/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.fips.provider;

import com.ibm.crypto.fips.provider.FIPSRuntimeException;
import com.ibm.crypto.fips.provider.SelfTest;
import com.ibm.crypto.fips.provider.j;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this(IdentityDatabase.d("kKK-\u001fkGV>^7\u0000"));
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String string) throws InvalidParameterException {
        super(string);
    }

    public static IdentityDatabase fromStream(InputStream inputStream) throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        IdentityDatabase identityDatabase = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            if (object instanceof IdentityDatabase) {
                identityDatabase = (IdentityDatabase)object;
            } else {
                Enumeration enumeration = ((sun.security.provider.IdentityDatabase)object).identities();
                identityDatabase = new IdentityDatabase();
                while (enumeration.hasMoreElements()) {
                    try {
                        identityDatabase.addIdentity((Identity)enumeration.nextElement());
                    }
                    catch (KeyManagementException keyManagementException) {
                        throw new IOException(keyManagementException.getMessage());
                    }
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            IdentityDatabase.a(IdentityDatabase.d("MFQ*PjFW,\u001c}\u000eV6\u00049L]y\u0018x^H<\u001ep@_w"), classNotFoundException);
            IdentityDatabase.b(IdentityDatabase.d("MF]y\u0006|\\K0\u001fw\u000eW?PmF]y\u0014xZY;\u0011jK\u00180\u00039AZ*\u001fuKL<^9mY7\u001evZ\u00180\u001epZQ8\u001cpT]w"));
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("MFQ*PjFW,\u001c}\u000eV6\u00049L]y\u0018x^H<\u001ep@_w"), invalidClassException);
            IdentityDatabase.b(IdentityDatabase.d("L@Y;\u001c|\u000eL6Pp@Q-\u0019xBQ#\u00159]A*\u0004|C\u00180\u0014|@L0\u0004`\u000eK:\u001fiK\u0002yPP@N8\u001cpJ{5\u0011j]}!\u0013|^L0\u001fw\u0000\u0018S$qGKy\u0019j\u000eU6\u0003m\u000eT0\u001b|BAy\u0014lK\u0018-\u001f9O\u0018*\u0015kGY5\u0019cOL0\u001fw\u000eN<\u0002jGW7\u0019wI\u0018)\u0002vLT<\u001d#\u000eYy\u0013uOK*Pl]]=Pp@\u00182\u0015`\u000eU8\u001exI]4\u0015wZ\u0018.\u0011j\u000eW;\u0003vB]-\u0015}"));
        }
        catch (StreamCorruptedException streamCorruptedException) {
            IdentityDatabase.a(IdentityDatabase.d("MF]y\u0003|\\Q8\u001cpTY-\u0019v@\u0018*\u0004kKY4Pp]\u0018:\u001fk\\M)\u0004|J\u0016y%wOZ5\u00159ZWy\u001cvO\\w"), streamCorruptedException);
            IdentityDatabase.b(IdentityDatabase.d("L@Y;\u001c|\u000eL6Pp@Q-\u0019xBQ#\u00159]A*\u0004|C\u00180\u0014|@L0\u0004`\u000eK:\u001fiK\u0016y#m\\]8\u001dZAJ+\u0000lZ]=5aM])\u0004pAVw"));
        }
        if (identityDatabase == null) {
            identityDatabase = new IdentityDatabase(IdentityDatabase.d("l@Q7\u0019mGY5\u0019cK\\"));
        }
        return identityDatabase;
    }

    public static IdentityDatabase fromFile(File file) throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        IdentityDatabase identityDatabase = IdentityDatabase.fromStream(fileInputStream);
        identityDatabase.sourceFile = file;
        return identityDatabase;
    }

    public int size() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        return this.identities.size();
    }

    public Identity getIdentity(String string) {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        Identity identity = (Identity)this.identities.get(string);
        if (identity instanceof Signer) {
            this.c(IdentityDatabase.d("~KLw\u0003pIV<\u0002"));
        }
        return identity;
    }

    public Identity getIdentity(PublicKey publicKey) {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        if (publicKey == null) {
            return null;
        }
        Enumeration enumeration = this.identities();
        while (enumeration.hasMoreElements()) {
            Identity identity = (Identity)enumeration.nextElement();
            PublicKey publicKey2 = identity.getPublicKey();
            if (publicKey2 == null || !this.a(publicKey2, publicKey)) continue;
            if (identity instanceof Signer) {
                this.c(IdentityDatabase.d("~KLw\u0003pIV<\u0002"));
            }
            return identity;
        }
        return null;
    }

    private boolean a(Key key, Key key2) {
        if (key == key2) {
            return true;
        }
        return MessageDigest.isEqual(key.getEncoded(), key2.getEncoded());
    }

    public void addIdentity(Identity identity) throws KeyManagementException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.c(IdentityDatabase.d("xJ\\w\u0019}KV-\u0019mW"));
        Identity identity2 = this.getIdentity(identity.getName());
        Identity identity3 = this.getIdentity(identity.getPublicKey());
        String string = null;
        if (identity2 != null) {
            string = IdentityDatabase.d("wOU<PzAV?\u001cpML");
        }
        if (identity3 != null) {
            string = IdentityDatabase.d("rKAy\u0013v@^5\u0019zZ");
        }
        if (string != null) {
            throw new KeyManagementException(string);
        }
        this.identities.put(identity.getName(), identity);
    }

    public void removeIdentity(Identity identity) throws KeyManagementException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        this.c(IdentityDatabase.d("kKU6\u0006|\u0000Q=\u0015wZQ-\t"));
        String string = identity.getName();
        if (this.identities.get(string) == null) {
            throw new KeyManagementException(IdentityDatabase.d("mF]+\u00159GKy\u001ev\u000eQ=\u0015wZQ-\t9@Y4\u0015}\u000e") + string + IdentityDatabase.d("9GVy") + this);
        }
        this.identities.remove(string);
    }

    public Enumeration identities() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        return this.identities.elements();
    }

    void a(File file) {
        this.sourceFile = file;
    }

    File a() {
        return this.sourceFile;
    }

    public void save(OutputStream outputStream) throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
            objectOutputStream.writeObject(this);
            objectOutputStream.flush();
        }
        catch (InvalidClassException invalidClassException) {
            IdentityDatabase.a(IdentityDatabase.d("MFQ*PjFW,\u001c}\u000eV6\u00049L]y\u0018x^H<\u001ep@_w"), invalidClassException);
            return;
        }
    }

    void b(File file) throws IOException {
        this.a(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        this.save(fileOutputStream);
    }

    public void save() throws IOException {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        if (this.sourceFile == null) {
            throw new IOException(IdentityDatabase.d("mFQ*P}OL8\u0012x]]y\u0018x]\u00187\u001f9]W,\u0002zK\u0018?\u0019uK"));
        }
        this.b(this.sourceFile);
    }

    private static File b() {
        String string = Security.getProperty(IdentityDatabase.d("pJ]7\u0004pZAw\u0014xZY;\u0011jK"));
        if (string == null) {
            string = System.getProperty(IdentityDatabase.d("l]]+^qAU<")) + File.separatorChar + IdentityDatabase.d("pJ]7\u0004pZA=\u00127AZ3");
        }
        return new File(string);
    }

    private static void c() {
        File file = IdentityDatabase.b();
        try {
            IdentityDatabase identityDatabase;
            if (file.exists()) {
                IdentityDatabase.a(IdentityDatabase.d("uAY=\u0019wI\u0018*\tjZ]4P}OL8\u0012x]]y\u0016kAUy\u0016pB]cP") + file);
                identityDatabase = IdentityDatabase.fromFile(file);
            } else {
                identityDatabase = new IdentityDatabase(file);
            }
            IdentityScope.setSystemScope(identityDatabase);
            IdentityDatabase.a(IdentityDatabase.d("JWK-\u0015t\u000e\\8\u0004xLY*\u00159GV0\u0004pOT0\n|J\u0002y") + identityDatabase);
        }
        catch (IOException iOException) {
            IdentityDatabase.a(IdentityDatabase.d("\\\\J6\u00029GV0\u0004pOT0\np@_y\u0019}KV-\u0019mW\u0018=\u0011mOZ8\u0003|\u0014\u0018") + file, iOException);
            return;
        }
        catch (InvalidParameterException invalidParameterException) {
            IdentityDatabase.a(IdentityDatabase.d("\\\\J6\u00029ZJ \u0019wI\u0018-\u001f9GV*\u0004x@L0\u0011mK\u00188PjWK-\u0015t\u000eQ=\u0015wZQ-\u0019|]\u0018=\u00129GVy") + file, invalidParameterException);
            return;
        }
    }

    public String toString() {
        if (!SelfTest.isFipsRunnable()) {
            throw new FIPSRuntimeException();
        }
        return IdentityDatabase.d("zAUw\u0019{C\u0016:\u0002`^L6^\u007fGH*^i\\W/\u0019}KJw9}KV-\u0019mW|8\u0004xLY*\u00155\u000eK6\u0005kM]y\u0016pB]cP") + this.sourceFile;
    }

    private static void a(String string) {
    }

    private static void a(String string, Throwable throwable) {
    }

    private static void b(String string) {
        System.err.println(string);
    }

    void c(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            string = this.getClass().getName() + "." + string + "." + this.d();
            securityManager.checkSecurityAccess(string);
        }
    }

    String d() {
        String string = this.getName();
        if (this.getScope() != null) {
            string = string + "." + this.getScope().getName();
        }
        return string;
    }

    private synchronized void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        this.c(IdentityDatabase.d("jKJ0\u0011uGB<^pJ]7\u0004pZAw\u0014xZY;\u0011jK"));
        objectOutputStream.writeObject(this.identities);
        objectOutputStream.writeObject(this.sourceFile);
    }

    static void e() {
        IdentityDatabase.c();
    }

    static {
        AccessController.doPrivileged(new j());
    }

    /*
     * Handled impossible loop by adding 'first' condition
     * Enabled aggressive block sorting
     */
    private static String d(String string) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        int n3 = 0;
        boolean bl = true;
        block6: do {
            if (bl && !(bl = false) && n2 > 1) continue;
            char[] cArray2 = cArray;
            int n4 = n3;
            while (true) {
                int n5;
                char c2 = cArray2[n4];
                switch (n3 % 5) {
                    case 0: {
                        n5 = 25;
                        break;
                    }
                    case 1: {
                        n5 = 46;
                        break;
                    }
                    case 2: {
                        n5 = 56;
                        break;
                    }
                    case 3: {
                        n5 = 89;
                        break;
                    }
                    default: {
                        n5 = 112;
                    }
                }
                cArray2[n4] = (char)(c2 ^ n5);
                ++n3;
                if (n2 != 0) continue block6;
                cArray2 = cArray;
                n4 = n2;
            }
        } while (n3 < n2);
        return new String(cArray);
    }
}

