/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.bidiTools.bdlayout.BidiConvert;
import com.ibm.nio.cs.IBMCharsetDecoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CoderResult;
import java.security.AccessController;
import sun.misc.VM;
import sun.nio.cs.Surrogate;
import sun.security.action.GetPropertyAction;

class UTF8_Decoder
extends IBMCharsetDecoder {
    private final int flags;
    private String bidiParms;
    private boolean bidiEnabled = false;
    private static String bidiInit;
    private final Surrogate.Generator sgg = new Surrogate.Generator();

    private boolean validSecond(int n, int n2, int n3) {
        if (n3 < 128 || n3 > 191) {
            return false;
        }
        if ((this.flags & 2) != 0) {
            return true;
        }
        switch (n) {
            case 2: {
                if (n2 >= 194 && n2 <= 223) break;
                return false;
            }
            case 3: {
                if (n2 != 224 || n3 >= 160) break;
                return false;
            }
            case 4: {
                if (n2 > 244) {
                    return true;
                }
                if ((this.flags & 4) != 0) {
                    return false;
                }
                if (n2 == 240 && n3 < 144) {
                    return false;
                }
                if (n2 != 244 || n3 <= 143) break;
                return false;
            }
        }
        return true;
    }

    protected UTF8_Decoder(Charset charset, int n) {
        super(charset, 1.0f, 1.0f);
        this.flags = n;
        this.bidiParms = bidiInit;
        if (null == this.bidiParms) {
            if (VM.isBooted()) {
                this.bidiParms = System.getSecurityManager() == null ? (String)new GetPropertyAction("JAVABIDI").run() : AccessController.doPrivileged(new GetPropertyAction("JAVABIDI"));
                if (null == this.bidiParms) {
                    this.bidiParms = "NO";
                }
                bidiInit = this.bidiParms;
            } else {
                this.bidiParms = "NO";
            }
        }
        this.bidiEnabled = !"NO".equals(this.bidiParms);
    }

    private boolean isContinuation(int n) {
        return (n & 0xC0) == 128;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeArrayLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        byte[] byArray = byteBuffer.array();
        int n = byteBuffer.arrayOffset() + byteBuffer.position();
        int n2 = byteBuffer.arrayOffset() + byteBuffer.limit();
        assert (n <= n2);
        n = n <= n2 ? n : n2;
        char[] cArray = charBuffer.array();
        int n3 = charBuffer.arrayOffset() + charBuffer.position();
        int n4 = charBuffer.arrayOffset() + charBuffer.limit();
        assert (n3 <= n4);
        n3 = n3 <= n4 ? n3 : n4;
        try {
            block43: while (n < n2) {
                byte by = byArray[n];
                switch (by >> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        cArray[n3++] = (char)(by & 0x7F);
                        ++n;
                        continue block43;
                    }
                    case 12: 
                    case 13: {
                        if (n2 - n < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byte by2 = byArray[n + 1];
                        if (!this.isContinuation(by2)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (!this.validSecond(2, by & 0xFF, by2 & 0xFF)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        cArray[n3++] = (char)((by & 0x1F) << 6 | (by2 & 0x3F) << 0);
                        n += 2;
                        continue block43;
                    }
                    case 14: {
                        if (n2 - n < 3) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        if (n4 - n3 < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byte by2 = byArray[n + 1];
                        if (!this.isContinuation(by2)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (!this.validSecond(3, by & 0xFF, by2 & 0xFF)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        byte by3 = byArray[n + 2];
                        if (!this.isContinuation(by3)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        cArray[n3++] = (char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0);
                        n += 3;
                        continue block43;
                    }
                    case 15: {
                        int n5;
                        int n6;
                        byte by3;
                        byte by2;
                        switch (by & 0xF) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                if (n2 - n < 4) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                by2 = byArray[n + 1];
                                if (!this.isContinuation(by2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                if (!this.validSecond(4, by & 0xFF, by2 & 0xFF)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                by3 = byArray[n + 2];
                                if (!this.isContinuation(by3)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                byte by4 = byArray[n + 3];
                                if (!this.isContinuation(by4)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(3);
                                    return coderResult;
                                }
                                n6 = (by & 7) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | (by4 & 0x3F) << 0;
                                n5 = 4;
                                break;
                            }
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                if (n2 - n < 5) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                by2 = byArray[n + 1];
                                if (!this.isContinuation(by2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                by3 = byArray[n + 2];
                                if (!this.isContinuation(by3)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                byte by4 = byArray[n + 3];
                                if (!this.isContinuation(by4)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(3);
                                    return coderResult;
                                }
                                byte by5 = byArray[n + 4];
                                if (!this.isContinuation(by5)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(4);
                                    return coderResult;
                                }
                                n6 = (by & 3) << 24 | (by2 & 0x3F) << 18 | (by3 & 0x3F) << 12 | (by4 & 0x3F) << 6 | (by5 & 0x3F) << 0;
                                n5 = 5;
                                break;
                            }
                            case 12: 
                            case 13: {
                                if (n2 - n < 6) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                by2 = byArray[n + 1];
                                if (!this.isContinuation(by2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                by3 = byArray[n + 2];
                                if (!this.isContinuation(by3)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                byte by4 = byArray[n + 3];
                                if (!this.isContinuation(by4)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(3);
                                    return coderResult;
                                }
                                byte by5 = byArray[n + 4];
                                if (!this.isContinuation(by5)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(4);
                                    return coderResult;
                                }
                                byte by6 = byArray[n + 5];
                                if (!this.isContinuation(by6)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(5);
                                    return coderResult;
                                }
                                n6 = (by & 1) << 30 | (by2 & 0x3F) << 24 | (by3 & 0x3F) << 18 | (by4 & 0x3F) << 12 | (by5 & 0x3F) << 6 | by6 & 0x3F;
                                n5 = 6;
                                break;
                            }
                            default: {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                        }
                        int n7 = this.sgg.generate(n6, n5, cArray, n3, n4);
                        if (n7 < 0) {
                            CoderResult coderResult = this.sgg.error();
                            return coderResult;
                        }
                        n3 += n7;
                        n += n5;
                        continue block43;
                    }
                }
                CoderResult coderResult = CoderResult.malformedForLength(1);
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n - byteBuffer.arrayOffset());
            charBuffer.position(n3 - charBuffer.arrayOffset());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoderResult decodeBufferLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        int n = byteBuffer.position();
        try {
            block43: while (byteBuffer.hasRemaining()) {
                byte by = byteBuffer.get();
                switch (by >> 4 & 0xF) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (charBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put((char)by);
                        ++n;
                        continue block43;
                    }
                    case 12: 
                    case 13: {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        if (charBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byte by2 = byteBuffer.get();
                        if (!this.isContinuation(by2)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (!this.validSecond(2, by & 0xFF, by2 & 0xFF)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        charBuffer.put((char)((by & 0x1F) << 6 | (by2 & 0x3F) << 0));
                        n += 2;
                        continue block43;
                    }
                    case 14: {
                        if (byteBuffer.remaining() < 2) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        if (charBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byte by2 = byteBuffer.get();
                        if (!this.isContinuation(by2)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        if (!this.validSecond(3, by & 0xFF, by2 & 0xFF)) {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        byte by3 = byteBuffer.get();
                        if (!this.isContinuation(by3)) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        charBuffer.put((char)((by & 0xF) << 12 | (by2 & 0x3F) << 6 | (by3 & 0x3F) << 0));
                        n += 3;
                        continue block43;
                    }
                    case 15: {
                        int n2;
                        int n3;
                        byte by3;
                        byte by2;
                        switch (by & 0xF) {
                            case 0: 
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: 
                            case 5: 
                            case 6: 
                            case 7: {
                                if (byteBuffer.remaining() < 3) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                by2 = byteBuffer.get();
                                if (!this.isContinuation(by2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                if (!this.validSecond(4, by & 0xFF, by2 & 0xFF)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                by3 = byteBuffer.get();
                                if (!this.isContinuation(by3)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                byte by4 = byteBuffer.get();
                                if (!this.isContinuation(by4)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(3);
                                    return coderResult;
                                }
                                n3 = (by & 7) << 18 | (by2 & 0x3F) << 12 | (by3 & 0x3F) << 6 | (by4 & 0x3F) << 0;
                                n2 = 4;
                                break;
                            }
                            case 8: 
                            case 9: 
                            case 10: 
                            case 11: {
                                if (byteBuffer.remaining() < 4) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                by2 = byteBuffer.get();
                                if (!this.isContinuation(by2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                by3 = byteBuffer.get();
                                if (!this.isContinuation(by3)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                byte by4 = byteBuffer.get();
                                if (!this.isContinuation(by4)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(3);
                                    return coderResult;
                                }
                                byte by5 = byteBuffer.get();
                                if (!this.isContinuation(by5)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(4);
                                    return coderResult;
                                }
                                n3 = (by & 3) << 24 | (by2 & 0x3F) << 18 | (by3 & 0x3F) << 12 | (by4 & 0x3F) << 6 | (by5 & 0x3F) << 0;
                                n2 = 5;
                                break;
                            }
                            case 12: 
                            case 13: {
                                if (byteBuffer.remaining() < 4) {
                                    CoderResult coderResult = CoderResult.UNDERFLOW;
                                    return coderResult;
                                }
                                by2 = byteBuffer.get();
                                if (!this.isContinuation(by2)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(1);
                                    return coderResult;
                                }
                                by3 = byteBuffer.get();
                                if (!this.isContinuation(by3)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(2);
                                    return coderResult;
                                }
                                byte by4 = byteBuffer.get();
                                if (!this.isContinuation(by4)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(3);
                                    return coderResult;
                                }
                                byte by5 = byteBuffer.get();
                                if (!this.isContinuation(by5)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(4);
                                    return coderResult;
                                }
                                byte by6 = byteBuffer.get();
                                if (!this.isContinuation(by6)) {
                                    CoderResult coderResult = CoderResult.malformedForLength(5);
                                    return coderResult;
                                }
                                n3 = (by & 1) << 30 | (by2 & 0x3F) << 24 | (by3 & 0x3F) << 18 | (by4 & 0x3F) << 12 | (by5 & 0x3F) << 6 | by6 & 0x3F;
                                n2 = 6;
                                break;
                            }
                            default: {
                                CoderResult coderResult = CoderResult.malformedForLength(1);
                                return coderResult;
                            }
                        }
                        if (this.sgg.generate(n3, n2, charBuffer) < 0) {
                            CoderResult coderResult = this.sgg.error();
                            return coderResult;
                        }
                        n += n2;
                        continue block43;
                    }
                }
                CoderResult coderResult = CoderResult.malformedForLength(1);
                return coderResult;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            byteBuffer.position(n);
        }
    }

    protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
        CoderResult coderResult = null;
        Boolean bl = false;
        int n = charBuffer.position();
        if (byteBuffer.hasArray() && charBuffer.hasArray()) {
            bl = true;
            coderResult = this.decodeArrayLoop(byteBuffer, charBuffer);
        } else {
            bl = false;
            coderResult = this.decodeBufferLoop(byteBuffer, charBuffer);
        }
        if (this.bidiEnabled) {
            int n2;
            int n3;
            char[] cArray;
            int n4 = charBuffer.position();
            if (bl.booleanValue()) {
                cArray = charBuffer.array();
                n3 = charBuffer.arrayOffset() + n;
                n2 = charBuffer.arrayOffset() + n4;
            } else {
                n3 = 0;
                n2 = n4 - n;
                cArray = new char[n2];
                charBuffer.position(n);
                charBuffer.get(cArray);
                charBuffer.position(n4);
            }
            BidiConvert bidiConvert = new BidiConvert();
            if (bidiConvert.isBidiData(cArray, n3, n2, this.bidiParms, this.toString())) {
                cArray = bidiConvert.toUnicode(cArray, n3, n2, this.bidiParms, this.toString());
                if (bl.booleanValue()) {
                    System.arraycopy(cArray, 0, charBuffer.array(), charBuffer.arrayOffset() + n, cArray.length);
                } else {
                    charBuffer.position(n);
                    charBuffer.put(cArray);
                }
            }
        }
        return coderResult;
    }
}

