/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nio.cs;

import com.ibm.nio.cs.Converter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

public class ISCII91
extends Converter {
    private static final char NUKTA_CHAR = '\u093c';
    private static final char HALANT_CHAR = '\u094d';

    public ISCII91() {
        super("ISCII91", "ISCII91");
    }

    protected int mapClass(String string) {
        return 6;
    }

    public CharsetDecoder newDecoder() {
        return new Decoder(this);
    }

    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private class Encoder
    extends CharsetEncoder {
        private static final byte NO_CHAR = -1;
        private final byte[] directMapTable;
        private final Surrogate.Parser sgp;

        private Encoder(Charset charset) {
            super(charset, 2.0f, 2.0f);
            this.directMapTable = ISCII91.this.c2b.getByteData();
            this.sgp = new Surrogate.Parser();
        }

        public boolean canEncode(char c) {
            return c >= '\u0900' && c <= '\u097f' || c == '\u200d' || c == '\u200c' || c >= '\u0000' && c <= '\u007f';
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            try {
                while (charBuffer.hasRemaining()) {
                    int n2 = Integer.MIN_VALUE;
                    char c = charBuffer.get();
                    if (c >= '\u0000' && c <= '\u007f') {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put((byte)c);
                        continue;
                    }
                    if (c == '\u200c') {
                        c = '\u094d';
                    } else if (c == '\u200d') {
                        c = '\u093c';
                    }
                    if (c >= '\u0900' && c <= '\u097f') {
                        n2 = (c - 2304) * 2;
                    }
                    if (c >= '\ud800' && c < '\udbff') {
                        if (this.sgp.parse(c, charBuffer) < 0) {
                            CoderResult coderResult = this.sgp.error();
                            return coderResult;
                        }
                        CoderResult coderResult = this.sgp.unmappableResult();
                        return coderResult;
                    }
                    if (n2 == Integer.MIN_VALUE || this.directMapTable[n2] == -1) {
                        CoderResult coderResult = CoderResult.unmappableForLength(1);
                        return coderResult;
                    }
                    byteBuffer.put(this.directMapTable[n2++]);
                    if (this.directMapTable[n2] != -1) {
                        if (byteBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        byteBuffer.put(this.directMapTable[n2]);
                    }
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }
    }

    private class Decoder
    extends CharsetDecoder {
        private final char[] directMapTable;
        private static final char ZWNJ_CHAR = '\u200c';
        private static final char ZWJ_CHAR = '\u200d';
        private static final char INVALID_CHAR = '\uffff';
        private char contextChar;
        private boolean needFlushing;

        private Decoder(Charset charset) {
            super(charset, 1.0f, 1.0f);
            this.directMapTable = ISCII91.this.b2c.getCharData();
            this.contextChar = (char)65535;
            this.needFlushing = false;
        }

        protected CoderResult implFlush(CharBuffer charBuffer) {
            if (this.needFlushing) {
                if (charBuffer.remaining() < 1) {
                    return CoderResult.OVERFLOW;
                }
                charBuffer.put(this.contextChar);
            }
            this.contextChar = (char)65535;
            this.needFlushing = false;
            return CoderResult.UNDERFLOW;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            int n = byteBuffer.position();
            try {
                block26: while (byteBuffer.hasRemaining()) {
                    int n2 = byteBuffer.get();
                    n2 = n2 < 0 ? n2 + 255 : n2;
                    char c = this.directMapTable[n2];
                    if (this.contextChar == '\ufffd') {
                        if (charBuffer.remaining() < 1) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        charBuffer.put('\ufffd');
                        this.contextChar = (char)65535;
                        this.needFlushing = false;
                        continue;
                    }
                    block7 : switch (c) {
                        case '\u0901': 
                        case '\u0907': 
                        case '\u0908': 
                        case '\u090b': 
                        case '\u093f': 
                        case '\u0940': 
                        case '\u0943': 
                        case '\u0964': {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            this.contextChar = c;
                            this.needFlushing = true;
                            continue block26;
                        }
                        case '\u093c': {
                            switch (this.contextChar) {
                                case '\u0901': {
                                    charBuffer.put('\u0950');
                                    break block7;
                                }
                                case '\u0907': {
                                    charBuffer.put('\u090c');
                                    break block7;
                                }
                                case '\u0908': {
                                    charBuffer.put('\u0961');
                                    break block7;
                                }
                                case '\u090b': {
                                    charBuffer.put('\u0960');
                                    break block7;
                                }
                                case '\u093f': {
                                    charBuffer.put('\u0962');
                                    break block7;
                                }
                                case '\u0940': {
                                    charBuffer.put('\u0963');
                                    break block7;
                                }
                                case '\u0943': {
                                    charBuffer.put('\u0944');
                                    break block7;
                                }
                                case '\u0964': {
                                    charBuffer.put('\u093d');
                                    break block7;
                                }
                                case '\u094d': {
                                    if (this.needFlushing) {
                                        charBuffer.put(this.contextChar);
                                        this.contextChar = c;
                                        continue block26;
                                    }
                                    charBuffer.put('\u200d');
                                    break block7;
                                }
                            }
                            if (this.needFlushing) {
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            charBuffer.put('\u093c');
                            break;
                        }
                        case '\u094d': {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            if (this.contextChar == '\u094d') {
                                charBuffer.put('\u200c');
                                break;
                            }
                            charBuffer.put('\u094d');
                            break;
                        }
                        case '\uffff': {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            CoderResult coderResult = CoderResult.unmappableForLength(1);
                            return coderResult;
                        }
                        default: {
                            if (this.needFlushing) {
                                if (charBuffer.remaining() < 1) {
                                    CoderResult coderResult = CoderResult.OVERFLOW;
                                    return coderResult;
                                }
                                charBuffer.put(this.contextChar);
                                this.contextChar = c;
                                continue block26;
                            }
                            charBuffer.put(c);
                        }
                    }
                    this.contextChar = c;
                    this.needFlushing = false;
                    ++n;
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }
    }
}

