/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wsspi.buffermgmt;

import com.ibm.wsspi.buffermgmt.WsByteBuffer;

public class WsByteBufferUtils {
    public static final byte[] asByteArray(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray == null) {
            throw new NullPointerException("Buffers passed to be converted are null.");
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            n += wsByteBufferArray[i].limit();
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            n3 = wsByteBufferArray[i].position();
            wsByteBufferArray[i].position(0);
            wsByteBufferArray[i].get(byArray, n2, wsByteBufferArray[i].limit());
            n2 += wsByteBufferArray[i].limit();
            wsByteBufferArray[i].position(n3);
        }
        return byArray;
    }

    public static final byte[] asByteArray(WsByteBuffer[] wsByteBufferArray, int[] nArray, int[] nArray2) {
        if (wsByteBufferArray == null) {
            throw new NullPointerException("Buffers passed to be converted are null.");
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            n += nArray2[i] - nArray[i];
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            n3 = wsByteBufferArray[i].position();
            wsByteBufferArray[i].position(nArray[i]);
            wsByteBufferArray[i].get(byArray, n2, nArray2[i] - nArray[i]);
            n2 += nArray2[i] - nArray[i];
            wsByteBufferArray[i].position(n3);
        }
        return byArray;
    }

    public static final String asString(WsByteBuffer[] wsByteBufferArray) {
        return new String(WsByteBufferUtils.asByteArray(wsByteBufferArray));
    }

    public static final String asString(WsByteBuffer[] wsByteBufferArray, int[] nArray, int[] nArray2) {
        return new String(WsByteBufferUtils.asByteArray(wsByteBufferArray, nArray, nArray2));
    }

    public static final String asString(WsByteBuffer wsByteBuffer) {
        return new String(WsByteBufferUtils.asByteArray(wsByteBuffer));
    }

    public static final String asString(WsByteBuffer wsByteBuffer, int n, int n2) {
        return new String(WsByteBufferUtils.asByteArray(wsByteBuffer, n, n2));
    }

    public static final byte[] asByteArray(WsByteBuffer wsByteBuffer) {
        if (wsByteBuffer == null) {
            throw new NullPointerException("Buffer passed to be converted are null.");
        }
        int n = wsByteBuffer.limit();
        byte[] byArray = new byte[n];
        int n2 = wsByteBuffer.position();
        wsByteBuffer.position(0);
        wsByteBuffer.get(byArray);
        wsByteBuffer.position(n2);
        return byArray;
    }

    public static final byte[] asByteArray(WsByteBuffer wsByteBuffer, int n, int n2) {
        if (wsByteBuffer == null) {
            throw new NullPointerException("Buffer passed to be converted are null.");
        }
        int n3 = n2 - n;
        byte[] byArray = new byte[n3];
        int n4 = wsByteBuffer.position();
        wsByteBuffer.position(n);
        wsByteBuffer.get(byArray, 0, n3);
        wsByteBuffer.position(n4);
        return byArray;
    }

    public static final StringBuffer asStringBuffer(WsByteBuffer[] wsByteBufferArray) {
        return new StringBuffer(WsByteBufferUtils.asString(wsByteBufferArray));
    }

    public static final StringBuffer asStringBuffer(WsByteBuffer wsByteBuffer) {
        return new StringBuffer(WsByteBufferUtils.asString(wsByteBuffer));
    }

    public static final int asInt(WsByteBuffer wsByteBuffer) {
        byte[] byArray = WsByteBufferUtils.asByteArray(wsByteBuffer);
        return WsByteBufferUtils.asInt(byArray);
    }

    public static final int asInt(WsByteBuffer wsByteBuffer, int n, int n2) {
        byte[] byArray = WsByteBufferUtils.asByteArray(wsByteBuffer, n, n2);
        return WsByteBufferUtils.asInt(byArray);
    }

    public static final int asInt(WsByteBuffer[] wsByteBufferArray) {
        byte[] byArray = WsByteBufferUtils.asByteArray(wsByteBufferArray);
        return WsByteBufferUtils.asInt(byArray);
    }

    public static final int asInt(WsByteBuffer[] wsByteBufferArray, int[] nArray, int[] nArray2) {
        byte[] byArray = WsByteBufferUtils.asByteArray(wsByteBufferArray, nArray, nArray2);
        return WsByteBufferUtils.asInt(byArray);
    }

    public static final int asInt(byte[] byArray) {
        int n = 0;
        int n2 = 1;
        boolean bl = false;
        for (int i = byArray.length - 1; i >= 0; --i) {
            if (byArray[i] < 48 || byArray[i] > 57) {
                if (bl) break;
                continue;
            }
            bl = true;
            n += (byArray[i] - 48) * n2;
            n2 *= 10;
        }
        if (byArray[0] == 45) {
            n = 0 - n;
        }
        return n;
    }

    public static void releaseBufferArray(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return;
        }
        for (int i = 0; i < wsByteBufferArray.length && null != wsByteBufferArray[i]; ++i) {
            wsByteBufferArray[i].release();
            wsByteBufferArray[i] = null;
        }
    }

    public static final int lengthOf(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length && null != wsByteBufferArray[i]; ++i) {
            n += wsByteBufferArray[i].limit() - wsByteBufferArray[i].position();
        }
        return n;
    }

    public static void flip(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].flip();
            }
        }
    }

    public static final int getTotalCapacity(WsByteBuffer[] wsByteBufferArray) {
        if (null == wsByteBufferArray) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            if (wsByteBufferArray[i] == null) continue;
            n += wsByteBufferArray[i].capacity();
        }
        return n;
    }

    public static void clearBufferArray(WsByteBuffer[] wsByteBufferArray) {
        if (wsByteBufferArray != null) {
            for (int i = 0; i < wsByteBufferArray.length; ++i) {
                if (wsByteBufferArray[i] == null) continue;
                wsByteBufferArray[i].clear();
            }
        }
    }

    public static void putByteArrayValue(WsByteBuffer[] wsByteBufferArray, byte[] byArray, boolean bl) {
        if (null == wsByteBufferArray) {
            return;
        }
        if (byArray.length > WsByteBufferUtils.getTotalCapacity(wsByteBufferArray)) {
            throw new IllegalArgumentException("Buffers not large enough");
        }
        int n = byArray.length;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < wsByteBufferArray.length; ++i) {
            n3 = wsByteBufferArray[i].capacity() - wsByteBufferArray[i].position();
            if (n <= n3) {
                wsByteBufferArray[i].put(byArray, n2, n);
                if (!bl) break;
                wsByteBufferArray[i].flip();
                break;
            }
            wsByteBufferArray[i].put(byArray, n2, n3);
            wsByteBufferArray[i].flip();
            n2 += n3;
            n -= n3;
        }
    }

    public static void putStringValue(WsByteBuffer[] wsByteBufferArray, String string, boolean bl) {
        WsByteBufferUtils.putByteArrayValue(wsByteBufferArray, string.getBytes(), bl);
    }

    public static WsByteBuffer[] expandBufferArray(WsByteBuffer[] wsByteBufferArray, WsByteBuffer[] wsByteBufferArray2) {
        if (null == wsByteBufferArray && null == wsByteBufferArray2) {
            return null;
        }
        int n = null != wsByteBufferArray ? wsByteBufferArray.length : 0;
        int n2 = null != wsByteBufferArray2 ? wsByteBufferArray2.length : 0;
        WsByteBuffer[] wsByteBufferArray3 = new WsByteBuffer[n + n2];
        System.arraycopy((Object)wsByteBufferArray, 0, (Object)wsByteBufferArray3, 0, n);
        System.arraycopy((Object)wsByteBufferArray2, 0, (Object)wsByteBufferArray3, n, n2);
        return wsByteBufferArray3;
    }

    public static WsByteBuffer[] expandBufferArray(WsByteBuffer[] wsByteBufferArray, WsByteBuffer wsByteBuffer) {
        if (null == wsByteBufferArray && null == wsByteBuffer) {
            return null;
        }
        int n = null != wsByteBufferArray ? wsByteBufferArray.length : 0;
        WsByteBuffer[] wsByteBufferArray2 = new WsByteBuffer[n + 1];
        System.arraycopy((Object)wsByteBufferArray, 0, (Object)wsByteBufferArray2, 0, n);
        wsByteBufferArray2[n] = wsByteBuffer;
        return wsByteBufferArray2;
    }
}

