/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.nws.ffdc;

import com.ibm.nws.ffdc.FFDCConstants;
import com.ibm.nws.ffdc.IntrospectionLevelMember;
import java.util.HashMap;

final class IntrospectionLevel {
    private int ivDepthNumber;
    private int ivNumOfBytesWithNextLevel;
    private int ivNumOfBytesWithoutNextLevel;
    private IntrospectionLevel ivPreviousLevel;
    private IntrospectionLevel ivNextLevel;
    private IntrospectionLevelMember[] ivLevelMembers;

    IntrospectionLevel(IntrospectionLevel introspectionLevel, IntrospectionLevelMember[] introspectionLevelMemberArray) {
        this.ivPreviousLevel = introspectionLevel;
        if (this.ivPreviousLevel != null) {
            this.ivDepthNumber = this.ivPreviousLevel.ivDepthNumber + 1;
        }
        this.ivLevelMembers = introspectionLevelMemberArray;
    }

    final int getNumberOfBytes(boolean bl) {
        if (bl) {
            return this.ivNumOfBytesWithNextLevel;
        }
        return this.ivNumOfBytesWithoutNextLevel;
    }

    final boolean hasMembers() {
        return this.ivLevelMembers != null && this.ivLevelMembers.length != 0;
    }

    final IntrospectionLevel getNextLevel(HashMap hashMap) {
        if (this.ivNextLevel == null) {
            int n;
            int n2 = this.ivLevelMembers.length;
            int n3 = 0;
            IntrospectionLevelMember[][] introspectionLevelMemberArrayArray = new IntrospectionLevelMember[n2][];
            for (n = 0; n < n2; ++n) {
                introspectionLevelMemberArrayArray[n] = this.ivLevelMembers[n].getNextMembers(hashMap);
                n3 += introspectionLevelMemberArrayArray[n].length;
            }
            int n4 = 0;
            int n5 = 0;
            IntrospectionLevelMember[] introspectionLevelMemberArray = new IntrospectionLevelMember[n3];
            for (n = 0; n < n2; ++n) {
                n5 = introspectionLevelMemberArrayArray[n].length;
                System.arraycopy((Object)introspectionLevelMemberArrayArray[n], 0, (Object)introspectionLevelMemberArray, n4, n5);
                n4 += n5;
            }
            this.ivNextLevel = new IntrospectionLevel(this, introspectionLevelMemberArray);
            this.ivNumOfBytesWithoutNextLevel = this.ivNumOfBytesWithNextLevel = 2 * this.ivDepthNumber * FFDCConstants.svSizeOfSpace * this.ivLevelMembers.length;
            for (int i = this.ivLevelMembers.length - 1; i >= 0; --i) {
                int n6 = this.ivLevelMembers[i].getNumberOfSelfIntrospectableMembers();
                if (n6 != 0) {
                    int n7 = 2 * (this.ivDepthNumber + 1) * FFDCConstants.svSizeOfSpace * n6;
                    this.ivNumOfBytesWithNextLevel += n7;
                    this.ivNumOfBytesWithoutNextLevel += n7;
                }
                this.ivNumOfBytesWithNextLevel += this.ivLevelMembers[i].getNumberOfBytes(true);
                this.ivNumOfBytesWithoutNextLevel += this.ivLevelMembers[i].getNumberOfBytes(false);
            }
        }
        return this.ivNextLevel;
    }
}

