/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.cmp;

import com.ibm.security.cmp.AlgorithmIds;
import com.ibm.security.cmp.CMP;
import com.ibm.security.cmp.InfoValue;
import com.ibm.security.cmputil.CMPDerObject;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.io.OutputStream;

public final class SignKeyPairTypesInfoValue
extends CMPDerObject
implements InfoValue,
Cloneable {
    private static final ObjectIdentifier oid = CMP.sign_key_pair_types_oid;
    private AlgorithmIds value;
    private byte[] encodedValue;

    public SignKeyPairTypesInfoValue(AlgorithmIds algorithmIds) throws IOException {
        if (algorithmIds == null) {
            throw new IllegalArgumentException("SignKeyPairTypesInfoValue error, algids not specified");
        }
        this.value = algorithmIds;
        this.setEncodedValue();
    }

    public SignKeyPairTypesInfoValue(byte[] byArray) throws IOException {
        this.decode(byArray);
    }

    public SignKeyPairTypesInfoValue(AlgorithmId[] algorithmIdArray) throws IOException {
        if (algorithmIdArray == null) {
            throw new IllegalArgumentException("SignKeyPairTypesInfoValue error, algids not specified");
        }
        if (algorithmIdArray.length == 0) {
            throw new IllegalArgumentException("EncKeyPairTypesInfoValue error, there should be at least one algorithm identifier");
        }
        this.value = new AlgorithmIds(algorithmIdArray);
        this.setEncodedValue();
    }

    public Object clone() {
        try {
            return new SignKeyPairTypesInfoValue(this.encodedValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected void decode(DerValue derValue) throws IOException {
        this.value = new AlgorithmIds(derValue.toByteArray());
        try {
            this.setEncodedValue();
        }
        catch (Exception exception) {
            throw new IOException("SignKeyPairTypesInfoValue parsing error, " + exception);
        }
    }

    public void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.encodedValue);
    }

    public boolean equals(SignKeyPairTypesInfoValue signKeyPairTypesInfoValue) {
        DerValue derValue;
        DerValue derValue2;
        if (signKeyPairTypesInfoValue == this) {
            return true;
        }
        try {
            DerOutputStream derOutputStream = new DerOutputStream();
            DerOutputStream derOutputStream2 = new DerOutputStream();
            this.encode((OutputStream)derOutputStream);
            derValue2 = new DerValue(derOutputStream.toByteArray());
            signKeyPairTypesInfoValue.encode((OutputStream)derOutputStream2);
            derValue = new DerValue(derOutputStream2.toByteArray());
        }
        catch (Exception exception) {
            return false;
        }
        return derValue2.equals(derValue);
    }

    public boolean equals(Object object) {
        if (object instanceof SignKeyPairTypesInfoValue) {
            return this.equals((SignKeyPairTypesInfoValue)object);
        }
        return false;
    }

    public byte[] getEncodedValue() {
        return this.encodedValue;
    }

    public String getName() {
        return "SignKeyPairTypes";
    }

    public ObjectIdentifier getObjectIdentifier() {
        return oid;
    }

    public Object getValue() {
        return (AlgorithmIds)this.value.clone();
    }

    private void setEncodedValue() throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        this.value.encode((OutputStream)derOutputStream);
        this.encodedValue = derOutputStream.toByteArray();
    }

    public String toString() {
        String string = "";
        Object object = this.getValue();
        string = String.valueOf(string) + "SignKeyPairTypesInfoValue:";
        string = String.valueOf(string) + "\r\nobject identifier: " + oid;
        string = String.valueOf(string) + "\r\n" + this.value;
        return string;
    }
}

