/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.kernel;

import java.io.ObjectStreamException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.datacache.DataCacheStoreManager;
import org.apache.openjpa.ee.ManagedRuntime;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.event.BrokerFactoryEvent;
import org.apache.openjpa.event.RemoteCommitEventManager;
import org.apache.openjpa.kernel.Broker;
import org.apache.openjpa.kernel.BrokerFactory;
import org.apache.openjpa.kernel.BrokerImpl;
import org.apache.openjpa.kernel.DelegatingStoreManager;
import org.apache.openjpa.kernel.ROPStoreManager;
import org.apache.openjpa.kernel.StoreManager;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.JavaVersions;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.ReferenceHashSet;
import org.apache.openjpa.lib.util.concurrent.ConcurrentHashMap;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashSet;
import org.apache.openjpa.lib.util.concurrent.ReentrantLock;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.GeneralException;
import org.apache.openjpa.util.InternalException;
import org.apache.openjpa.util.InvalidStateException;
import org.apache.openjpa.util.OpenJPAException;
import org.apache.openjpa.util.UserException;

public abstract class AbstractBrokerFactory
implements BrokerFactory {
    private static final Localizer _loc = Localizer.forPackage(AbstractBrokerFactory.class);
    private static final Map _pool = Collections.synchronizedMap(new HashMap());
    private final OpenJPAConfiguration _conf;
    private transient boolean _readOnly = false;
    private transient boolean _closed = false;
    private transient RuntimeException _closedException = null;
    private Map _userObjects = null;
    private final ReentrantLock _lock = new ReentrantLock();
    private transient ConcurrentHashMap _transactional = new ConcurrentHashMap();
    private transient Collection _brokers = new ConcurrentReferenceHashSet(2);
    private transient Collection _pcClassNames = null;
    private transient Collection _pcClassLoaders = null;
    private transient Map _lifecycleListeners = null;
    private transient List _transactionListeners = null;

    public static AbstractBrokerFactory getPooledFactory(OpenJPAConfiguration conf) {
        return (AbstractBrokerFactory)_pool.get(AbstractBrokerFactory.toPoolKey(conf));
    }

    private static Map toPoolKey(OpenJPAConfiguration conf) {
        return conf.toProperties(false);
    }

    protected static AbstractBrokerFactory getPooledFactory(Map map) {
        return (AbstractBrokerFactory)_pool.get(map);
    }

    protected AbstractBrokerFactory(OpenJPAConfiguration config) {
        this._conf = config;
    }

    public OpenJPAConfiguration getConfiguration() {
        return this._conf;
    }

    public Broker newBroker() {
        return this.newBroker(this._conf.getConnectionUserName(), this._conf.getConnectionPassword());
    }

    public Broker newBroker(String user, String pass) {
        return this.newBroker(user, pass, this._conf.isTransactionModeManaged(), this._conf.getConnectionRetainModeConstant());
    }

    public Broker newBroker(boolean managed, int connRetainMode) {
        return this.newBroker(this._conf.getConnectionUserName(), this._conf.getConnectionPassword(), managed, connRetainMode);
    }

    public Broker newBroker(String user, String pass, boolean managed, int connRetainMode) {
        return this.newBroker(user, pass, managed, connRetainMode, true);
    }

    public Broker newBroker(String user, String pass, boolean managed, int connRetainMode, boolean findExisting) {
        try {
            this.assertOpen();
            this.makeReadOnly();
            BrokerImpl broker = null;
            if (findExisting) {
                broker = this.findBroker(user, pass, managed);
            }
            if (broker == null) {
                StoreManager sm = this.newStoreManager();
                DelegatingStoreManager dsm = null;
                if (this._conf.getDataCacheManagerInstance().getSystemDataCache() != null) {
                    dsm = new DataCacheStoreManager(sm);
                }
                dsm = new ROPStoreManager(dsm == null ? sm : dsm);
                broker = this.newBrokerImpl(user, pass);
                broker.initialize(this, dsm, managed, connRetainMode);
                this.addListeners(broker);
                RemoteCommitEventManager remote = this._conf.getRemoteCommitEventManager();
                if (remote.areRemoteEventsEnabled()) {
                    broker.addTransactionListener(remote);
                }
                this.loadPersistentTypes(broker.getClassLoader());
            }
            this._brokers.add(broker);
            return broker;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (RuntimeException re) {
            throw new GeneralException(re);
        }
    }

    protected void addListeners(BrokerImpl broker) {
        if (this._lifecycleListeners != null && !this._lifecycleListeners.isEmpty()) {
            Iterator itr = this._lifecycleListeners.entrySet().iterator();
            while (itr.hasNext()) {
                Map.Entry entry = itr.next();
                broker.addLifecycleListener(entry.getKey(), (Class[])entry.getValue());
            }
        }
        if (this._transactionListeners != null && !this._transactionListeners.isEmpty()) {
            Iterator itr = this._transactionListeners.iterator();
            while (itr.hasNext()) {
                broker.addTransactionListener(itr.next());
            }
        }
    }

    private void loadPersistentTypes(ClassLoader envLoader) {
        if (this._pcClassNames != null && this._pcClassNames.isEmpty()) {
            return;
        }
        ClassLoader loader = this._conf.getClassResolverInstance().getClassLoader(this.getClass(), envLoader);
        ArrayList toRedefine = new ArrayList();
        if (this._pcClassNames == null) {
            Collection clss = this._conf.getMetaDataRepositoryInstance().loadPersistentTypes(false, loader);
            if (clss.isEmpty()) {
                this._pcClassNames = Collections.EMPTY_SET;
            } else {
                this._pcClassNames = new ArrayList(clss.size());
                Iterator itr = clss.iterator();
                while (itr.hasNext()) {
                    Class cls = (Class)itr.next();
                    this._pcClassNames.add(cls.getName());
                    if (!this.needsSub(cls)) continue;
                    toRedefine.add(cls);
                }
                this._pcClassLoaders = new ReferenceHashSet(2);
                this._pcClassLoaders.add(loader);
            }
        } else if (this._pcClassLoaders.add(loader)) {
            Iterator itr = this._pcClassNames.iterator();
            while (itr.hasNext()) {
                try {
                    Class<?> cls = Class.forName((String)itr.next(), true, loader);
                    if (!this.needsSub(cls)) continue;
                    toRedefine.add(cls);
                }
                catch (Throwable t) {
                    this._conf.getLog("openjpa.Runtime").warn(null, t);
                }
            }
        }
        if (JavaVersions.VERSION >= 5) {
            try {
                Class<?> cls = Class.forName("org.apache.openjpa.enhance.ManagedClassSubclasser");
                cls.getMethod("prepareUnenhancedClasses", OpenJPAConfiguration.class, Collection.class, ClassLoader.class).invoke(null, this._conf, toRedefine, envLoader);
            }
            catch (NoSuchMethodException e) {
                throw new InternalException(e);
            }
            catch (IllegalAccessException e) {
                throw new InternalException(e);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof OpenJPAException) {
                    throw (OpenJPAException)cause;
                }
                throw new InternalException(cause);
            }
            catch (ClassNotFoundException e) {
                throw new InternalException(e);
            }
        }
    }

    private boolean needsSub(Class cls) {
        return !cls.isInterface() && !PersistenceCapable.class.isAssignableFrom(cls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLifecycleListener(Object listener, Class[] classes) {
        this.lock();
        try {
            this.assertOpen();
            if (this._lifecycleListeners == null) {
                this._lifecycleListeners = new HashMap(7);
            }
            this._lifecycleListeners.put(listener, classes);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLifecycleListener(Object listener) {
        this.lock();
        try {
            this.assertOpen();
            if (this._lifecycleListeners != null) {
                this._lifecycleListeners.remove(listener);
            }
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransactionListener(Object listener) {
        this.lock();
        try {
            this.assertOpen();
            if (this._transactionListeners == null) {
                this._transactionListeners = new LinkedList();
            }
            this._transactionListeners.add(listener);
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTransactionListener(Object listener) {
        this.lock();
        try {
            this.assertOpen();
            if (this._transactionListeners != null) {
                this._transactionListeners.remove(listener);
            }
        }
        finally {
            this.unlock();
        }
    }

    public boolean isClosed() {
        return this._closed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.lock();
        try {
            this.assertOpen();
            this.assertNoActiveTransaction();
            Map map = AbstractBrokerFactory.toPoolKey(this._conf);
            Map map2 = _pool;
            synchronized (map2) {
                if (_pool.get(map) == this) {
                    _pool.remove(map);
                }
            }
            Iterator itr = this._brokers.iterator();
            while (itr.hasNext()) {
                Broker broker = (Broker)itr.next();
                if (broker == null || broker.isClosed()) continue;
                broker.close();
            }
            if (this._conf.metaDataRepositoryAvailable()) {
                PCRegistry.removeRegisterClassListener(this._conf.getMetaDataRepositoryInstance());
            }
            this._conf.close();
            this._closed = true;
            Log log = this._conf.getLog("openjpa.Runtime");
            if (log.isTraceEnabled()) {
                this._closedException = new IllegalStateException();
            }
        }
        finally {
            this.unlock();
        }
    }

    public Properties getProperties() {
        Properties props = new Properties();
        props.setProperty("VendorName", "OpenJPA");
        props.setProperty("VersionNumber", OpenJPAVersion.VERSION_NUMBER);
        props.setProperty("VersionId", OpenJPAVersion.VERSION_ID);
        return props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getUserObject(Object key) {
        this.lock();
        try {
            this.assertOpen();
            Object var2_2 = this._userObjects == null ? null : this._userObjects.get(key);
            return var2_2;
        }
        finally {
            this.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object putUserObject(Object key, Object val) {
        this.lock();
        try {
            this.assertOpen();
            if (val == null) {
                Object var3_3 = this._userObjects == null ? null : this._userObjects.remove(key);
                return var3_3;
            }
            if (this._userObjects == null) {
                this._userObjects = new HashMap();
            }
            Object object = this._userObjects.put(key, val);
            return object;
        }
        finally {
            this.unlock();
        }
    }

    public void lock() {
        this._lock.lock();
    }

    public void unlock() {
        this._lock.unlock();
    }

    protected Object readResolve() throws ObjectStreamException {
        AbstractBrokerFactory factory = AbstractBrokerFactory.getPooledFactory(this._conf);
        if (factory != null) {
            return factory;
        }
        this._transactional = new ConcurrentHashMap();
        this._brokers = new ConcurrentReferenceHashSet(2);
        this.makeReadOnly();
        return this;
    }

    protected abstract StoreManager newStoreManager();

    protected BrokerImpl findBroker(String user, String pass, boolean managed) {
        if (managed) {
            return this.findTransactionalBroker(user, pass);
        }
        return null;
    }

    protected BrokerImpl newBrokerImpl(String user, String pass) {
        BrokerImpl broker = this._conf.newBrokerInstance(user, pass);
        if (broker == null) {
            throw new UserException(_loc.get("no-broker-class", this._conf.getBrokerImpl()));
        }
        return broker;
    }

    protected void setup() {
    }

    protected BrokerImpl findTransactionalBroker(String user, String pass) {
        Object txKey;
        ManagedRuntime mr = this._conf.getManagedRuntimeInstance();
        try {
            Transaction trans = mr.getTransactionManager().getTransaction();
            txKey = mr.getTransactionKey();
            if (trans == null || trans.getStatus() == 6 || trans.getStatus() == 5) {
                return null;
            }
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
        Collection brokers = (Collection)this._transactional.get(txKey);
        if (brokers != null) {
            Iterator itr = brokers.iterator();
            while (itr.hasNext()) {
                BrokerImpl broker = (BrokerImpl)itr.next();
                if (!StringUtils.equals(broker.getConnectionUserName(), user) || !StringUtils.equals(broker.getConnectionPassword(), pass)) continue;
                return broker;
            }
        }
        return null;
    }

    protected void configureBroker(BrokerImpl broker) {
        broker.setOptimistic(this._conf.getOptimistic());
        broker.setNontransactionalRead(this._conf.getNontransactionalRead());
        broker.setNontransactionalWrite(this._conf.getNontransactionalWrite());
        broker.setRetainState(this._conf.getRetainState());
        broker.setRestoreState(this._conf.getRestoreStateConstant());
        broker.setAutoClear(this._conf.getAutoClearConstant());
        broker.setIgnoreChanges(this._conf.getIgnoreChanges());
        broker.setMultithreaded(this._conf.getMultithreaded());
        broker.setAutoDetach(this._conf.getAutoDetachConstant());
        broker.setDetachState(this._conf.getDetachStateInstance().getDetachState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void pool() {
        Map map = _pool;
        synchronized (map) {
            _pool.put(AbstractBrokerFactory.toPoolKey(this._conf), this);
            this.makeReadOnly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeReadOnly() {
        if (this._readOnly) {
            return;
        }
        this.lock();
        try {
            if (this._readOnly) {
                return;
            }
            this._readOnly = true;
            Log log = this._conf.getLog("openjpa.Runtime");
            if (log.isInfoEnabled()) {
                log.info(this.getFactoryInitializationBanner());
            }
            if (log.isTraceEnabled()) {
                Map props = this._conf.toProperties(true);
                String lineSep = J2DoPrivHelper.getLineSeparator();
                StringBuffer buf = new StringBuffer();
                Iterator itr = props.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry entry = itr.next();
                    buf.append(entry.getKey()).append(": ").append(entry.getValue());
                    if (!itr.hasNext()) continue;
                    buf.append(lineSep);
                }
                log.trace(_loc.get("factory-properties", buf.toString()));
            }
            this.setup();
            MetaDataRepository repos = this._conf.getMetaDataRepositoryInstance();
            repos.setValidate(8, true);
            repos.setResolve(8, true);
            PCRegistry.addRegisterClassListener(repos);
            this._conf.setReadOnly(true);
            this._conf.instantiateAll();
            this._conf.getBrokerFactoryEventManager().fireEvent(new BrokerFactoryEvent(this, 0));
        }
        finally {
            this.unlock();
        }
    }

    protected Object getFactoryInitializationBanner() {
        return _loc.get("factory-init", OpenJPAVersion.VERSION_NUMBER);
    }

    private void assertOpen() {
        if (this._closed) {
            if (this._closedException == null) {
                throw new InvalidStateException(_loc.get("closed-factory-notrace"));
            }
            throw new InvalidStateException(_loc.get("closed-factory")).setCause(this._closedException);
        }
    }

    private void assertNoActiveTransaction() {
        if (this._transactional.isEmpty()) {
            return;
        }
        ArrayList<OpenJPAException> excs = new ArrayList<OpenJPAException>(this._transactional.size());
        Iterator trans = this._transactional.values().iterator();
        while (trans.hasNext()) {
            Collection brokers = (Collection)trans.next();
            Iterator itr = brokers.iterator();
            while (itr.hasNext()) {
                excs.add(new InvalidStateException(_loc.get("active")).setFailedObject(itr.next()));
            }
        }
        if (!excs.isEmpty()) {
            throw new InvalidStateException(_loc.get("nested-exceps")).setNestedThrowables(excs.toArray(new Throwable[excs.size()]));
        }
    }

    boolean syncWithManagedTransaction(BrokerImpl broker, boolean begin) {
        try {
            ManagedRuntime mr = broker.getManagedRuntime();
            TransactionManager tm = mr.getTransactionManager();
            Transaction trans = tm.getTransaction();
            if (trans != null && (trans.getStatus() == 6 || trans.getStatus() == 5)) {
                trans = null;
            }
            if (trans == null && begin) {
                tm.begin();
                trans = tm.getTransaction();
            } else if (trans == null) {
                return false;
            }
            trans.registerSynchronization((Synchronization)broker);
            Object txKey = mr.getTransactionKey();
            ArrayList<BrokerImpl> brokers = (ArrayList<BrokerImpl>)this._transactional.get(txKey);
            if (brokers == null) {
                brokers = new ArrayList<BrokerImpl>(2);
                this._transactional.put(txKey, brokers);
                trans.registerSynchronization((Synchronization)new RemoveTransactionSync(txKey));
            }
            brokers.add(broker);
            return true;
        }
        catch (OpenJPAException ke) {
            throw ke;
        }
        catch (Exception e) {
            throw new GeneralException(e);
        }
    }

    public Collection getOpenBrokers() {
        return Collections.unmodifiableCollection(this._brokers);
    }

    private class RemoveTransactionSync
    implements Synchronization {
        private final Object _trans;

        public RemoveTransactionSync(Object trans) {
            this._trans = trans;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            AbstractBrokerFactory.this._transactional.remove(this._trans);
        }
    }
}

