/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.kernel.GenericResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.JDBCFetchConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.kernel.MappedQueryResultObjectProvider;
import org.apache.openjpa.jdbc.kernel.SQLProjectionResultObjectProvider;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.MappingRepository;
import org.apache.openjpa.jdbc.meta.QueryResultMapping;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.jdbc.sql.Result;
import org.apache.openjpa.jdbc.sql.ResultSetResult;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.AbstractStoreQuery;
import org.apache.openjpa.kernel.QueryContext;
import org.apache.openjpa.kernel.StoreQuery;
import org.apache.openjpa.lib.rop.RangeResultObjectProvider;
import org.apache.openjpa.lib.rop.ResultObjectProvider;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.util.UserException;
import serp.util.Numbers;

public class SQLStoreQuery
extends AbstractStoreQuery {
    private static final Localizer _loc = Localizer.forPackage(SQLStoreQuery.class);
    private final transient JDBCStore _store;

    public SQLStoreQuery(JDBCStore store) {
        this._store = store;
    }

    public JDBCStore getStore() {
        return this._store;
    }

    private static String substituteParams(String sql2, List params) throws IOException {
        int ttype;
        if (sql2.indexOf("?1") == -1) {
            return sql2;
        }
        ArrayList<Integer> paramOrder = new ArrayList<Integer>();
        StreamTokenizer tok = new StreamTokenizer(new StringReader(sql2));
        tok.resetSyntax();
        tok.quoteChar(39);
        tok.wordChars(48, 57);
        tok.wordChars(63, 63);
        StringBuffer buf = new StringBuffer(sql2.length());
        block4: while ((ttype = tok.nextToken()) != -1) {
            switch (ttype) {
                case -3: {
                    if (tok.sval.startsWith("?") && tok.sval.length() > 1 && tok.sval.substring(1).indexOf("?") == -1) {
                        buf.append("?");
                        paramOrder.add(Integer.valueOf(tok.sval.substring(1)));
                        continue block4;
                    }
                    buf.append(tok.sval);
                    continue block4;
                }
                case 39: {
                    buf.append('\'');
                    if (tok.sval == null) continue block4;
                    buf.append(tok.sval);
                    buf.append('\'');
                    continue block4;
                }
            }
            buf.append((char)ttype);
        }
        ArrayList translated = new ArrayList();
        Iterator i = paramOrder.iterator();
        while (i.hasNext()) {
            int index = ((Number)i.next()).intValue() - 1;
            if (index >= params.size()) {
                throw new UserException(_loc.get("sqlquery-missing-params", sql2, String.valueOf(index), params));
            }
            translated.add(params.get(index));
        }
        params.clear();
        params.addAll(translated);
        return buf.toString();
    }

    public boolean supportsParameterDeclarations() {
        return false;
    }

    public boolean supportsDataStoreExecution() {
        return true;
    }

    public StoreQuery.Executor newDataStoreExecutor(ClassMetaData meta, boolean subclasses) {
        return new SQLExecutor(this, meta);
    }

    public boolean requiresCandidateType() {
        return false;
    }

    public boolean requiresParameterDeclarations() {
        return false;
    }

    private static class SQLExecutor
    extends AbstractStoreQuery.AbstractExecutor {
        private final ClassMetaData _meta;
        private final boolean _select;
        private final boolean _call;
        private final QueryResultMapping _resultMapping;

        public SQLExecutor(SQLStoreQuery q, ClassMetaData candidate) {
            QueryContext ctx = q.getContext();
            String resultMapping = ctx.getResultMappingName();
            if (resultMapping == null) {
                this._resultMapping = null;
            } else {
                ClassLoader envLoader = ctx.getStoreContext().getClassLoader();
                MappingRepository repos = q.getStore().getConfiguration().getMappingRepositoryInstance();
                this._resultMapping = repos.getQueryResultMapping(ctx.getResultMappingScope(), resultMapping, envLoader, true);
            }
            this._meta = candidate;
            String sql2 = StringUtils.trimToNull(ctx.getQueryString());
            if (sql2 == null) {
                throw new UserException(_loc.get("no-sql"));
            }
            this._select = sql2.length() > 6 && sql2.substring(0, 6).equalsIgnoreCase("select");
            this._call = sql2.length() > 4 && sql2.substring(0, 4).equalsIgnoreCase("call");
        }

        public int getOperation(StoreQuery q) {
            return this._select ? 1 : (q.getContext().getCandidateType() != null || q.getContext().getResultType() != null || q.getContext().getResultMappingName() != null || q.getContext().getResultMappingScope() != null ? 1 : 3);
        }

        public Number executeUpdate(StoreQuery q, Object[] params) {
            ArrayList<Object> paramList;
            JDBCStore store = ((SQLStoreQuery)q).getStore();
            DBDictionary dict = store.getDBDictionary();
            String sql2 = q.getContext().getQueryString();
            if (params.length > 0) {
                paramList = new ArrayList<Object>(Arrays.asList(params));
                try {
                    sql2 = SQLStoreQuery.substituteParams(sql2, paramList);
                }
                catch (IOException ioe) {
                    throw new UserException(ioe);
                }
            } else {
                paramList = Collections.EMPTY_LIST;
            }
            SQLBuffer buf = new SQLBuffer(dict).append(sql2);
            store.getContext().beginStore();
            Connection conn = store.getConnection();
            JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)q.getContext().getFetchConfiguration();
            CallableStatement stmnt = null;
            try {
                stmnt = buf.prepareCall(conn);
                int index = 0;
                Iterator i = paramList.iterator();
                while (i.hasNext()) {
                    dict.setUnknown(stmnt, ++index, i.next(), null);
                }
                int count = 0;
                count = this._call && !stmnt.execute() ? stmnt.getUpdateCount() : stmnt.executeUpdate();
                Integer n = Numbers.valueOf(count);
                return n;
            }
            catch (SQLException se) {
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException se2) {
                        // empty catch block
                    }
                }
                throw SQLExceptions.getStore(se, dict);
            }
            finally {
                try {
                    conn.close();
                }
                catch (SQLException se) {}
            }
        }

        public ResultObjectProvider executeQuery(StoreQuery q, Object[] params, StoreQuery.Range range) {
            ResultObjectProvider rop;
            ArrayList<Object> paramList;
            JDBCStore store = ((SQLStoreQuery)q).getStore();
            DBDictionary dict = store.getDBDictionary();
            String sql2 = q.getContext().getQueryString();
            if (params.length > 0) {
                paramList = new ArrayList<Object>(Arrays.asList(params));
                try {
                    sql2 = SQLStoreQuery.substituteParams(sql2, paramList);
                }
                catch (IOException ioe) {
                    throw new UserException(ioe);
                }
            } else {
                paramList = Collections.EMPTY_LIST;
            }
            SQLBuffer buf = new SQLBuffer(dict).append(sql2);
            Connection conn = store.getConnection();
            JDBCFetchConfiguration fetch = (JDBCFetchConfiguration)q.getContext().getFetchConfiguration();
            Statement stmnt = null;
            try {
                stmnt = this._select && !range.lrs ? buf.prepareStatement(conn) : (this._select ? buf.prepareStatement(conn, fetch, -1, -1) : (!range.lrs ? buf.prepareCall(conn) : buf.prepareCall(conn, fetch, -1, -1)));
                int index = 0;
                Iterator i = paramList.iterator();
                while (i.hasNext()) {
                    dict.setUnknown((PreparedStatement)stmnt, ++index, i.next(), null);
                }
                ResultSetResult res = new ResultSetResult(conn, stmnt, stmnt.executeQuery(), store);
                rop = this._resultMapping != null ? new MappedQueryResultObjectProvider(this._resultMapping, store, fetch, res) : (q.getContext().getCandidateType() != null ? new GenericResultObjectProvider((ClassMapping)this._meta, store, fetch, (Result)res) : new SQLProjectionResultObjectProvider(store, fetch, res, q.getContext().getResultType()));
            }
            catch (SQLException se) {
                if (stmnt != null) {
                    try {
                        stmnt.close();
                    }
                    catch (SQLException se2) {
                        // empty catch block
                    }
                }
                try {
                    conn.close();
                }
                catch (SQLException se2) {
                    // empty catch block
                }
                throw SQLExceptions.getStore(se, dict);
            }
            if (range.start != 0L || range.end != Long.MAX_VALUE) {
                rop = new RangeResultObjectProvider(rop, range.start, range.end);
            }
            return rop;
        }

        public String[] getDataStoreActions(StoreQuery q, Object[] params, StoreQuery.Range range) {
            return new String[]{q.getContext().getQueryString()};
        }

        public boolean isPacking(StoreQuery q) {
            return q.getContext().getCandidateType() == null;
        }
    }
}

