/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.sql;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.schema.Table;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class OracleDictionary
extends org.apache.openjpa.jdbc.sql.OracleDictionary {
    private static final Localizer _loc = Localizer.forPackage(OracleDictionary.class);
    public String versionColumnTableSyntax = null;
    public String versionColumnTimestampSyntax = null;
    public String versionColumnIntegerSyntax = null;
    public boolean checkVersionStrategy = false;
    public int defaultBatchLimit = 100;

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        DatabaseMetaData meta = conn.getMetaData();
        String productVersion = meta.getDatabaseProductVersion().split("Release ", 0)[1].split("\\.", 0)[0];
        int release = Integer.parseInt(productVersion);
    }

    public String[] getCreateTableSQL(Table table) {
        String[] create = super.getCreateTableSQL(table);
        if (this.versionColumnTableSyntax != null) {
            create[0] = create[0].concat(this.versionColumnTableSyntax);
        }
        if (!this.useTriggersForAutoAssign) {
            return create;
        }
        Column[] cols = table.getColumns();
        ArrayList<String> seqs = null;
        for (int i = 0; cols != null && i < cols.length; ++i) {
            String seq;
            if (!cols[i].isAutoAssigned()) continue;
            if (seqs == null) {
                seqs = new ArrayList<String>(4);
            }
            if ((seq = this.autoAssignSequenceName) == null) {
                seq = this.openjpa3GeneratedKeyNames ? super.getOpenJPA3GeneratedKeySequenceName(cols[i]) : this.getGeneratedKeySequenceName(cols[i]);
                seqs.add("CREATE SEQUENCE " + seq + " START WITH 1");
            }
            String trig = this.openjpa3GeneratedKeyNames ? super.getOpenJPA3GeneratedKeyTriggerName(cols[i]) : this.getGeneratedKeyTriggerName(cols[i]);
            seqs.add("CREATE OR REPLACE TRIGGER " + trig + " BEFORE INSERT ON " + table.getName() + " FOR EACH ROW BEGIN SELECT " + seq + ".nextval INTO " + ":new." + cols[i].getName() + " FROM DUAL; " + "END " + trig + ";");
        }
        if (seqs == null) {
            return create;
        }
        String[] sql2 = new String[create.length + seqs.size()];
        System.arraycopy(create, 0, sql2, 0, create.length);
        for (int i = 0; i < seqs.size(); ++i) {
            sql2[create.length + i] = (String)seqs.get(i);
        }
        return sql2;
    }

    public boolean supportsDBVersionStrategy(Column col) {
        if (this.versionColumnTableSyntax != null) {
            return true;
        }
        throw new StoreException(_loc.get("strategy-not-supported", col.getVersionStrategy().getAlias(), col.getFullName(), this.platform));
    }

    public String getVersionColumn(Column column, String tableAlias) {
        if (ColumnVersionStrategy.isVersionStrategyColumn(column.getVersionStrategy()) && this.versionColumnTableSyntax != null) {
            StringBuffer versionColumn = new StringBuffer();
            if ("row-change-timestamp".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(this.versionColumnTimestampSyntax).append(tableAlias).append(".").append(this.versionColumnIntegerSyntax).append(")").toString();
            }
            if ("row-change-long".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(tableAlias).append(".").append(this.versionColumnIntegerSyntax).toString();
            }
        }
        return column.toString();
    }

    public int getDefaultBatchLimit() {
        return this.defaultBatchLimit;
    }
}

