/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.sql;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.StoreException;

public class DB2Dictionary
extends org.apache.openjpa.jdbc.sql.DB2Dictionary {
    private static final Localizer _loc = Localizer.forPackage(DB2Dictionary.class);
    public String versionColumnTableSyntax = null;
    public String versionColumnTimestampSyntax = null;
    public String versionColumnIntegerSyntax = null;
    public int defaultBatchLimit = 100;

    public void connectedConfiguration(Connection conn) throws SQLException {
        super.connectedConfiguration(conn);
        if (this.db2ServerType == 3 && this.maj >= 9) {
            this.versionColumnTableSyntax = "NOT NULL GENERATED BY DEFAULT FOR EACH ROW ON UPDATE AS ROW CHANGE TIMESTAMP";
            this.versionColumnTimestampSyntax = "ROW CHANGE TIMESTAMP FOR";
            this.versionColumnIntegerSyntax = "ROW CHANGE TOKEN FOR";
        }
    }

    public String getTypeName(Column col) {
        if (!StringUtils.isEmpty(col.getTypeName())) {
            return this.appendSize(col, col.getTypeName());
        }
        if (col.isAutoAssigned() && this.autoAssignTypeName != null) {
            return this.appendSize(col, this.autoAssignTypeName);
        }
        if (col.getVersionStrategy() != null && ColumnVersionStrategy.isVersionStrategyColumn(col.getVersionStrategy()) && this.supportsDBVersionStrategy(col)) {
            return this.appendSize(col, this.versionColumnTableSyntax);
        }
        return this.appendSize(col, this.getTypeName(col.getType()));
    }

    public boolean supportsDBVersionStrategy(Column col) {
        if (this.versionColumnTableSyntax != null) {
            return true;
        }
        throw new StoreException(_loc.get("strategy-not-supported", col.getVersionStrategy().getAlias(), col.getFullName(), this.platform));
    }

    public String getVersionColumn(Column column, String tableAlias) {
        if (ColumnVersionStrategy.isVersionStrategyColumn(column.getVersionStrategy()) && this.versionColumnTableSyntax != null) {
            StringBuffer versionColumn = new StringBuffer();
            if ("row-change-timestamp".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(this.versionColumnTimestampSyntax).append(" ").append(tableAlias).toString();
            }
            if ("row-change-long".equals(column.getVersionStrategy().getAlias())) {
                return versionColumn.append(this.versionColumnIntegerSyntax).append(" ").append(tableAlias).toString();
            }
        }
        return column.toString();
    }

    public int getDefaultBatchLimit() {
        return this.defaultBatchLimit;
    }
}

