/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence.jdbc.kernel;

import com.ibm.ws.persistence.jdbc.meta.strats.ColumnVersionStrategy;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.VersionStrategy;
import org.apache.openjpa.jdbc.schema.Column;
import org.apache.openjpa.jdbc.sql.RowImpl;
import org.apache.openjpa.jdbc.sql.SQLExceptions;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.util.ApplicationIds;
import org.apache.openjpa.util.OptimisticException;

public class PreparedStatementManagerImpl
extends org.apache.openjpa.jdbc.kernel.PreparedStatementManagerImpl {
    private static final Localizer _wsLoc = Localizer.forPackage(PreparedStatementManagerImpl.class);
    private static final Localizer _loc = Localizer.forPackage(org.apache.openjpa.jdbc.kernel.PreparedStatementManagerImpl.class);
    private Map _cacheSql = Collections.synchronizedMap(new LinkedHashMap());
    private Map _cacheRows = Collections.synchronizedMap(new LinkedHashMap());
    private int _batchLimit;
    private boolean _disableBatch = false;
    private transient Log _log = null;
    private boolean _executeUpdate = true;

    public PreparedStatementManagerImpl(JDBCStore store, Connection conn, int batchLimit) {
        super(store, conn);
        this._batchLimit = batchLimit;
        this._log = store.getConfiguration().getLog("openjpa.jdbc.JDBC");
        if (this._log.isTraceEnabled()) {
            this._log.trace(_wsLoc.get("psManager"));
        }
    }

    public void flush() {
        RowImpl onerow = null;
        if (this._cacheSql.isEmpty()) {
            super.flush();
            return;
        }
        Set e = this._cacheSql.keySet();
        for (String key : e) {
            PreparedStatement ps = (PreparedStatement)this._cacheSql.get(key);
            ArrayList list = (ArrayList)this._cacheRows.get(key);
            if (list == null) {
                super.flush();
                return;
            }
            int rowsize = list.size();
            try {
                int count;
                if (rowsize == 1) {
                    onerow = (RowImpl)list.get(0);
                    onerow.flush(ps, this._dict, this._store);
                    count = ps.executeUpdate();
                    if (count != 1) {
                        Object failed = onerow.getFailedObject();
                        if (failed != null) {
                            this._exceptions.add(new OptimisticException(failed));
                        } else if (onerow.getAction() == 1) {
                            throw new SQLException(_loc.get("update-failed-no-failed-obj", String.valueOf(count), key).getMessage());
                        }
                    }
                    this._cacheRows.remove(key);
                    continue;
                }
                count = 0;
                for (int i = 0; i < list.size(); ++i) {
                    onerow = (RowImpl)list.get(i);
                    if (count < this._batchLimit || this._batchLimit == -1) {
                        onerow.flush(ps, this._dict, this._store);
                        ps.addBatch();
                        ++count;
                        continue;
                    }
                    try {
                        int[] rtn = ps.executeBatch();
                        this.checkUpdateCount(rtn, onerow, key);
                    }
                    catch (BatchUpdateException bex) {
                        SQLException sqex = bex.getNextException();
                        if (sqex == null) {
                            sqex = bex;
                        }
                        throw SQLExceptions.getStore(sqex, ps, this._dict);
                    }
                    onerow.flush(ps, this._dict, this._store);
                    ps.addBatch();
                    count = 1;
                }
                try {
                    int[] rtn = ps.executeBatch();
                    this.checkUpdateCount(rtn, onerow, key);
                }
                catch (BatchUpdateException bex) {
                    SQLException sqex = bex.getNextException();
                    if (sqex == null) {
                        sqex = bex;
                    }
                    throw SQLExceptions.getStore(sqex, ps, this._dict);
                }
                this._cacheRows.remove(key);
            }
            catch (SQLException se) {
                SQLException sqex = se.getNextException();
                if (sqex == null) {
                    sqex = se;
                }
                throw SQLExceptions.getStore(sqex, ps, this._dict);
            }
        }
    }

    private void checkUpdateCount(int[] count, RowImpl row, String sql2) throws SQLException {
        int cnt = 0;
        Object failed = null;
        block5: for (int i = 0; i < count.length; ++i) {
            cnt = count[i];
            switch (cnt) {
                case -3: {
                    failed = row.getFailedObject();
                    if (failed != null || row.getAction() == 0) {
                        this._exceptions.add(new OptimisticException(failed));
                        continue block5;
                    }
                    if (row.getAction() != 1) continue block5;
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", String.valueOf(count[i]), sql2).getMessage());
                }
                case -2: {
                    if (!this._log.isTraceEnabled()) continue block5;
                    this._log.trace(_wsLoc.get("batch_update_info", String.valueOf(cnt), sql2).getMessage());
                    continue block5;
                }
                case 0: {
                    if (row.getAction() != 1 && row.getAction() != 0) continue block5;
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", String.valueOf(count[i]), sql2).getMessage());
                }
            }
        }
    }

    protected void flushInternal(RowImpl row) throws SQLException {
        VersionStrategy strategy;
        int i;
        if (this._batchLimit == 0 || this._disableBatch) {
            super.flushInternal(row);
            return;
        }
        Column[] autoAssign = null;
        if (row.getAction() == 1) {
            autoAssign = row.getTable().getAutoAssignedColumns();
        }
        String sql2 = row.getSQL(this._dict);
        OpenJPAStateManager sm = row.getPrimaryKey();
        ClassMapping cmd = null;
        if (sm != null) {
            cmd = (ClassMapping)sm.getMetaData();
        }
        if (autoAssign != null && sm != null) {
            FieldMetaData[] fmd = cmd.getPrimaryKeyFields();
            for (i = 0; !this._disableBatch && i < fmd.length; ++i) {
                if (fmd[i].getValueStrategy() != 3) continue;
                this._disableBatch = true;
            }
        }
        if (!this._disableBatch && sm != null && (strategy = cmd.getVersion().getStrategy()) != null && ColumnVersionStrategy.isVersionStrategyColumn(strategy)) {
            this._disableBatch = true;
        }
        this.processSql(sql2, row);
        if (autoAssign != null && autoAssign.length > 0 && sm != null) {
            for (i = 0; i < autoAssign.length; ++i) {
                Object val = this._dict.getGeneratedKey(autoAssign[i], this._conn);
                cmd.assertJoinable(autoAssign[i]).setAutoAssignedValue(sm, this._store, autoAssign[i], val);
            }
            sm.setObjectId(ApplicationIds.create(sm.getPersistenceCapable(), cmd));
        }
    }

    private void processSql(String sql2, RowImpl row) throws SQLException {
        PreparedStatement ps = null;
        if (this._disableBatch) {
            if (!this._cacheSql.isEmpty()) {
                this.flush();
            }
            this.noBatchProcess(sql2, row);
        } else if (this._cacheSql.containsKey(sql2)) {
            ArrayList temprow = (ArrayList)this._cacheRows.get(sql2);
            temprow.add(row);
            this._cacheRows.put(sql2, temprow);
        } else {
            try {
                ps = this._conn.prepareStatement(sql2);
            }
            catch (SQLException se) {
                throw SQLExceptions.getStore(se, ps, this._dict);
            }
            this._cacheSql.put(sql2, ps);
            ArrayList<RowImpl> inputrow = new ArrayList<RowImpl>();
            inputrow.add(row);
            this._cacheRows.put(sql2, inputrow);
        }
    }

    private void noBatchProcess(String sql2, RowImpl row) throws SQLException {
        Statement stmnt = null;
        try {
            Object rs = null;
            stmnt = this._conn.prepareStatement(sql2);
            row.flush((PreparedStatement)stmnt, this._dict, this._store);
            int count = stmnt.executeUpdate();
            if (count != 1) {
                Object failed = row.getFailedObject();
                if (failed != null) {
                    this._exceptions.add(new OptimisticException(failed));
                } else if (row.getAction() == 1) {
                    throw new SQLException(_loc.get("update-failed-no-failed-obj", String.valueOf(count), sql2).getMessage());
                }
            }
        }
        catch (SQLException se) {
            throw SQLExceptions.getStore(se, row.getFailedObject(), this._dict);
        }
        finally {
            try {
                stmnt.close();
            }
            catch (SQLException se) {}
        }
    }
}

