/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.persistence;

import com.ibm.ws.persistence.EntityManagerFactoryImpl;
import com.ibm.ws.persistence.jdbc.kernel.OperationOrderUpdateManager;
import com.ibm.ws.persistence.jdbc.sql.DB2Dictionary;
import com.ibm.ws.persistence.jdbc.sql.OracleDictionary;
import com.ibm.ws.persistence.jdbc.sql.SQLFactoryImpl;
import com.ibm.ws.persistence.jdbc.sql.SQLServerDictionary;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.IntValue;
import org.apache.openjpa.lib.conf.PluginValue;
import org.apache.openjpa.persistence.EntityManagerFactoryValue;
import org.apache.openjpa.persistence.PersistenceProductDerivation;

public class WsJpaProductDerivation
extends PersistenceProductDerivation {
    public boolean beforeConfigurationLoad(Configuration c) {
        boolean rval = super.beforeConfigurationLoad(c);
        this.setProductInfo(c);
        if (rval) {
            if (!(c instanceof OpenJPAConfiguration)) {
                rval = false;
            } else {
                OpenJPAConfiguration conf = (OpenJPAConfiguration)c;
                conf.getCompatibilityInstance().setStrictIdentityValues(true);
                conf.setFetchBatchSize(-1);
                conf.setLog("File=stdout");
                IntValue runtimeUnenhancedClassesValue = (IntValue)c.getValue("RuntimeUnenhancedClasses");
                runtimeUnenhancedClassesValue.setDefault("warn");
                runtimeUnenhancedClassesValue.setString("warn");
                if (conf instanceof JDBCConfiguration) {
                    JDBCConfiguration jdbcConf = (JDBCConfiguration)conf;
                    jdbcConf.setUpdateManager(OperationOrderUpdateManager.class.getCanonicalName());
                    jdbcConf.setSQLFactory(SQLFactoryImpl.class.getCanonicalName());
                    PluginValue dbdictionaryPlugin = ((JDBCConfigurationImpl)jdbcConf).dbdictionaryPlugin;
                    dbdictionaryPlugin.setAlias("db2", DB2Dictionary.class.getCanonicalName());
                    dbdictionaryPlugin.setAlias("oracle", OracleDictionary.class.getCanonicalName());
                    dbdictionaryPlugin.setAlias("sqlserver", SQLServerDictionary.class.getCanonicalName());
                }
            }
            EntityManagerFactoryValue emf = (EntityManagerFactoryValue)c.getValue("EntityManagerFactory");
            if (emf != null) {
                emf.setDefault(EntityManagerFactoryImpl.class.getName());
                emf.setClassName(EntityManagerFactoryImpl.class.getName());
            } else {
                rval = false;
            }
        }
        return rval;
    }

    public int getType() {
        return 100;
    }

    private void setProductInfo(Configuration c) {
        c.setProductName("WSJPA");
    }

    public String getConfigurationPrefix() {
        return "wsjpa";
    }
}

