/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.util;

import com.ibm.keymanager.KeyManagerException;
import java.util.Hashtable;
import java.util.Vector;

public class CommandOptions {
    private static final String dash = "-";
    private static final int NOT_FOUND = -1;
    private static final int EXPECT_VALUE = 1;
    private static final int DONT_EXPECT_VALUE = 2;
    private Hashtable values;
    private int lastIndex = -1;
    private String[] options;
    private boolean allowMultiples;
    private final String set = "";

    public CommandOptions(String[] args, String options) throws KeyManagerException {
        this.parse(args, options, false);
    }

    public CommandOptions(String[] args, String options, boolean allowMultiples) throws KeyManagerException {
        this.parse(args, options, allowMultiples);
    }

    public CommandOptions(String[] args, String[] options) throws KeyManagerException {
        this.parse(args, options, false);
    }

    public CommandOptions(String[] args, String[] options, boolean allowMultiples) throws KeyManagerException {
        this.parse(args, options, allowMultiples);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String[] args, String options, boolean allowMultiples) throws KeyManagerException {
        if (options == null) {
            throw new KeyManagerException("Null options");
        }
        if (args == null) {
            this.values = new Hashtable(0);
            return;
        }
        this.allowMultiples = allowMultiples;
        this.values = new Hashtable(args.length);
        String value = null;
        int index = -1;
        int len = options.length();
        boolean duplicated = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].charAt(0) != '-') continue;
            String option = args[i];
            if (option.length() < 2) {
                throw new KeyManagerException(option);
            }
            char ch = option.charAt(1);
            index = options.indexOf(ch);
            if (index == -1) {
                throw new KeyManagerException(option);
            }
            duplicated = this.values.containsKey(option);
            if (index < len - 1 && options.charAt(index + 1) == ':') {
                if (duplicated && !allowMultiples) {
                    throw new KeyManagerException(option);
                }
                if (++i >= args.length) throw new KeyManagerException(option);
                value = args[i];
            } else {
                if (duplicated) {
                    throw new KeyManagerException(option);
                }
                value = "";
            }
            this.save(option, value, duplicated);
            this.lastIndex = i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parse(String[] args, String[] options, boolean allowMultiples) throws KeyManagerException {
        if (options == null || options.length == 0) {
            throw new KeyManagerException("No options");
        }
        if (args == null) {
            this.values = new Hashtable(0);
            return;
        }
        this.allowMultiples = allowMultiples;
        this.options = options;
        this.values = new Hashtable(args.length);
        int status = 0;
        boolean duplicated = false;
        for (int i = 0; i < args.length; ++i) {
            String value;
            if (args[i].charAt(0) != '-') continue;
            String option = args[i];
            duplicated = this.values.containsKey(option);
            status = this.getOption(option);
            if (status == -1) {
                throw new KeyManagerException(option);
            }
            if (status == 1) {
                if (duplicated && !allowMultiples) {
                    throw new KeyManagerException(option);
                }
                if (++i >= args.length) throw new KeyManagerException(option);
                value = args[i];
            } else {
                if (duplicated) {
                    throw new KeyManagerException(option);
                }
                value = "";
            }
            this.save(option, value, duplicated);
            this.lastIndex = i;
        }
    }

    private int getOption(String option) {
        int ret = -1;
        String opt = option.substring(1);
        for (int i = 0; i < this.options.length; ++i) {
            int len = this.options[i].length();
            if (len != 0) {
                String temp;
                if (len > 1 && this.options[i].charAt(len - 1) == ':') {
                    temp = this.options[i].substring(0, len - 1);
                    ret = 1;
                } else {
                    temp = this.options[i];
                    ret = 2;
                }
                if (ret != -1 && opt.equals(temp)) {
                    return ret;
                }
            }
            ret = -1;
        }
        return -1;
    }

    public Vector getMultiValue(String option) throws KeyManagerException {
        Object val = this.values.get(option);
        if (val == null) {
            return null;
        }
        if (val instanceof Vector) {
            return (Vector)val;
        }
        Vector v = new Vector(1);
        v.add(val);
        return v;
    }

    public String getValue(String option) throws KeyManagerException {
        Object val;
        if (option == null) {
            throw new KeyManagerException("Null option");
        }
        if (option.charAt(0) != '-') {
            option = dash + option;
        }
        if ((val = this.values.get(option)) == null) {
            return null;
        }
        if (this.allowMultiples && val instanceof Vector) {
            return (String)((Vector)val).firstElement();
        }
        return (String)val;
    }

    public int getValueAsInt(String option) throws NumberFormatException, KeyManagerException {
        String value = this.getValue(option);
        if (value == null) {
            throw new KeyManagerException(option);
        }
        return Integer.parseInt(value);
    }

    public long getValueAsLong(String option) throws NumberFormatException, KeyManagerException {
        String value = this.getValue(option);
        if (value == null) {
            throw new KeyManagerException(option);
        }
        return Long.parseLong(value);
    }

    public float getValueAsFloat(String option) throws NumberFormatException, KeyManagerException {
        String value = this.getValue(option);
        if (value == null) {
            throw new KeyManagerException(option);
        }
        return Float.parseFloat(value);
    }

    public boolean isSet(String option) throws KeyManagerException {
        if (option == null) {
            throw new KeyManagerException("Null option");
        }
        if (option.charAt(0) != '-') {
            option = dash + option;
        }
        return this.values.containsKey(option);
    }

    public Vector getMultiValue(char option) throws KeyManagerException {
        return this.getMultiValue(dash + option);
    }

    public String getValue(char option) throws KeyManagerException {
        return this.getValue(dash + option);
    }

    public int getValueAsInt(char option) throws NumberFormatException, KeyManagerException {
        return this.getValueAsInt(dash + option);
    }

    public long getValueAsLong(char option) throws NumberFormatException, KeyManagerException {
        return this.getValueAsLong(dash + option);
    }

    public float getValueAsFloat(char option) throws NumberFormatException, KeyManagerException {
        return this.getValueAsFloat(dash + option);
    }

    public boolean isSet(char option) {
        return this.values.containsKey(dash + option);
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    private void save(String option, String value, boolean duplicated) {
        if (!duplicated) {
            this.values.put(option, value);
        } else {
            Object val = this.values.get(option);
            if (!(val instanceof Vector)) {
                Vector<Object> v = new Vector<Object>(4);
                v.add(this.values.get(option));
                v.add(value);
                this.values.remove(option);
                this.values.put(option, v);
            } else {
                ((Vector)val).add(value);
            }
        }
    }
}

