/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport.tcp;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ThreadManager;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.i18n.PropertyResource;
import com.ibm.keymanager.transport.Transport;
import com.ibm.keymanager.transport.TransportListenerSpi;
import com.ibm.keymanager.transport.TransportThread;
import com.ibm.keymanager.transport.tcp.TCPTransport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TCPListener
extends TransportListenerSpi {
    public static final String ATTR_TIMEOUT = "TransportListener.tcp.timeout";
    public static final String ATTR_PORT = "TransportListener.tcp.port";
    private int port;
    private int timeout;
    private ThreadManager threadManager;
    private KMSDebug debug = KMSDebug.getInstance();
    private HashMap attributes;
    private Config config;
    private ServerSocket ssock;
    private int status;
    private PropertyResource pr = PropertyResource.getExceptionInstance();

    public void init(Config config) throws KeyManagerException {
        Object value = null;
        this.config = config;
        value = config.get(ATTR_PORT);
        if (value == null) {
            value = config.get(ATTR_PORT.substring(ATTR_PORT.indexOf(".") + 1));
        }
        if (value != null) {
            try {
                this.port = new Integer(((String)value).trim());
            }
            catch (NumberFormatException ex) {
                this.debug.trace("transport", "TCPListener", "init", ex);
                String msg = ex.getLocalizedMessage();
                if (msg != null) {
                    throw new KeyManagerException(this.pr.getString("invaltcp") + " " + msg);
                }
                throw new KeyManagerException(this.pr.getString("invaltcp"));
            }
        } else {
            this.debug.trace("transport", "TCPListener", "init", "there is no TCP listener port number in config file");
            throw new KeyManagerException(this.pr.getString("spectcp"));
        }
    }

    public int getPort() {
        return this.port;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public void register(ThreadManager manager) {
        this.threadManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadManager threadManager = this.threadManager;
        synchronized (threadManager) {
            try {
                this.ssock = new ServerSocket(this.port);
                this.configServerSocket(this.ssock);
                this.status = 1;
            }
            catch (Exception ex) {
                this.debug.trace("transport", "TCPListener", "run", ex);
                this.shutdown();
                this.threadManager.notifyAll();
                return;
            }
            this.threadManager.notifyAll();
        }
        Socket sock = null;
        try {
            while (true) {
                this.debug.trace("console", "TCPListener", "run", "listening on port " + this.port);
                sock = this.ssock.accept();
                this.debug.trace("console", "TCPListener", "run", "sock open? " + !sock.isClosed());
                TCPTransport transport = new TCPTransport(sock);
                transport.init(this.config);
                TransportThread thread = this.threadManager.startTransportThread();
                thread.register(this.threadManager);
                thread.setTransport(Transport.getInstance(transport));
                thread.start();
            }
        }
        catch (Exception ex) {
            this.debug.trace("transport", "TCPListener", "run", ex);
            if (this.status == -1) {
                this.debug.trace("transport", "TCPListener", "run", "TCP server socket is closed");
                return;
            }
            this.shutdown();
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    private void configServerSocket(ServerSocket ssock) throws IOException, KeyManagerException {
    }

    public void shutdown() {
        this.debug.entry("transport", "TCPListener", "shutdown");
        this.status = -1;
        if (this.ssock != null) {
            try {
                this.ssock.setSoTimeout(1);
                this.ssock.close();
            }
            catch (IOException ex) {
                this.debug.trace("transport", "TCPListener", "shutdown", ex);
            }
            this.ssock = null;
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAttribute(String name, Object value) {
    }

    public List getAttributeNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ATTR_TIMEOUT);
        return list;
    }

    public Object getAttribute(String name) {
        try {
            return this.config.get(name);
        }
        catch (KeyManagerException ex) {
            this.debug.trace("transport", "TCPListener", "getAttribute", ex);
            return null;
        }
    }

    public String getType() {
        return "TCP";
    }

    public int getStatus() {
        return this.status;
    }
}

