/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport.ssl;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.transport.MessageHeader;
import com.ibm.keymanager.transport.TransportMessage;
import com.ibm.keymanager.transport.TransportSpi;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.SocketException;
import javax.net.ssl.SSLSocket;

public class SSLTransport
extends TransportSpi {
    private SSLSocket sslSock;
    private BufferedInputStream bis;
    private BufferedOutputStream bos;
    private boolean isClosed;
    private Config config;
    private KMSDebug debug = KMSDebug.getInstance();
    private TransportMessage firstMsg;
    private boolean getFirstMsg;

    public SSLTransport(Object connection) {
        if (connection instanceof SSLSocket) {
            this.sslSock = (SSLSocket)connection;
        }
    }

    public void open() throws KeyManagerException {
        int timeout;
        Object value = this.initProp(this.config, "TransportListener.ssl.timeout");
        if (value != null) {
            try {
                timeout = new Integer(((String)value).trim()) * 60 * 1000;
            }
            catch (NumberFormatException ex) {
                this.debug.trace("transport", "SSLTransport", "open", ex);
                timeout = 600000;
            }
        } else {
            timeout = 600000;
        }
        try {
            this.sslSock.setSoTimeout(timeout);
        }
        catch (SocketException ex) {
            this.debug.trace("transport", "SSLTransport", "open", ex);
        }
        catch (IOException ex) {
            this.debug.trace("transport", "SSLTransport", "open", ex);
        }
        try {
            this.sslSock.startHandshake();
            this.bis = new BufferedInputStream(this.sslSock.getInputStream());
            this.bos = new BufferedOutputStream(this.sslSock.getOutputStream());
        }
        catch (IOException ex) {
            this.debug.trace("transport", "SSLTransport", "open", ex);
        }
    }

    private Object initProp(Config config, String key) throws KeyManagerException {
        Object value = config.get(key);
        if (value == null) {
            value = config.get(key.substring(key.indexOf(".") + 1));
            if (value == null) {
                this.debug.trace("transport", this.getClass().getName(), "initProp", key + " value can not be found in config");
            } else {
                this.debug.trace("transport", this.getClass().getName(), "initProp", key + "=" + value);
            }
        }
        return value;
    }

    public void init(Config config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] receive(int size) throws IOException {
        BufferedInputStream bufferedInputStream = this.bis;
        synchronized (bufferedInputStream) {
            this.debug.entry("transport", "SSLTransport", "receive(int)");
            byte[] result = new byte[size];
            if (this.sslSock.isClosed()) {
                this.debug.trace("transport", "SSLTransport", "received(int)", "socket is closed");
                throw new IOException("Socket is closed");
            }
            this.bis.read(result);
            this.debug.trace("transport", "SSLTransport", "receive(int)", result);
            return result;
        }
    }

    public int available() {
        try {
            return this.bis.available();
        }
        catch (IOException ex) {
            this.debug.trace("transport", "SSLTransport", "available", ex);
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportMessage receive() throws KeyManagerException, IOException {
        TransportMessage result = null;
        if (this.firstMsg != null) {
            result = this.firstMsg;
            this.firstMsg = null;
            return result;
        }
        BufferedInputStream bufferedInputStream = this.bis;
        synchronized (bufferedInputStream) {
            MessageHeader mh = new MessageHeader(this.receive(5));
            byte[] length = this.receive(4);
            int size = (length[0] & 0xFF) << 24 | (length[1] & 0xFF) << 16 | (length[2] & 0xFF) << 8 | length[3] & 0xFF;
            if (mh.getMajorType() == 1 && size > 10000) {
                throw new KeyManagerException("invalid length");
            }
            byte[] data = this.receive(size);
            result = new TransportMessage(mh, length, data);
        }
        if (!this.getFirstMsg) {
            this.getFirstMsg = true;
            this.firstMsg = result;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(TransportMessage message) throws IOException {
        BufferedOutputStream bufferedOutputStream = this.bos;
        synchronized (bufferedOutputStream) {
            byte[] data = message.getMessage();
            this.bos.write(data);
        }
    }

    public void close() throws IOException {
        this.bis.close();
        this.bos.close();
        this.sslSock.close();
        this.isClosed = true;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public String getType() {
        return "SSL";
    }

    public int getPort() {
        return this.sslSock.getPort();
    }
}

