/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport.ssl;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ThreadManager;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.i18n.PropertyResource;
import com.ibm.keymanager.keystore.KeyStoreLoader;
import com.ibm.keymanager.transport.Transport;
import com.ibm.keymanager.transport.TransportListenerSpi;
import com.ibm.keymanager.transport.TransportThread;
import com.ibm.keymanager.transport.ssl.SSLTransport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;

public class SSLListener
extends TransportListenerSpi {
    public static final String ATTR_TIMEOUT = "TransportListener.ssl.timeout";
    public static String ATTR_PROTOCOLS = "TransportListener.ssl.protocols";
    public static String ATTR_CIPHERSUITES = "TransportListener.ssl.ciphersuites";
    public static String ATTR_CLIENTAUTHN = "TransportListener.ssl.clientauthentication";
    public static String ATTR_KEYSTORE_NAME = "TransportListener.ssl.keystore.name";
    public static String ATTR_KEYSTORE_TYPE = "TransportListener.ssl.keystore.type";
    public static String ATTR_KEYSTORE_PASSWORD = "TransportListener.ssl.keystore.password";
    public static String ATTR_TRUSTSTORE_NAME = "TransportListener.ssl.truststore.name";
    public static String ATTR_TRUSTSTORE_TYPE = "TransportListener.ssl.truststore.type";
    public static String ATTR_PORT = "TransportListener.ssl.port";
    public static final int NO_CLIENT_AUTHN = 0;
    public static final int WANT_CLIENT_AUTHN = 1;
    public static final int NEED_CLIENT_AUTHN = 2;
    private PropertyResource pr = PropertyResource.getExceptionInstance();
    private int port;
    private ThreadManager threadManager;
    private KMSDebug debug = KMSDebug.getInstance();
    private SSLContext context;
    private Config config;
    private SSLServerSocket ssl_server_sock;
    private int status;

    public void init(Config config) throws KeyManagerException {
        String value;
        this.config = config;
        KeyStoreLoader ksloader = KeyStoreLoader.getInstance(config, this.debug);
        boolean clientAuth = false;
        String protocol = (String)this.initProp(config, ATTR_PROTOCOLS);
        if (protocol == null) {
            protocol = "SSL_TLS";
        }
        this.debug.trace("transport", "SSLListener", "init", "Loading key managers");
        KeyManager[] kms = ksloader.loadKeyManagers("ListKS", null);
        if (kms != null) {
            this.debug.trace("transport", "SSLListener", "init", "found key managers");
        }
        this.debug.trace("transport", "SSLListener", "init", "Loading trust managers");
        TrustManager[] tms = ksloader.loadTrustManagers("ListKS");
        if (tms != null) {
            this.debug.trace("transport", "SSLListener", "init", "found trust managers");
        }
        if ((value = (String)this.initProp(config, ATTR_PORT)) != null) {
            try {
                this.port = new Integer(value);
            }
            catch (NumberFormatException ex) {
                this.debug.trace("transport", "SSLListener", "init", ex);
                String msg = ex.getMessage();
                if (msg != null) {
                    throw new KeyManagerException(this.pr.getString("invalssl") + " " + msg);
                }
                throw new KeyManagerException(this.pr.getString("invalssl"));
            }
        } else {
            this.debug.trace("transport", "SSLListener", "init", "port is not specified, or not found, fail over to 443");
            throw new KeyManagerException(this.pr.getString("specssl"));
        }
        try {
            this.context = SSLContext.getInstance(protocol, "IBMJSSE2");
            this.context.init(kms, tms, null);
        }
        catch (Exception ex) {
            this.context = null;
            String ms = ex.getLocalizedMessage();
            if (ms == null) {
                throw (KeyManagerException)new KeyManagerException().initCause(ex);
            }
            throw (KeyManagerException)new KeyManagerException(ms).initCause(ex);
        }
        this.debug.exit("transport", "SSLListener", "init");
    }

    private Object initProp(Config config, String key) throws KeyManagerException {
        Object value = config.get(key);
        if (value == null) {
            value = config.get(key.substring(key.indexOf(".") + 1));
            if (value == null) {
                this.debug.trace("transport", this.getClass().getName(), "initProp", key + " value can not be found in config");
            } else {
                this.debug.trace("transport", this.getClass().getName(), "initProp", key + "=" + value);
            }
        }
        return value;
    }

    public int getPort() {
        return this.port;
    }

    public ThreadManager getThreadManager() {
        return this.threadManager;
    }

    public void register(ThreadManager manager) {
        this.threadManager = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadManager threadManager = this.threadManager;
        synchronized (threadManager) {
            SSLServerSocketFactory factory = this.context.getServerSocketFactory();
            try {
                this.ssl_server_sock = (SSLServerSocket)factory.createServerSocket(this.port);
                this.configServerSocket(this.ssl_server_sock);
                this.status = 1;
            }
            catch (Exception ex) {
                this.debug.trace("transport", "SSLListener", "run", ex);
                this.shutdown();
                this.threadManager.notifyAll();
                return;
            }
            this.threadManager.notifyAll();
        }
        try {
            while (true) {
                this.debug.trace("console", "SSLListener", "run", "listening on port " + this.port);
                SSLSocket ssl_sock = (SSLSocket)this.ssl_server_sock.accept();
                SSLTransport transport = new SSLTransport(ssl_sock);
                transport.init(this.config);
                TransportThread thread = this.threadManager.startTransportThread();
                thread.setTransport(Transport.getInstance(transport));
                thread.register(this.threadManager);
                thread.start();
            }
        }
        catch (Exception ex) {
            this.debug.trace("transport", "SSLListener", "run", ex);
            if (this.status == -1) {
                this.debug.trace("transport", "SSLListener", "run", "SSL server socket is closed");
                return;
            }
            this.shutdown();
            throw (RuntimeException)new RuntimeException().initCause(ex);
        }
    }

    private void configServerSocket(SSLServerSocket ssock) throws IOException, KeyManagerException {
        boolean clientAuth = false;
        Object value = null;
        String protocol = null;
        value = this.initProp(this.config, ATTR_PROTOCOLS);
        protocol = value != null ? (String)value : "SSL_TLS";
        ssock.setEnabledProtocols(new String[]{protocol});
        String[] cipherSuites = null;
        value = this.initProp(this.config, ATTR_CIPHERSUITES);
        if (value != null && !((String)value).equalsIgnoreCase("JSSE_ALL")) {
            String delim = ",";
            if (((String)value).indexOf(";") > 0) {
                delim = ";";
            }
            StringTokenizer st = new StringTokenizer((String)value, delim);
            cipherSuites = new String[st.countTokens()];
            int count = 0;
            while (st.hasMoreTokens()) {
                cipherSuites[count++] = st.nextToken();
            }
            ssock.setEnabledCipherSuites(cipherSuites);
        }
        if ((value = this.initProp(this.config, ATTR_CLIENTAUTHN)) != null) {
            try {
                int temp = new Integer((String)value);
                switch (temp) {
                    case 1: {
                        ssock.setWantClientAuth(true);
                        break;
                    }
                    case 2: {
                        ssock.setNeedClientAuth(true);
                    }
                }
            }
            catch (NumberFormatException ex) {
                this.debug.trace("transport", "SSLListener", "configServerSocket", ex);
            }
        }
    }

    public void shutdown() {
        this.debug.entry("transport", "SSLListener", "shutdown");
        this.status = -1;
        if (this.ssl_server_sock != null) {
            try {
                this.ssl_server_sock.setSoTimeout(1);
                this.ssl_server_sock.close();
            }
            catch (IOException ex) {
                this.debug.trace("transport", "SSLListener", "shutdown", ex);
            }
            this.ssl_server_sock = null;
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAttribute(String name, Object value) {
    }

    public List getAttributeNames() {
        ArrayList<String> list = new ArrayList<String>();
        list.add(ATTR_PROTOCOLS);
        list.add(ATTR_CIPHERSUITES);
        list.add(ATTR_CLIENTAUTHN);
        list.add(ATTR_KEYSTORE_NAME);
        list.add(ATTR_KEYSTORE_TYPE);
        list.add(ATTR_KEYSTORE_PASSWORD);
        list.add(ATTR_TRUSTSTORE_NAME);
        list.add(ATTR_TRUSTSTORE_TYPE);
        list.add(ATTR_TIMEOUT);
        return list;
    }

    public Object getAttribute(String name) {
        try {
            return this.config.get(name);
        }
        catch (KeyManagerException ex) {
            return null;
        }
    }

    public String getType() {
        return "SSL";
    }

    public int getStatus() {
        return this.status;
    }
}

