/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.ThreadManager;
import com.ibm.keymanager.transport.MessageHeader;
import com.ibm.keymanager.transport.Transport;
import com.ibm.keymanager.transport.TransportMessage;
import java.io.IOException;

public class TransportThread
extends Thread {
    private Transport transport;
    private KMSDebug debug = KMSDebug.getInstance();
    private ThreadManager manager;

    public void run() {
        this.debug.entry("transport", "TransportThread" + this.getName(), "run");
        try {
            this.transport.open();
            TransportMessage tm = this.transport.receive();
            MessageHeader mh = tm.getMessageHeader();
            if (mh.getMajorType() == 1) {
                this.debug.trace("transport", "TransportThread", "run", "Get tape drive message");
                this.debug.trace("transport", "TransportThread", "run", tm.getMessage());
                this.manager.startProcessorThread(this.transport, this.manager.getServerParameters(), false);
            } else if (mh.getMajorType() == 16) {
                this.debug.trace("transport", "TransportThread", "run", "Get admin message");
                this.debug.trace("transport", "TransportThread", "run", tm.getMessage());
                this.manager.startProcessorThread(this.transport, this.manager.getServerParameters(), true);
            }
        }
        catch (Exception ex) {
            this.debug.trace("transport", "TransportThread" + this.getName(), "run", ex);
        }
        this.debug.exit("transport", "TransportThread", "run");
    }

    public void destroy() {
        this.transport = null;
        if (this.isAlive()) {
            try {
                this.interrupt();
            }
            catch (SecurityException ex) {
                this.debug.trace("transport", "TransportThread" + this.getName(), "destroy", ex);
            }
        }
    }

    public void setTransport(Transport transport) {
        this.transport = transport;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public void closeTransport() throws IOException {
        this.transport.close();
    }

    public void register(ThreadManager manager) {
        this.manager = manager;
    }
}

