/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.transport.TransportMessage;
import com.ibm.keymanager.transport.TransportSpi;
import java.io.IOException;

public class Transport {
    private TransportSpi spi;

    Transport(TransportSpi spi) {
        this.spi = spi;
    }

    public static Transport getInstance(String providerClass) throws KeyManagerException {
        Class<?> classObj = null;
        try {
            classObj = Class.forName(providerClass);
        }
        catch (ClassNotFoundException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        Object obj = null;
        try {
            obj = classObj.newInstance();
        }
        catch (InstantiationException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        catch (IllegalAccessException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        return new Transport(obj);
    }

    public static Transport getInstance(TransportSpi spi) {
        return new Transport(spi);
    }

    public void init(Config config) throws KeyManagerException {
        this.spi.init(config);
    }

    public void open() throws KeyManagerException {
        this.spi.open();
    }

    public int available() {
        return this.spi.available();
    }

    public TransportMessage receive() throws KeyManagerException, IOException {
        return this.spi.receive();
    }

    public void send(TransportMessage message) throws IOException {
        this.spi.send(message);
    }

    public void close() throws IOException {
        this.spi.close();
    }

    public boolean isClosed() {
        return this.spi.isClosed();
    }

    public String getType() {
        return this.spi.getType();
    }

    public int getPort() {
        return this.spi.getPort();
    }
}

