/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.transport;

import com.ibm.keymanager.KeyManagerException;

public class MessageHeader {
    public static final int HEADER_SIZE = 5;
    public static final short TAPE_DRIVE_MAJOR_TYPE = 1;
    public static final short ADMIN_MAJOR_TYPE = 16;
    public static final short ADMIN_MINOR_TYPE_CONFIG_MERGE = 1;
    public static final short ADMIN_MINOR_TYPE_CONFIG_REWRITE = 2;
    public static final short ADMIN_MINOR_TYPE_DRIVETABLE_MERGE = 3;
    public static final short ADMIN_MINOR_TYPE_DRIVETABLE_REWRITE = 4;
    public static final byte FIRST_VERSION = 1;
    private byte version;
    private short majorType;
    private short minorType;

    public MessageHeader(byte version, short majorType, short minorType) {
        this.version = version;
        this.majorType = majorType;
        this.minorType = minorType;
    }

    public MessageHeader(byte[] data) throws KeyManagerException {
        if (data.length < 5) {
            throw new KeyManagerException("Insufficient data");
        }
        this.version = data[0];
        if (this.version != 1) {
            throw new KeyManagerException("Invalid message header");
        }
        this.majorType = (short)(data[1] << 8 & 0xFF | data[2] & 0xFF);
        if (this.majorType != 1 && this.majorType != 16) {
            throw new KeyManagerException("Invalid message header");
        }
        this.minorType = (short)(data[3] << 8 & 0xFF | data[4] & 0xFF);
    }

    public byte getVersion() {
        return this.version;
    }

    public short getMajorType() {
        return this.majorType;
    }

    public short getMinorType() {
        return this.minorType;
    }

    public byte[] getHeader() {
        byte[] data = new byte[]{this.version, (byte)(this.getMajorType() >>> 8 & 0xFF), (byte)(this.getMajorType() & 0xFF), (byte)(this.getMinorType() >>> 8 & 0xFF), (byte)(this.getMinorType() & 0xFF)};
        return data;
    }
}

