/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Crypto;
import java.math.BigInteger;

public class SigningInfo {
    byte[] signType = new byte[2];
    BigInteger signLen;
    byte[] signature;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "SigningInfo.class";

    SigningInfo(byte[] msg, int offset, int len, int type, Crypto crypto) throws KeyManagerException {
        int pos = 0;
        this.debug.entry("logic", className, "SigningInfo-Create");
        if (type == 1024) {
            this.origMsg = new byte[36];
            this.msglen = new BigInteger("36");
            this.origMsg[pos] = 4;
            this.origMsg[++pos] = 0;
            this.origMsg[++pos] = 0;
            this.origMsg[++pos] = 32;
            byte[] result = crypto.hash("SHA-256", msg, offset, len);
            System.arraycopy(result, 0, this.origMsg, ++pos, result.length);
        } else if (type == 0) {
            this.origMsg = new byte[4];
            this.msglen = new BigInteger("4");
        }
        this.debug.exit("logic", className, "SigningInfo-Create");
    }

    SigningInfo(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "SigningInfo-Parse");
        if (msg[offset] == 0 && msg[offset + 1] == 0 && (msg[offset + 2] != 0 || msg[offset + 3] != 0)) {
            this.debug.exit("logic", className, "SigningInfo-Parse", "Exception: Message the wrong type");
            throw new KeyManagerException(2, 1, "Message the wrong type");
        }
        int pos = offset;
        this.signType[0] = msg[pos];
        this.signType[1] = msg[++pos];
        ++pos;
        if (this.signType[0] != 4 && this.signType[0] != 0 || this.signType[1] > 0) {
            this.debug.exit("logic", className, "SigningInfo-Parse", "Exception: Unsupported signature type");
            throw new KeyManagerException(2, 20, "Unsupported signature type");
        }
        byte[] tmp = new byte[]{msg[pos], msg[++pos]};
        ++pos;
        this.signLen = new BigInteger(tmp);
        if (this.signLen.intValue() != 0) {
            this.signature = new byte[this.signLen.intValue()];
            System.arraycopy(msg, pos, this.signature, 0, this.signLen.intValue());
        }
        this.msglen = this.signLen.add(new BigInteger("4"));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.debug.exit("logic", className, "SigningInfo-Parse");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }

    int getSignatureLen() {
        this.debug.entry("logic", className, "getSignatureLen");
        this.debug.exit("logic", className, "getSignatureLen");
        return this.signLen.intValue();
    }

    byte[] getSignType() {
        this.debug.entry("logic", className, "getSignType");
        this.debug.exit("logic", className, "getSignType");
        return this.signType;
    }

    static int getLength(int type) throws KeyManagerException {
        int size = 4;
        switch (type) {
            case 1024: {
                size += 32;
                break;
            }
            case 0: {
                break;
            }
            default: {
                throw new KeyManagerException(2, 20, "Message the signature type unknown = " + type);
            }
        }
        return size;
    }

    boolean verify(byte[] msg, int offset, int len, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "verify");
        if (this.signType[0] == 4 && this.signType[1] == 0) {
            byte[] result = crypto.hash("SHA-256", msg, offset, len);
            if (result.length == this.signLen.intValue()) {
                for (int i = 0; i < result.length; ++i) {
                    if (result[i] == this.signature[i]) continue;
                    this.debug.exit("logic", className, "verify-2", "Could not be verified.");
                    return false;
                }
                this.debug.exit("logic", className, "verify-3", "Verified");
                return true;
            }
        } else if (this.signType[0] == 0 && this.signType[1] == 0) {
            this.debug.exit("logic", className, "verify-4", "Verified");
            return true;
        }
        this.debug.exit("logic", className, "verify", "Could not be verified.");
        return false;
    }
}

