/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Logic;
import java.math.BigInteger;

class RoutingInfo {
    byte[] WWDN = new byte[8];
    byte[] serialNum = new byte[12];
    byte[] routingSeq = new byte[4];
    byte command;
    byte routingDIdLib;
    byte routingDIdSense;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "RoutingInfo.class";

    RoutingInfo(RoutingInfo ri, byte command, boolean increment) throws KeyManagerException {
        this.debug.entry("logic", className, "RoutingInfo-Create");
        this.msglen = ri.getMsgLenBigInteger();
        this.origMsg = new byte[ri.getMsgLen()];
        System.arraycopy(ri.getMessage(), 0, this.origMsg, 0, ri.getMsgLen());
        if (increment) {
            byte[] tmp = new byte[4];
            System.arraycopy(this.origMsg, 24, tmp, 0, tmp.length);
            BigInteger rteSeq = new BigInteger(tmp);
            rteSeq = rteSeq.add(BigInteger.ONE);
            System.arraycopy(Logic.IntToByteArray(rteSeq.intValue(), 4), 0, this.origMsg, 24, 4);
        }
        this.origMsg[28] = command;
        this.parse(this.origMsg, 0);
        this.debug.exit("logic", className, "RoutingInfo-Create");
    }

    RoutingInfo(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "RoutingInfo-Parse");
        if (msg[offset] != 2 || msg[offset + 1] != 0) {
            this.debug.exit("logic", className, "RoutingInfo-Parse-1", "Exception: Message type not X0200");
            throw new KeyManagerException(2, 1, "Message type not X0200");
        }
        byte[] tmp = new byte[]{msg[offset + 2], msg[offset + 3]};
        this.msglen = new BigInteger(tmp);
        this.msglen = this.msglen.add(new BigInteger("4"));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.parse(msg, offset);
        this.debug.exit("logic", className, "RoutingInfo-Parse");
    }

    void parse(byte[] msg, int offset) {
        this.debug.entry("logic", className, "parse");
        int k = offset + 4;
        System.arraycopy(msg, k, this.WWDN, 0, 8);
        System.arraycopy(msg, k += 8, this.serialNum, 0, 12);
        System.arraycopy(msg, k += 12, this.routingSeq, 0, 4);
        this.command = msg[k += 4];
        ++k;
        this.routingDIdLib = msg[++k];
        this.routingDIdSense = msg[++k];
        this.debug.exit("logic", className, "parse");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    BigInteger getMsgLenBigInteger() {
        this.debug.entry("logic", className, "getMsgLenBigInteger");
        this.debug.exit("logic", className, "getMsgLenBigInteger");
        return this.msglen;
    }

    byte[] getWWDN() {
        this.debug.entry("logic", className, "getWWDN");
        this.debug.exit("logic", className, "getWWDN");
        return this.WWDN;
    }

    byte[] getDriveSerialNumber() {
        this.debug.entry("logic", className, "getDriveSerialNumber");
        this.debug.exit("logic", className, "getDriveSerialNumber");
        return this.serialNum;
    }

    byte[] getRoutingSeq() {
        this.debug.entry("logic", className, "getRoutingSeq");
        this.debug.exit("logic", className, "getRoutingSeq");
        return this.routingSeq;
    }

    byte getCommand() {
        this.debug.entry("logic", className, "getCommand");
        this.debug.exit("logic", className, "getCommand");
        return this.command;
    }

    byte getRoutingDIdLib() {
        this.debug.entry("logic", className, "getRoutingDIdLib");
        this.debug.exit("logic", className, "getRoutingDIdLib");
        return this.routingDIdLib;
    }

    byte getRoutingDIdSense() {
        this.debug.entry("logic", className, "getRoutingDIdSense");
        this.debug.exit("logic", className, "getRoutingDIdSense");
        return this.routingDIdSense;
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

