/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.ServerParameters;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.audit.Runtime_Event;
import com.ibm.keymanager.logic.Crypto;
import com.ibm.keymanager.logic.DriveErrorNotify;
import com.ibm.keymanager.logic.EncSubPageQueryResponse;
import com.ibm.keymanager.logic.EncSubPageStatusWrapper;
import com.ibm.keymanager.logic.EncryptionSubPage;
import com.ibm.keymanager.logic.EncryptionSubPageQuerydSK;
import com.ibm.keymanager.logic.EncryptionSubPageReqEEDKs;
import com.ibm.keymanager.logic.EncryptionSubPageReqEEDKsQuery;
import com.ibm.keymanager.logic.EncryptionSubPageTransEEDKs;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.logic.MediumInfo;
import com.ibm.keymanager.logic.MsgHeader;
import com.ibm.keymanager.logic.ProxyRoutingInfo;
import com.ibm.keymanager.logic.RequestEEDKs;
import com.ibm.keymanager.logic.RoutingInfo;
import com.ibm.keymanager.transport.Transport;
import com.ibm.security.keystoreski.KeyStoreSKIFactory;
import com.ibm.security.keystoreski.SKIDefinitionFactory;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import javax.crypto.spec.SecretKeySpec;

class MessageProcessor
extends Thread {
    Audit audit = null;
    Transport trans;
    ServerParameters params;
    Logic logic;
    LinkedList msgQueue;
    boolean run = true;
    byte[] modeHdr = null;
    MediumInfo medInfoOrig = null;
    ProxyRoutingInfo priOrig = null;
    RoutingInfo riOrig = null;
    RSAPublicKey p1024 = null;
    RSAPublicKey p2048 = null;
    Crypto crypto = null;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "MessageProcessor.class";
    int DRIVE_ERROR_NOTIFY = 255;
    int ENC_SUBPAGE_QUERY_RESPONSE = 113;
    int ENC_SUBPAGE_STATUS = 254;
    int ENC_SUBPAGE_QUERY_DSK = 223;
    int msgType = this.DRIVE_ERROR_NOTIFY;
    byte msgq;
    static final int INV_MESSAGE_TYPE = 1;
    static final int INV_SIGNATURE = 2;
    static final int INV_DKI_LENGTH = 3;
    static final int INV_DKV_LENGTH = 4;
    static final int INV_KEYFACTORY = 5;
    static final int INV_PAYLOAD_TYPE = 6;
    static final int INV_VALUE_NULL = 7;
    static final int INV_MESDATA = 8;
    static final int INV_SEQ_TAG = 9;
    static final int INV_DIGEST = 10;
    static final int INV_IA5STRING = 11;
    static final int INV_KEK = 12;
    static final int INV_EEDK = 13;
    static final int INV_MESSAGE_LEN = 14;
    static final int INV_SEDK = 15;
    static final int INV_SIG_ALG = 16;
    static final int INV_ENC_ALG = 17;
    static final int INV_KEDK = 18;
    static final int INV_DK = 19;
    static final int INV_SIG_TYPE = 20;
    static final int INV_VALUE_SPECIFIED = 21;
    static final int INV_GENERAL_ERR = 99;

    MessageProcessor(Transport transport, ServerParameters sparams, Logic logic) throws KeyManagerException {
        this.audit = Audit.getInstance();
        this.debug.entry("logic", className, "MessageProcessor");
        this.trans = transport;
        this.params = sparams;
        this.logic = logic;
        this.msgQueue = new LinkedList();
        this.crypto = new Crypto(sparams);
        this.debug.exit("logic", className, "MessageProcessor");
    }

    public void run() {
        this.debug.entry("logic", className, "run");
        while (this.run) {
            byte[] msg = null;
            try {
                msg = (byte[])this.msgQueue.removeFirst();
                this.debug.trace("logic", className, "run", "msg is");
                this.debug.trace("logic", className, "run", msg);
            }
            catch (NoSuchElementException ex) {
                this.debug.trace("logic", className, "run", "Exception was " + ex.getMessage());
            }
            catch (Exception e) {
                this.debug.trace("logic", className, "run", "Exception was " + e.getMessage());
            }
            if (msg != null && msg.length != 0) {
                byte[] message = this.ProcessMessage(this.msgType, msg);
                this.debug.trace("logic", className, "run", "ProcessMessage msgType = " + this.msgType);
                this.debug.trace("logic", className, "run", "message is");
                if (message != null) {
                    this.debug.trace("logic", className, "run", message);
                }
                if (message != null) {
                    this.logic.sendMsg(message);
                }
            }
            while (this.msgQueue.size() == 0) {
                try {
                    MessageProcessor.sleep(500L);
                }
                catch (InterruptedException ie) {
                    this.debug.trace("logic", className, "run", "Exception: " + ie.getMessage());
                }
            }
        }
        this.debug.exit("logic", className, "run");
    }

    public void dispose() {
        this.debug.entry("logic", className, "dispose");
        this.run = false;
        this.debug.exit("logic", className, "dispose");
    }

    LinkedList getQueue() {
        this.debug.entry("logic", className, "getQueue");
        this.debug.exit("logic", className, "getQueue");
        return this.msgQueue;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    byte[] ProcessMessage(int type, byte[] msg) {
        respMessage = null;
        this.debug.entry("logic", MessageProcessor.className, "ProcessMessage");
        switch (type) {
            case 255: {
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "type is 0XFF");
                den = null;
                try {
                    den = new DriveErrorNotify(msg, this.crypto);
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    respMessage = kme.getMinor() == 1 ? this.statusMessage(msg, (byte)-18, (byte)45) : (kme.getMinor() == 2 ? this.statusMessage(msg, (byte)-18, (byte)41) : this.statusMessage(msg, (byte)-18, (byte)46));
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return respMessage;
                }
                this.modeHdr = den.getModeParameterHeader();
                this.priOrig = den.getMessageHeader().getProxyRoutingInfo();
                this.riOrig = den.getEncryptionSubPageWrapper().getRoutingInformation();
                this.medInfoOrig = den.getEncryptionSubPageWrapper().getMediumInformation();
                ep = (EncryptionSubPage)den.getEncryptionSubPageWrapper().getPayLoad();
                dsn = this.priOrig.getDriveSerialNumber();
                WWN = this.priOrig.getWWDN();
                try {
                    if (this.audit.isOn("runtime", "success")) {
                        re = new Runtime_Event((Object)this, "start", new String("Drive Serial Number: " + new String(dsn)), true);
                        this.audit.record(re);
                        re = new Runtime_Event((Object)this, "start", new String("WWDN: " + new String(WWN)), true);
                        this.audit.record(re);
                    }
                }
                catch (KeyManagerException ke) {
                    // empty catch block
                }
                asc = ep.getAdditionalSenseCode();
                ascq = ep.getAdditionalSenseCodeQualifier();
                this.msgq = (byte)-17;
                if (this.debug.isOn("logic")) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "DriveSerialNumber");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", dsn);
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "WWDN");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", WWN);
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "ModeParameterHeader");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", this.modeHdr);
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "ProxyRoutingInfo");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", this.priOrig.getMessage());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "RoutingInformation");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", this.riOrig.getMessage());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "MediumInformation");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", this.medInfoOrig.getMessage());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "PayLoad");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", ep.getMessage());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "AdditionalSenseCode");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", new byte[]{asc});
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", new byte[]{ascq});
                }
                if (asc == -17 && ascq == 16) {
                    this.msgq = (byte)-29;
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "EF10 Key Acqustion request");
                } else if (asc == -17 && ascq == 19) {
                    this.msgq = (byte)-18;
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "EF13 Key Translate request");
                } else {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "EF11 Key Create request");
                }
                reqEEDKs = null;
                try {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "RequestEEDKs-dSKs");
                    reqEEDKs = new RequestEEDKs(den.getMessageHeader(), -128, -33, this.crypto);
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "RequestEEDKs-dSKs done");
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)39);
                }
                this.msgType = this.ENC_SUBPAGE_QUERY_DSK;
                respMessage = reqEEDKs.getMessage();
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "respMessage is");
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", respMessage);
                break;
            }
            case 223: {
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "type is 0XDF");
                resp = null;
                try {
                    resp = new EncSubPageQueryResponse(msg, this.crypto);
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    respMessage = kme.getMinor() == 1 ? this.statusMessage(msg, (byte)-18, (byte)45) : (kme.getMinor() == 2 ? this.statusMessage(msg, (byte)-18, (byte)41) : (kme.getMinor() == 20 ? this.statusMessage(msg, (byte)-18, (byte)46) : this.statusMessage(msg, (byte)-18, (byte)44)));
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return respMessage;
                }
                obj = resp.getEncryptionSubPageWrapper().getPayLoad();
                espqdSK = null;
                if (!(obj instanceof EncryptionSubPageQuerydSK)) {
                    if (this.debug.isOn("logic")) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: Unexpected Payload");
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Message Data =");
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", msg);
                        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    }
                    return this.statusMessage(msg, (byte)-18, (byte)44);
                }
                espqdSK = (EncryptionSubPageQuerydSK)obj;
                DSKs = espqdSK.getdSKs();
                try {
                    this.p1024 = null;
                    this.p2048 = null;
                    for (i = 0; i < espqdSK.getdSKCount(); ++i) {
                        keySpec = new X509EncodedKeySpec(DSKs[i].getKeyData());
                        key = this.crypto.KeyFactoryPublic(keySpec);
                        keysize = (key.getModulus().toByteArray().length * 8 + 7) / 8;
                        if (keysize < 256) {
                            this.p1024 = key;
                            continue;
                        }
                        this.p2048 = key;
                    }
                }
                catch (Exception ex) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                if (espqdSK.getdSKCount() == 0) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Unexpected dSK count: 0 ");
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)44);
                }
                try {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "RequestEEDKs");
                    reqEEDKs = new RequestEEDKs(resp.getMessageHeader(), -128, this.msgq, this.crypto);
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "RequestEEDKs done");
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)35);
                }
                this.msgType = this.ENC_SUBPAGE_QUERY_RESPONSE;
                respMessage = reqEEDKs.getMessage();
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "respMessage is");
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", respMessage);
                break;
            }
            case 113: {
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "type is 0X71");
                denResp = null;
                try {
                    resp = new EncSubPageQueryResponse(msg, this.crypto);
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    respMessage = kme.getMinor() == 1 ? this.statusMessage(msg, (byte)-18, (byte)45) : (kme.getMinor() == 2 ? this.statusMessage(msg, (byte)-18, (byte)41) : this.statusMessage(msg, (byte)-18, (byte)46));
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return respMessage;
                }
                if (this.debug.isOn("logic")) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "resp is");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", resp.getMessageHeader().getMessage());
                }
                pri = resp.getMessageHeader().getProxyRoutingInfo();
                ri = resp.getEncryptionSubPageWrapper().getRoutingInformation();
                medInfo = resp.getEncryptionSubPageWrapper().getMediumInformation();
                driveSSN = resp.getMessageHeader().getProxyRoutingInfo().getDriveSerialNumber();
                WWN = resp.getMessageHeader().getProxyRoutingInfo().getWWDN();
                payObj = resp.getEncryptionSubPageWrapper().getPayLoad();
                payloadType = resp.getEncryptionSubPageWrapper().getPagePayloadType();
                if (this.debug.isOn("logic")) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "DriveSerialNumber");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", driveSSN);
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "WWDN");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", WWN);
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "ProxyRoutingInfo");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", pri.getMessage());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "RoutingInformation");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", ri.getMessage());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "MediumInformation");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", medInfo.getMessage());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "PayLoad");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", payObj.toString());
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "PayLoadType");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", payloadType);
                }
                if (!(payObj instanceof EncryptionSubPageReqEEDKs)) ** GOTO lbl327
                esreedks = (EncryptionSubPageReqEEDKs)payObj;
                others = esreedks.getDKxEEDKUKI();
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Key Create request");
                if (payloadType[1] != -17) ** GOTO lbl669
                if (esreedks.getGenerateEEDK() != 0 || esreedks.getOldDK() != 0 || esreedks.getOldDKi() != 0) ** GOTO lbl324
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "payloadType is 0XEF");
                eedkuki = others.getEEDKUKIs();
                labels = new String[eedkuki.length];
                skiStrings = new String[eedkuki.length];
                skis = new byte[eedkuki.length][];
                edks /* !! */  = new byte[eedkuki.length][];
                pubs = new PublicKey[eedkuki.length];
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "labels", labels);
                dte = null;
                try {
                    dte = this.params.getDriveTable().fetchDriveEntry(driveSSN, null);
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                ks = this.params.getKeyStore();
                ksSKI = KeyStoreSKIFactory.newKeyStoreSKI((KeyStore)ks);
                aSKIDefX509 = SKIDefinitionFactory.newX509ExtensionSKIDefinition();
                aSKIDefSHA1 = SKIDefinitionFactory.newSHA1PublicKeySKIDefinition();
                for (i = 0; i < eedkuki.length; ++i) {
                    labels[i] = eedkuki[i].getUKI().getEncKeyLabel();
                    if (labels[i] == null) {
                        skis[i] = eedkuki[i].getUKI().getSubjectKeyId();
                        if (skis[i] == null) {
                            try {
                                if (i == 0) {
                                    labels[i] = (String)dte.getObject("AliasOne");
                                }
                                labels[i] = (String)dte.getObject("AliasTwo");
                            }
                            catch (KeyManagerException kme) {
                                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                                return this.statusMessage(msg, (byte)-18, (byte)15);
                            }
                        } else {
                            try {
                                skiStrings[i] = new String(skis[i], "8859_1");
                            }
                            catch (Exception e) {
                                skiStrings[i] = new String(skis[i]);
                            }
                            try {
                                labels[i] = ksSKI.getAlias(skiStrings[i], aSKIDefX509);
                                if (labels[i] == null) {
                                    labels[i] = ksSKI.getAlias(skiStrings[i], aSKIDefSHA1);
                                }
                            }
                            catch (KeyStoreException kse) {
                                labels[i] = null;
                                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kse.getMessage());
                                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                                return this.statusMessage(msg, (byte)-18, (byte)37);
                            }
                        }
                    }
                    if ((tmp = eedkuki[i].getUKI().getStructType())[0] == 25 && tmp[1] == 20) {
                        SKIstr = null;
                        try {
                            SKIstr = aSKIDefX509.getSubjectKeyIdentifier((X509Certificate)ks.getCertificate((String)labels[i]));
                            if (SKIstr == null) {
                                SKIstr = aSKIDefSHA1.getSubjectKeyIdentifier((X509Certificate)ks.getCertificate((String)labels[i]));
                            }
                        }
                        catch (KeyStoreException kse1) {
                            this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: Can not create/get SKI from certificate");
                            this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        }
                        if (SKIstr == null) {
                            this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: Can not create/get SKI from certificate");
                            this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                            return this.statusMessage(msg, (byte)-18, (byte)15);
                        }
                        try {
                            skis[i] = SKIstr.getBytes("8859_1");
                        }
                        catch (Exception e34) {
                            skis[i] = SKIstr.getBytes();
                        }
                    }
                    try {
                        cert = (X509Certificate)ks.getCertificate((String)labels[i]);
                        if (cert == null) {
                            if (this.debug.isOn("logic")) {
                                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage: Certificate for label = " + (String)labels[i] + ", not found");
                            }
                            return this.statusMessage(msg, (byte)-18, (byte)49);
                        }
                        pubs[i] = cert.getPublicKey();
                        continue;
                    }
                    catch (KeyStoreException kse) {
                        pubs[i] = null;
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kse.getMessage());
                        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        return this.statusMessage(msg, (byte)-18, (byte)49);
                    }
                }
                dk = null;
                keyType = 0;
                try {
                    dk = this.crypto.GenerateKey("AES");
                    keyType = 2;
                }
                catch (NoSuchAlgorithmException nsae) {
                    try {
                        dk = this.crypto.GenerateKey("DESede");
                    }
                    catch (Exception nsae1) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + nsae1.getMessage());
                        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        return this.statusMessage(msg, (byte)-18, (byte)15);
                    }
                    keyType = 1;
                }
                catch (Exception ex) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                try {
                    edks /* !! */  = this.crypto.EncryptKey(pubs, dk);
                }
                catch (Exception e) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + e.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                sedkKey = new RSAPublicKey[1];
                if (this.p1024 == null || this.p2048 == null) {
                    sedkKey[0] = this.p1024 == null ? this.p2048 : this.p1024;
                } else {
                    use1024 = true;
                    ksize = 0;
                    for (i = 0; i < eedkuki.length; ++i) {
                        ksize = (((RSAKey)pubs[i]).getModulus().toByteArray().length + 7) / 8;
                        if (ksize <= 128) continue;
                        use1024 = false;
                        break;
                    }
                    sedkKey[0] = use1024 != false ? this.p1024 : this.p2048;
                }
                sedk = null;
                try {
                    sedk = this.crypto.EncryptKey(sedkKey, dk);
                }
                catch (Exception ex) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                pubHash = null;
                try {
                    tmp = sedkKey[0].getEncoded();
                    pubHash = this.crypto.hash("SHA-1", tmp, 0, tmp.length);
                }
                catch (Exception e) {
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + e.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                try {
                    denResp = new DriveErrorNotify(pri, ri, medInfo, -32, (String[])labels, skis, edks /* !! */ , null, 0, null, keyType, sedk[0], pubHash, this.modeHdr, this.crypto);
                    if (!this.debug.isOn("logic")) ** GOTO lbl669
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", denResp.getMessage());
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)-31);
                }
lbl324:
                // 1 sources

                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "DK/EEDK flag issue");
                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                return this.statusMessage(msg, (byte)-18, (byte)-31);
lbl327:
                // 1 sources

                if (!(payObj instanceof EncryptionSubPageReqEEDKsQuery)) ** GOTO lbl400
                esreedksq = (EncryptionSubPageReqEEDKsQuery)payObj;
                eedkuki = esreedksq.getDKxEEDKUKI().getEEDKUKIs();
                dki = esreedksq.getDKxEEDKUKI().getDKX().getDKi();
                labels = new String[eedkuki.length];
                edks = new byte[eedkuki.length][];
                priv = new Key[eedkuki.length];
                skis = new byte[eedkuki.length][];
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Key Accquistion request");
                ks = this.params.getKeyStore();
                dk = null;
                keyType = eedkuki[1].getEEDK().getKeyType();
                for (i = 0; i < eedkuki.length; ++i) {
                    try {
                        if (eedkuki[i].getEEDK().getKey() == null) {
                            labels[i] = eedkuki[i].getEEDK().getEncKeyLabel();
                            skis[i] = eedkuki[i].getEEDK().getEncKeySKI();
                            priv[i] = ks.getKey(labels[i], this.params.getKSPassword());
                            edks[i] = eedkuki[i].getEEDK().getKeyData();
                            dk = keyType == 1 ? this.crypto.DecryptKey(edks[i], (PrivateKey)priv[i], "DESede") : this.crypto.DecryptKey(edks[i], (PrivateKey)priv[i], "AES");
                        } else {
                            edks[i] = eedkuki[i].getEEDK().getKeyData();
                            if (keyType == 1) {
                                keySpec = new SecretKeySpec(edks[i], "DESede");
                                dk = this.crypto.SecretKeyFactory("DESede", keySpec);
                            } else {
                                keySpec = new SecretKeySpec(edks[i], "AES");
                                dk = this.crypto.SecretKeyFactory("AES", keySpec);
                            }
                        }
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "unwrap eedk /sedk done");
                        continue;
                    }
                    catch (Exception ex) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        return this.statusMessage(msg, (byte)-18, (byte)15);
                    }
                }
                sedkKey = new RSAPublicKey[1];
                if (this.p1024 == null || this.p2048 == null) {
                    sedkKey[0] = this.p1024 == null ? this.p2048 : this.p1024;
                } else {
                    use1024 = true;
                    ksize = 0;
                    for (i = 0; i < eedkuki.length; ++i) {
                        ksize = (((RSAKey)priv[i]).getModulus().toByteArray().length + 7) / 8;
                        if (ksize <= 128) continue;
                        use1024 = false;
                        break;
                    }
                    sedkKey[0] = use1024 != false ? this.p1024 : this.p2048;
                }
                sedk = null;
                try {
                    sedk = this.crypto.EncryptKey(sedkKey, dk);
                }
                catch (Exception ex) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                pubHash = null;
                try {
                    tmp = sedkKey[0].getEncoded();
                    pubHash = this.crypto.hash("SHA-1", tmp, 0, tmp.length);
                }
                catch (Exception e) {
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + e.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                try {
                    denResp = new DriveErrorNotify(pri, ri, medInfo, -32, labels, skis, edks, null, 0, dki, keyType, sedk[0], pubHash, this.modeHdr, this.crypto);
                    if (!this.debug.isOn("logic")) ** GOTO lbl669
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "denResp");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", denResp.getMessage());
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)44);
                }
lbl400:
                // 1 sources

                if (!(payObj instanceof EncryptionSubPageTransEEDKs)) ** GOTO lbl666
                espt = (EncryptionSubPageTransEEDKs)payObj;
                eedkuki = espt.getTranslateDKxEEDKUKI().getEEDKUKIs();
                eedkukiOld = espt.getCurrentDKxEEDKUKI();
                labels = new String[eedkuki.length];
                skiStrings = new String[eedkuki.length];
                skis = new byte[eedkuki.length][];
                edks /* !! */  = new byte[eedkuki.length][];
                action = espt.getAction();
                pubs = new PublicKey[eedkuki.length];
                dk = null;
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Key Translate request");
                if (action != 0 && action != 1) ** GOTO lbl581
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "action is");
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", new byte[]{action});
                dte = null;
                try {
                    dte = this.params.getDriveTable().fetchDriveEntry(driveSSN, null);
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                ks = this.params.getKeyStore();
                ksSKI = KeyStoreSKIFactory.newKeyStoreSKI((KeyStore)ks);
                aSKIDefX509 = SKIDefinitionFactory.newX509ExtensionSKIDefinition();
                aSKIDefSHA1 = SKIDefinitionFactory.newSHA1PublicKeySKIDefinition();
                for (i = 0; i < eedkuki.length; ++i) {
                    labels[i] = eedkuki[i].getUKI().getEncKeyLabel();
                    if (labels[i] == null) {
                        skis[i] = eedkuki[i].getUKI().getSubjectKeyId();
                        if (skis[i] == null) {
                            try {
                                if (i == 0) {
                                    labels[i] = (String)dte.getObject("AliasOne");
                                }
                                labels[i] = (String)dte.getObject("AliasTwo");
                            }
                            catch (KeyManagerException kme) {
                                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                                return this.statusMessage(msg, (byte)-18, (byte)15);
                            }
                        } else {
                            try {
                                skiStrings[i] = new String(skis[i], "8859_1");
                            }
                            catch (Exception e) {
                                skiStrings[i] = new String(skis[i]);
                            }
                            try {
                                labels[i] = ksSKI.getAlias(skiStrings[i], aSKIDefX509);
                                if (labels[i] == null) {
                                    labels[i] = ksSKI.getAlias(skiStrings[i], aSKIDefSHA1);
                                }
                            }
                            catch (KeyStoreException kse) {
                                labels[i] = null;
                                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kse.getMessage());
                                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                                return this.statusMessage(msg, (byte)-18, (byte)37);
                            }
                        }
                    }
                    if ((tmp = eedkuki[i].getUKI().getStructType())[0] == 25 && tmp[1] == 20) {
                        SKIstr = null;
                        try {
                            SKIstr = aSKIDefX509.getSubjectKeyIdentifier((X509Certificate)ks.getCertificate(labels[i]));
                            if (SKIstr == null) {
                                SKIstr = aSKIDefSHA1.getSubjectKeyIdentifier((X509Certificate)ks.getCertificate(labels[i]));
                            }
                        }
                        catch (KeyStoreException kse1) {
                            this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: Can not create/get SKI from certificate");
                            this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        }
                        if (SKIstr == null) {
                            this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: Can not create/get SKI from certificate");
                            this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                            return this.statusMessage(msg, (byte)-18, (byte)15);
                        }
                        try {
                            skis[i] = SKIstr.getBytes("8859_1");
                        }
                        catch (Exception e34) {
                            skis[i] = SKIstr.getBytes();
                        }
                    }
                    try {
                        cert = (X509Certificate)ks.getCertificate(labels[i]);
                        if (cert == null) {
                            if (this.debug.isOn("logic")) {
                                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage: Certificate for label = " + labels[i] + ", not found");
                            }
                            return this.statusMessage(msg, (byte)-18, (byte)49);
                        }
                        pubs[i] = cert.getPublicKey();
                        continue;
                    }
                    catch (KeyStoreException kse) {
                        pubs[i] = null;
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kse.getMessage());
                        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        return this.statusMessage(msg, (byte)-18, (byte)49);
                    }
                }
                old = eedkukiOld.getEEDKUKIs();
                ksref = null;
                for (i = 0; i < old.length; ++i) {
                    priv = null;
                    ksref = old[i].getEEDK().getEncKeyLabel();
                    if (ksref != null) ** GOTO lbl514
                    tmp = old[i].getEEDK().getEncKeySKI();
                    if (tmp != null) {
                        try {
                            ksref = new String(tmp, "8859_1");
                        }
                        catch (Exception e) {
                            ksref = new String(tmp);
                        }
                    } else {
                        dk = old[i].getEEDK().getKey();
                        break;
                    }
                    try {
                        priv = ksSKI.getPrivateKey(ksref, aSKIDefX509, this.params.getKSPassword());
                        if (priv == null) {
                            priv = ksSKI.getPrivateKey(ksref, aSKIDefSHA1, this.params.getKSPassword());
                        }
                        ** GOTO lbl519
                    }
                    catch (Exception ep1) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ep1.getMessage());
                    }
                    ** GOTO lbl519
lbl514:
                    // 1 sources

                    try {
                        priv = (PrivateKey)ks.getKey(ksref, this.params.getKSPassword());
                    }
                    catch (Exception ek) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ek.getMessage());
                    }
lbl519:
                    // 5 sources

                    if (priv == null) continue;
                    try {
                        if (old[i].getEEDK().getKeyType() == 1) {
                            dk = this.crypto.DecryptKey(old[i].getEEDK().getKeyData(), priv, "DESede");
                            break;
                        }
                        dk = this.crypto.DecryptKey(old[i].getEEDK().getKeyData(), priv, "AES");
                        break;
                    }
                    catch (Exception ex) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        return this.statusMessage(msg, (byte)-18, (byte)15);
                    }
                }
                if (dk == null) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Unable to get keydata.");
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)43);
                }
                try {
                    edks /* !! */  = this.crypto.EncryptKey(pubs, dk);
                }
                catch (Exception ex) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                sedkKey = new RSAPublicKey[1];
                if (this.p1024 == null || this.p2048 == null) {
                    sedkKey[0] = this.p1024 == null ? this.p2048 : this.p1024;
                } else {
                    use1024 = true;
                    ksize = 0;
                    for (i = 0; i < eedkuki.length; ++i) {
                        ksize = (((RSAKey)pubs[i]).getModulus().toByteArray().length + 7) / 8;
                        if (ksize <= 128) continue;
                        use1024 = false;
                        break;
                    }
                    sedkKey[0] = use1024 != false ? this.p1024 : this.p2048;
                }
                sedk = null;
                try {
                    sedk = this.crypto.EncryptKey(sedkKey, dk);
                }
                catch (Exception ex) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                pubHash = null;
                try {
                    tmp = sedkKey[0].getEncoded();
                    pubHash = this.crypto.hash("SHA-1", tmp, 0, tmp.length);
                }
                catch (Exception e) {
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + e.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "keys unwrapped and sedk set");
                try {
                    denResp = new DriveErrorNotify(pri, ri, medInfo, -31, labels, skis, edks /* !! */ , eedkukiOld, action, null, old[0].getEEDK().getKeyType(), sedk[0], pubHash, this.modeHdr, this.crypto);
                    if (!this.debug.isOn("logic")) ** GOTO lbl669
                    this.debug.trace("logic", MessageProcessor.className, "MessageProcessor", "response");
                    this.debug.trace("logic", MessageProcessor.className, "MessageProcessor", denResp.getMessage());
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)-31);
                }
lbl581:
                // 1 sources

                if (action != 2 && action != 3) ** GOTO lbl664
                if (this.debug.isOn("logic")) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "action is");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", new byte[]{action});
                }
                ks = this.params.getKeyStore();
                ksSKI = KeyStoreSKIFactory.newKeyStoreSKI((KeyStore)ks);
                aSKIDefX509 = SKIDefinitionFactory.newX509ExtensionSKIDefinition();
                aSKIDefSHA1 = SKIDefinitionFactory.newSHA1PublicKeySKIDefinition();
                old = eedkukiOld.getEEDKUKIs();
                ksref = null;
                for (i = 0; i < old.length; ++i) {
                    priv = null;
                    ksref = old[i].getEEDK().getEncKeyLabel();
                    if (ksref != null) ** GOTO lbl614
                    tmp = old[i].getEEDK().getEncKeySKI();
                    if (tmp != null) {
                        try {
                            ksref = new String(tmp, "8859_1");
                        }
                        catch (Exception e) {
                            ksref = new String(tmp);
                        }
                    } else {
                        dk = old[i].getEEDK().getKey();
                        break;
                    }
                    try {
                        priv = ksSKI.getPrivateKey(ksref, aSKIDefX509, this.params.getKSPassword());
                        if (priv == null) {
                            priv = ksSKI.getPrivateKey(ksref, aSKIDefSHA1, this.params.getKSPassword());
                        }
                        ** GOTO lbl619
                    }
                    catch (Exception ep1) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ep1.getMessage());
                    }
                    ** GOTO lbl619
lbl614:
                    // 1 sources

                    try {
                        priv = (PrivateKey)ks.getKey(ksref, this.params.getKSPassword());
                    }
                    catch (Exception ek) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ek.getMessage());
                    }
lbl619:
                    // 5 sources

                    if (priv == null) continue;
                    try {
                        if (old[i].getEEDK().getKeyType() == 1) {
                            dk = this.crypto.DecryptKey(old[i].getEEDK().getKeyData(), priv, "DESede");
                            break;
                        }
                        dk = this.crypto.DecryptKey(old[i].getEEDK().getKeyData(), priv, "AES");
                        break;
                    }
                    catch (Exception ex) {
                        this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                        return this.statusMessage(msg, (byte)-18, (byte)15);
                    }
                }
                if (dk == null) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Unable to get keydata.");
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)43);
                }
                sedkKey = new RSAPublicKey[1];
                sedkKey[0] = this.p1024 == null || this.p2048 == null ? (this.p1024 == null ? this.p2048 : this.p1024) : (old[0].getEEDK().getKeyType() == 1 ? this.p1024 : this.p2048);
                sedk = null;
                try {
                    sedk = this.crypto.EncryptKey(sedkKey, dk);
                }
                catch (Exception ex) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + ex.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                pubHash = null;
                try {
                    tmp = sedkKey[0].getEncoded();
                    pubHash = this.crypto.hash("SHA-1", tmp, 0, tmp.length);
                }
                catch (Exception e) {
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + e.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)15);
                }
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "keys unwrapped and sedk done");
                try {
                    denResp = new DriveErrorNotify(pri, ri, medInfo, -31, null, null, null, eedkukiOld, action, null, old[0].getEEDK().getKeyType(), sedk[0], pubHash, this.modeHdr, this.crypto);
                    if (!this.debug.isOn("logic")) ** GOTO lbl669
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "response");
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", denResp.getMessage());
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return this.statusMessage(msg, (byte)-18, (byte)-32);
                }
lbl664:
                // 1 sources

                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage", "Action value incorrect action = " + action);
                return this.statusMessage(msg, (byte)-18, (byte)-31);
lbl666:
                // 1 sources

                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Unknown Payload Object");
                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                return this.statusMessage(msg, (byte)-18, (byte)44);
lbl669:
                // 9 sources

                this.msgType = this.ENC_SUBPAGE_STATUS;
                respMessage = denResp.getMessage();
                break;
            }
            case 254: {
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "type is 0XFE");
                espsw = null;
                espswResp = null;
                try {
                    espsw = new EncSubPageStatusWrapper(msg, this.crypto);
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    respMessage = kme.getMinor() == 1 ? this.statusMessage(msg, (byte)-18, (byte)45) : (kme.getMinor() == 2 ? this.statusMessage(msg, (byte)-18, (byte)41) : this.statusMessage(msg, (byte)-18, (byte)46));
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return respMessage;
                }
                try {
                    espswResp = new EncSubPageStatusWrapper(this.priOrig, this.riOrig, this.medInfoOrig, -2, ((EncryptionSubPage)espsw.getEncryptionSubPageWrapper().getPayLoad()).getResponseCode(), ((EncryptionSubPage)espsw.getEncryptionSubPageWrapper().getPayLoad()).getSenseKey(), ((EncryptionSubPage)espsw.getEncryptionSubPageWrapper().getPayLoad()).getAdditionalSenseCode(), ((EncryptionSubPage)espsw.getEncryptionSubPageWrapper().getPayLoad()).getAdditionalSenseCodeQualifier(), this.crypto);
                }
                catch (KeyManagerException kme) {
                    this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Exception: " + kme.getMessage());
                    respMessage = this.statusMessage(msg, (byte)-18, (byte)46);
                    this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                    return respMessage;
                }
                this.medInfoOrig = null;
                this.priOrig = null;
                this.riOrig = null;
                this.msgType = this.DRIVE_ERROR_NOTIFY;
                respMessage = espswResp.getMessage();
                if (!this.debug.isOn("logic")) break;
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "response");
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", respMessage);
                break;
            }
            default: {
                this.debug.trace("logic", MessageProcessor.className, "ProcessMessage", "Unknown message type");
                this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
                return this.statusMessage(msg, (byte)-18, (byte)15);
            }
        }
        this.debug.exit("logic", MessageProcessor.className, "ProcessMessage");
        return respMessage;
    }

    byte[] statusMessage(byte[] msg, byte asc, byte ascq) {
        MediumInfo medInfo = this.medInfoOrig;
        ProxyRoutingInfo pri = this.priOrig;
        RoutingInfo ri = this.riOrig;
        byte senseKey = 5;
        this.medInfoOrig = null;
        this.priOrig = null;
        this.riOrig = null;
        this.msgType = this.DRIVE_ERROR_NOTIFY;
        if (medInfo == null || pri == null || ri == null) {
            try {
                MsgHeader header = new MsgHeader(msg);
                pri = header.getProxyRoutingInfo();
                int pos = header.getHeaderLen();
                if (msg[pos] == 33 & msg[pos + 1] == 0) {
                    pos += 12;
                }
                if (msg[pos] == 33 & msg[pos + 1] == 254) {
                    pos += 4;
                }
                if (msg[pos] == 32 & msg[pos + 1] == 32) {
                    pos += 32;
                }
                ri = new RoutingInfo(msg, pos += 12);
                medInfo = new MediumInfo(msg, pos += ri.getMsgLen());
            }
            catch (Exception e) {
                this.debug.trace("logic", className, "statusMessage", "Exception: " + e.getMessage());
                this.debug.exit("logic", className, "statusMessage", "Could not create status message to send.");
                return null;
            }
        }
        if (ascq == 45) {
            try {
                EncSubPageStatusWrapper espsw = new EncSubPageStatusWrapper(msg, this.crypto);
                senseKey = ((EncryptionSubPage)espsw.getEncryptionSubPageWrapper().getPayLoad()).getSenseKey();
                asc = ((EncryptionSubPage)espsw.getEncryptionSubPageWrapper().getPayLoad()).getAdditionalSenseCode();
                ascq = ((EncryptionSubPage)espsw.getEncryptionSubPageWrapper().getPayLoad()).getAdditionalSenseCodeQualifier();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        EncSubPageStatusWrapper espswResp = null;
        try {
            espswResp = new EncSubPageStatusWrapper(pri, ri, medInfo, -2, 112, senseKey, asc, ascq, this.crypto);
        }
        catch (KeyManagerException e) {
            this.debug.trace("logic", className, "statusMessage", "Exception: " + e.getMessage());
            this.debug.exit("logic", className, "statusMessage", "Could not create status message to send.");
            return null;
        }
        return espswResp.getMessage();
    }

    void shutdown() {
        this.debug.entry("logic", className, "shutdown");
        try {
            this.notify();
        }
        catch (Exception e) {
        }
        catch (Error error) {
            // empty catch block
        }
        this.run = false;
        this.debug.exit("logic", className, "shutdown");
    }
}

