/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.PrivateKey;

public class MESData {
    public static final int NO_SIG = 0;
    public static final int RSA_SIG = 1;
    public static final int RSASHA1_SIG = 2;
    public static final int DESEDE_KEY = 1;
    public static final int AES_KEY = 2;
    private static final byte SEQ_TAG = 48;
    private static final byte OID_TAG = 6;
    private static final byte INT_TAG = 2;
    private static final byte OCTSTRING_TAG = 4;
    private static final byte IA5STRING_TAG = 22;
    private static final int[] RSA_SIGNATURE_data = new int[]{1, 3, 14, 3, 2, 11};
    private static final int[] TRIPLE_DES_data = new int[]{1, 3, 6, 1, 4, 1, 4929, 1, 6};
    private static final int[] AES_data = new int[]{2, 16, 840, 1, 101, 3, 4, 1};
    private static final int[] SHA1_data = new int[]{1, 3, 14, 3, 2, 26};
    private static final int[] SHA1_WITH_RSA_SIGNATURE_data = new int[]{1, 3, 14, 3, 2, 29};
    private static ObjectIdentifier SHA1_WITH_RSA_SIGNATURE_OID;
    private static ObjectIdentifier RSA_SIGNATURE_OID;
    private static ObjectIdentifier SHA1_OID;
    private static ObjectIdentifier AES_ENCRYPTION_OID;
    private static ObjectIdentifier DES3_ENCRYPTION_OID;
    private static final String className = "com.ibm.keymanager.logic.MESData";
    private static KMSDebug debug;
    private byte[] mesSigAlgID;
    private byte[] mesSignature;
    private int TbsMesInfoVersion = 0;
    private byte[] kekAlgID;
    private byte[] DKAlgID;
    private byte[] EEDK;
    private byte KEKIDPublicDigest = (byte)-96;
    private byte[] digestData;
    private byte KEKIDLabel = (byte)-94;
    private String KEKLabel;
    private int encAlgo;
    private int sigAlgo;
    private boolean isDigest;
    private boolean noSig;
    private PrivateKey SignatureKey;

    public MESData(byte[] msg, int offset, int len) throws KeyManagerException {
        if (msg == null) {
            throw new KeyManagerException(2, 7, "NULL Input values not accepted");
        }
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData Constructor");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " MESData Constructor");
        }
        this.decode(msg, offset, len);
    }

    public MESData(byte[] DK, int encryptionAlgorithm, int signatureAlgorithm, PrivateKey sigKey, byte[] kekDigest) throws KeyManagerException {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData Constructor");
        }
        if (DK == null || kekDigest == null) {
            throw new KeyManagerException(2, 7, "NULL Input values not accepted");
        }
        if (signatureAlgorithm == 0) {
            this.noSig = true;
        } else if (sigKey == null) {
            throw new KeyManagerException(2, 7, "NULL signature Key");
        }
        this.SignatureKey = sigKey;
        try {
            this.EEDK = new byte[DK.length];
            System.arraycopy(DK, 0, this.EEDK, 0, DK.length);
            this.digestData = new byte[kekDigest.length];
            System.arraycopy(kekDigest, 0, this.digestData, 0, kekDigest.length);
        }
        catch (Exception exc) {
            throw new KeyManagerException(2, 99, exc.getMessage());
        }
        if (encryptionAlgorithm != 1 && encryptionAlgorithm != 2) {
            throw new KeyManagerException(2, 5, "Encryption Algorithm not supported");
        }
        this.encAlgo = encryptionAlgorithm;
        if (signatureAlgorithm > 2) {
            throw new KeyManagerException(2, 5, "Signature Algorithm not supported");
        }
        this.sigAlgo = signatureAlgorithm;
        this.isDigest = true;
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " MESData Constructor");
        }
    }

    public MESData(byte[] DK, int encryptionAlgorithm, int signatureAlgorithm, PrivateKey sigKey, String kekLabel) throws KeyManagerException {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData Constructor");
        }
        if (DK == null || kekLabel == null) {
            throw new KeyManagerException(2, 7, "NULL Input values not accepted");
        }
        if (signatureAlgorithm == 0) {
            this.noSig = true;
        } else if (sigKey == null) {
            throw new KeyManagerException(2, 7, "NULL signature Key");
        }
        this.SignatureKey = sigKey;
        try {
            this.EEDK = new byte[DK.length];
            System.arraycopy(DK, 0, this.EEDK, 0, DK.length);
            this.KEKLabel = kekLabel;
        }
        catch (Exception exc) {
            throw new KeyManagerException(2, 99, exc.getMessage());
        }
        if (encryptionAlgorithm != 1 && encryptionAlgorithm != 2) {
            throw new KeyManagerException(2, 5, "Encryption Algorithm not supported");
        }
        this.encAlgo = encryptionAlgorithm;
        if (signatureAlgorithm > 2) {
            throw new KeyManagerException(2, 5, "Signature Algorithm not supported");
        }
        this.sigAlgo = signatureAlgorithm;
        this.isDigest = false;
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " MESData Constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decode(byte[] msg, int offset, int len) throws KeyManagerException {
        byte algoParams2;
        byte algoParams1;
        ObjectIdentifier tempOID;
        DerInputStream buff;
        byte tag;
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData decode()");
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(msg, offset, len);
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "MESData decode", "decoding MES");
        }
        if ((tag = (byte)bis.read()) != 48) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        byte bLen = (byte)bis.read();
        int tmpLen = MESData.getSeqLength(bLen, bis);
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "MESData decode", "decoding MES TBS Info");
        }
        if ((tag = (byte)bis.read()) != -96) {
            throw new KeyManagerException(2, 9, "Sequence 0xA0");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 48) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "MESData decode", "decoding MES TBS Info");
        }
        if ((tag = (byte)bis.read()) != -96) {
            throw new KeyManagerException(2, 9, "Sequence 0xA0");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 2) {
            throw new KeyManagerException(2, 8, "Bad MES Info Version type");
        }
        byte trash = (byte)bis.read();
        byte tmpTBSVer = (byte)bis.read();
        if ((tmpTBSVer & 0xFF) != this.TbsMesInfoVersion) {
            throw new KeyManagerException(2, 8, "Bad MES Info Version number");
        }
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "MESData decode", "decoding MES Key Info Choice");
        }
        if ((tag = (byte)bis.read()) != -95) {
            throw new KeyManagerException(2, 9, "Sequence 0xA1");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != -96) {
            throw new KeyManagerException(2, 9, "Sequence 0xA0");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 48) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != -96) {
            throw new KeyManagerException(2, 9, "Sequence 0xA0");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 2) {
            throw new KeyManagerException(2, 8, "Bad MES Info Version type");
        }
        trash = (byte)bis.read();
        tmpTBSVer = (byte)bis.read();
        if ((tmpTBSVer & 0xFF) != this.TbsMesInfoVersion) {
            throw new KeyManagerException(2, 8, "Bad MES Info Version number");
        }
        tag = (byte)bis.read();
        if (tag != -95) {
            throw new KeyManagerException(2, 9, "Sequence 0xA1");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        if (tag == this.KEKIDPublicDigest) {
            tag = (byte)bis.read();
            if (tag != 48) {
                throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
            }
            bLen = (byte)bis.read();
            tmpLen = MESData.getSeqLength(bLen, bis);
            tag = (byte)bis.read();
            if (tag != -96) {
                throw new KeyManagerException(2, 9, "Sequence 0xA0");
            }
            bLen = (byte)bis.read();
            tmpLen = MESData.getSeqLength(bLen, bis);
            tag = (byte)bis.read();
            if (tag != 6) {
                throw new KeyManagerException(2, 9, "Bad KEK Alg OID Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = bLen & 0xFF;
            this.kekAlgID = new byte[tmpLen + 2];
            this.kekAlgID[0] = tag;
            this.kekAlgID[1] = (byte)tmpLen;
            bis.read(this.kekAlgID, 2, tmpLen);
            buff = new DerInputStream(this.kekAlgID);
            try {
                tempOID = new ObjectIdentifier(buff);
            }
            catch (Exception exc) {
                throw new KeyManagerException(2, 9, "Bad KEK Alg OID Value");
            }
            if (!tempOID.equals(SHA1_OID)) throw new KeyManagerException(2, 10, "Bad Digest Info");
            algoParams1 = (byte)bis.read();
            algoParams2 = (byte)bis.read();
            tag = (byte)bis.read();
            if (tag != -95) {
                throw new KeyManagerException(2, 9, "Sequence 0xA1");
            }
            bLen = (byte)bis.read();
            tmpLen = MESData.getSeqLength(bLen, bis);
            tag = (byte)bis.read();
            if (tag != 4) {
                throw new KeyManagerException(2, 9, "Bad Digest Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = MESData.getSeqLength(bLen, bis);
            if (tmpLen == 0) {
                this.digestData = new byte[bLen & 0xFF];
                bis.read(this.digestData, 0, bLen & 0xFF);
            } else {
                this.digestData = new byte[tmpLen];
                bis.read(this.digestData, 0, tmpLen);
            }
            this.isDigest = true;
        } else {
            if (tag != this.KEKIDLabel) throw new KeyManagerException(2, 12, "Bad KEK Indentifier choice");
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData decode", "decoding kek Label");
            }
            if ((tag = (byte)bis.read()) != 22) {
                throw new KeyManagerException(2, 11, "Bad IA5String Label Encoding");
            }
            bLen = (byte)bis.read();
            tmpLen = bLen & 0xFF;
            StringBuffer s = new StringBuffer(tmpLen);
            try {
                int temp = tmpLen;
                while (temp-- > 0) {
                    s.append((char)bis.read());
                }
                this.KEKLabel = new String(s);
            }
            catch (Exception e) {
                throw new KeyManagerException(2, 11, "Bad IA5String Label");
            }
        }
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "MESData decode", "decoding KEK Algo ID");
        }
        if ((tag = (byte)bis.read()) != -94) {
            throw new KeyManagerException(2, 9, "Sequence 0xA2");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 48) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != -96) {
            throw new KeyManagerException(2, 9, "Sequence 0xA0");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 6) {
            throw new KeyManagerException(2, 12, "Bad KEK Alg OID Tag");
        }
        bLen = (byte)bis.read();
        tmpLen = bLen & 0xFF;
        this.DKAlgID = new byte[tmpLen + 2];
        this.DKAlgID[0] = tag;
        this.DKAlgID[1] = (byte)tmpLen;
        bis.read(this.DKAlgID, 2, tmpLen);
        buff = new DerInputStream(this.DKAlgID);
        try {
            tempOID = new ObjectIdentifier(buff);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            throw new KeyManagerException(2, 13, "Bad EEDK AlgID OID Value");
        }
        if (!tempOID.equals(AES_ENCRYPTION_OID) && !tempOID.equals(DES3_ENCRYPTION_OID)) throw new KeyManagerException(2, 13, "Bad EEDK Encryption algo");
        tag = (byte)bis.read();
        if (tag != -95) {
            throw new KeyManagerException(2, 9, "Sequence 0xA1");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        algoParams1 = (byte)bis.read();
        algoParams2 = (byte)bis.read();
        tag = (byte)bis.read();
        this.encAlgo = tempOID.equals(AES_ENCRYPTION_OID) ? 2 : 1;
        if (debug.isOn("logic")) {
            debug.trace("logic", className, "MESData decode", "decoding EEDK");
        }
        if (tag != -93) {
            throw new KeyManagerException(2, 9, "Sequence 0xA3");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        tag = (byte)bis.read();
        if (tag != 4) {
            throw new KeyManagerException(2, 13, "Bad EEDK Tag");
        }
        bLen = (byte)bis.read();
        tmpLen = MESData.getSeqLength(bLen, bis);
        if (tmpLen == 0) {
            this.EEDK = new byte[bLen & 0xFF];
            bis.read(this.EEDK, 0, bLen & 0xFF);
        } else {
            this.EEDK = new byte[tmpLen];
            bis.read(this.EEDK, 0, tmpLen);
        }
        if (bis.available() != 0) {
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData decode", "decoding MES SIG Algo ID");
            }
            if ((tag = (byte)bis.read()) != 48) {
                throw new KeyManagerException(2, 8, "Bad MES Signature Algorithm Encoding");
            }
            bLen = (byte)bis.read();
            tmpLen = MESData.getSeqLength(bLen, bis);
            if (tag != 6) {
                throw new KeyManagerException(2, 8, "Bad MES Signature Algo OID Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = bLen & 0xFF;
            this.mesSigAlgID = new byte[tmpLen + 2];
            this.mesSigAlgID[0] = tag;
            this.mesSigAlgID[1] = (byte)tmpLen;
            bis.read(this.mesSigAlgID, 2, tmpLen);
            buff = new DerInputStream(this.mesSigAlgID);
            try {
                tempOID = new ObjectIdentifier(buff);
            }
            catch (Exception exc) {
                throw new KeyManagerException(2, 8, "Bad MES Signature AlgID OID Value");
            }
            if (tempOID != SHA1_WITH_RSA_SIGNATURE_OID && tempOID != RSA_SIGNATURE_OID) throw new KeyManagerException(2, 13, "Bad EEDK Encryption algo");
            algoParams1 = (byte)bis.read();
            algoParams2 = (byte)bis.read();
            tag = (byte)bis.read();
            this.sigAlgo = tempOID == SHA1_WITH_RSA_SIGNATURE_OID ? 1 : 2;
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData decode", "decoding SIGNATURE");
            }
            if (tag != 4) {
                throw new KeyManagerException(2, 2, "Bad Signature Tag");
            }
            bLen = (byte)bis.read();
            tmpLen = MESData.getSeqLength(bLen, bis);
            if (tmpLen == 0) {
                this.mesSignature = new byte[bLen & 0xFF];
                bis.read(this.mesSignature, 0, bLen & 0xFF);
            } else {
                this.mesSignature = new byte[tmpLen];
                bis.read(this.mesSignature, 0, tmpLen);
            }
        } else {
            this.sigAlgo = 0;
            this.noSig = true;
        }
        if (!debug.isOn("logic")) return;
        debug.exit("logic", className, " MESData decode()");
    }

    public int getEncAlgo() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getEncAlgo");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getEncAlgo");
        }
        return this.encAlgo;
    }

    public int getSigAlgo() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK getSigAlgo");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK getSigAlgo");
        }
        return this.sigAlgo;
    }

    public byte[] getSig() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " EEDK getSig");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "EEDK getSig");
        }
        return this.mesSignature;
    }

    public String getSubjectKeyLabel() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData getSubjectKeyLabel");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " MESData getSubjectKeyLabel");
        }
        return this.KEKLabel;
    }

    public byte[] getSubjectKeyId() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData getSubjectKeyId");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " MESData getSubjectKeyId");
        }
        return this.digestData;
    }

    public byte[] getEEDKey() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData getEEDKey");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, " MESData getEEDKey");
        }
        return this.EEDK;
    }

    public boolean isDigest() {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " SEDK isDigest");
        }
        if (debug.isOn("logic")) {
            debug.exit("logic", className, "SEDK isDigest");
        }
        return this.isDigest;
    }

    public byte[] encode() throws KeyManagerException {
        if (debug.isOn("logic")) {
            debug.entry("logic", className, " MESData encode");
        }
        try {
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData encode", "encoding MesKeyInfo");
            }
            DerOutputStream mesKeyInfoBytes = new DerOutputStream();
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData encode", "encoding EEDK Info");
            }
            DerOutputStream eedkDER = new DerOutputStream();
            DerOutputStream bytes = new DerOutputStream();
            DerOutputStream verDER = new DerOutputStream();
            verDER.putInteger(0);
            bytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), verDER);
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData encode", "encoding KEK ID");
            }
            DerOutputStream kekIDDER = new DerOutputStream();
            if (this.isDigest) {
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "MESData encode", "encoding digest");
                }
                DerOutputStream bytes3 = new DerOutputStream();
                DerOutputStream kekPublicDigestDER = new DerOutputStream();
                kekPublicDigestDER.putOID(SHA1_OID);
                kekPublicDigestDER.putNull();
                bytes3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-96), kekPublicDigestDER);
                kekPublicDigestDER = new DerOutputStream();
                kekPublicDigestDER.putOctetString(this.digestData);
                bytes3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-95), kekPublicDigestDER);
                DerOutputStream digestInfo = new DerOutputStream();
                digestInfo.write((byte)48, bytes3);
                kekIDDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-96), digestInfo);
            } else {
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "MESData encode", "encoding keklabel");
                }
                DerOutputStream kekLabelDER = new DerOutputStream();
                kekLabelDER.putIA5String(this.KEKLabel);
                kekIDDER.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-94), kekLabelDER);
            }
            bytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), kekIDDER);
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData encode", "encoding Algorithm ID");
            }
            DerOutputStream bytes2 = new DerOutputStream();
            DerOutputStream eekAlgDer = new DerOutputStream();
            if (this.encAlgo == 2) {
                eekAlgDer.putOID(AES_ENCRYPTION_OID);
            } else {
                eekAlgDer.putOID(DES3_ENCRYPTION_OID);
            }
            bytes2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), eekAlgDer);
            eekAlgDer = new DerOutputStream();
            eekAlgDer.putNull();
            bytes2.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), eekAlgDer);
            eekAlgDer = new DerOutputStream();
            eekAlgDer.write((byte)48, bytes2);
            bytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), eekAlgDer);
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData encode", "encoding EEDK");
            }
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "EEDK encode", "encoding eedk");
            }
            DerOutputStream eekDKDer = new DerOutputStream();
            eekDKDer.putOctetString(this.EEDK);
            bytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)3), eekDKDer);
            eedkDER.write((byte)48, bytes);
            mesKeyInfoBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)-96), eedkDER);
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData encode", "encoding TBSMes Info");
            }
            DerOutputStream mesInfoDER = new DerOutputStream();
            DerOutputStream mesBytes = new DerOutputStream();
            DerOutputStream verDER1 = new DerOutputStream();
            verDER1.putInteger(0);
            mesBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), verDER1);
            mesBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), mesKeyInfoBytes);
            mesInfoDER.write((byte)48, mesBytes);
            if (debug.isOn("logic")) {
                debug.trace("logic", className, "MESData encode", "encoding MESSigAlgo");
            }
            DerOutputStream mesSigDer = null;
            DerOutputStream mesSigAlgIDDer = null;
            if (!this.noSig) {
                DerOutputStream bytes3 = new DerOutputStream();
                mesSigAlgIDDer = new DerOutputStream();
                if (this.sigAlgo == 1) {
                    mesSigAlgIDDer.putOID(RSA_SIGNATURE_OID);
                } else {
                    mesSigAlgIDDer.putOID(SHA1_WITH_RSA_SIGNATURE_OID);
                }
                bytes3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), mesSigAlgIDDer);
                mesSigAlgIDDer = new DerOutputStream();
                mesSigAlgIDDer.putNull();
                bytes3.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), mesSigAlgIDDer);
                mesSigAlgIDDer = new DerOutputStream();
                mesSigAlgIDDer.write((byte)48, bytes3);
                if (debug.isOn("logic")) {
                    debug.trace("logic", className, "MESData encode", "encoding signature");
                }
                mesSigDer = new DerOutputStream();
                mesSigDer.write(this.mesSignature);
            }
            DerOutputStream mesDataDER = new DerOutputStream();
            DerOutputStream mesDataBytes = new DerOutputStream();
            mesDataBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)0), mesInfoDER);
            if (!this.noSig) {
                mesDataBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)1), mesSigAlgIDDer);
                mesDataBytes.write(DerValue.createTag((byte)-128, (boolean)true, (byte)2), mesSigDer);
            }
            mesDataDER.write((byte)48, mesDataBytes);
            if (debug.isOn("logic")) {
                debug.exit("logic", className, " MESData encode");
            }
            return mesDataDER.toByteArray();
        }
        catch (Exception exc) {
            throw new KeyManagerException(2, 99, exc.getMessage());
        }
    }

    static int getSeqLength(byte lenByte, InputStream in) throws KeyManagerException {
        int value;
        int tmp = lenByte & 0xFF;
        if ((tmp & 0x80) == 0) {
            return 0;
        }
        if ((tmp &= 0x7F) < 0 || tmp > 4) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        try {
            value = 0;
            while (tmp > 0) {
                value <<= 8;
                value += 0xFF & in.read();
                --tmp;
            }
        }
        catch (Exception exc) {
            throw new KeyManagerException(2, 8, "Bad MES Data Encoding");
        }
        return value;
    }

    static {
        try {
            SHA1_WITH_RSA_SIGNATURE_OID = new ObjectIdentifier(SHA1_WITH_RSA_SIGNATURE_data);
            RSA_SIGNATURE_OID = new ObjectIdentifier(RSA_SIGNATURE_data);
            SHA1_OID = new ObjectIdentifier(SHA1_data);
            AES_ENCRYPTION_OID = new ObjectIdentifier(AES_data);
            DES3_ENCRYPTION_OID = new ObjectIdentifier(TRIPLE_DES_data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        debug = KMSDebug.getInstance();
    }
}

