/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.DKxEEDKUKI;
import com.ibm.keymanager.logic.SEDK;
import java.math.BigInteger;

class EncryptionSubPageSetupEEDKs {
    byte keyscope;
    byte medium;
    byte oldDKi;
    byte parameters;
    byte[] origMsg;
    BigInteger sedkCnt;
    BigInteger msglen;
    SEDK sedk;
    DKxEEDKUKI eedks;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionSubPageSetupEEDKs.class";

    EncryptionSubPageSetupEEDKs(String[] labels, byte[][] skis, byte[][] edks, byte[] dki, int keyType, byte[] sedk, byte[] publicKeyHash) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageSetupEEDKs-Create");
        this.oldDKi = 0;
        this.medium = 0;
        this.keyscope = 0;
        this.parameters = (byte)(this.oldDKi << 7 | this.medium << 6 | this.keyscope);
        this.sedkCnt = new BigInteger("1");
        this.sedk = new SEDK(sedk, 2, 0, null, publicKeyHash, dki);
        byte[] bsedk = this.sedk.encode();
        this.eedks = new DKxEEDKUKI(labels, skis, edks, dki, keyType);
        int len = 4 + bsedk.length + this.eedks.getMsgLen();
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[len];
        int pos = 0;
        this.origMsg[pos] = this.parameters;
        this.origMsg[pos += 2] = 0;
        this.origMsg[++pos] = 1;
        System.arraycopy(bsedk, 0, this.origMsg, ++pos, bsedk.length);
        System.arraycopy(this.eedks.getMessage(), 0, this.origMsg, pos += bsedk.length, this.eedks.getMsgLen());
        this.debug.exit("logic", className, "EncryptionSubPageSetupEEDKs-Create");
    }

    EncryptionSubPageSetupEEDKs(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionSubPageSetupEEDKs-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EncryptionSubPageSetupEEDKs-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = 0;
        this.debug.entry("logic", className, "parse");
        pos = offset;
        byte tmp = msg[pos += 2];
        tmp = msg[pos];
        this.oldDKi = (byte)(tmp >> 7);
        this.medium = (byte)(tmp << 1 >> 7);
        tmp = (byte)(msg[pos] << 5);
        this.keyscope = (byte)(tmp >> 5);
        byte[] tmp1 = new byte[]{msg[++pos], msg[++pos]};
        this.sedkCnt = new BigInteger(tmp1);
        this.sedk = new SEDK(msg, ++pos);
        this.eedks = new DKxEEDKUKI(msg, pos += this.sedk.getLength());
        int len = 4 + this.sedk.getLength() + this.eedks.getMsgLen();
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[len];
        System.arraycopy(msg, offset, this.origMsg, 0, len);
        this.debug.exit("logic", className, "parse");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }

    int getSEDKCount() {
        this.debug.entry("logic", className, "getSEDKCount");
        this.debug.exit("logic", className, "getSEDKCount");
        return this.sedkCnt.intValue();
    }

    SEDK getSEDK() {
        this.debug.entry("logic", className, "getSEDK");
        this.debug.exit("logic", className, "getSEDK");
        return this.sedk;
    }

    DKxEEDKUKI getDKxEEDKUKI() {
        this.debug.entry("logic", className, "getDKxEEDKUKI");
        this.debug.exit("logic", className, "getDKxEEDKUKI");
        return this.eedks;
    }

    byte getOldDKi() {
        this.debug.entry("logic", className, "getOldDKi");
        this.debug.exit("logic", className, "getOldDKi");
        return this.oldDKi;
    }

    byte getMedium() {
        this.debug.entry("logic", className, "getMedium");
        this.debug.exit("logic", className, "getMedium");
        return this.medium;
    }

    byte getKeyscope() {
        this.debug.entry("logic", className, "getKeyscope");
        this.debug.exit("logic", className, "getKeyscope");
        return this.keyscope;
    }
}

