/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import java.math.BigInteger;

public class EncryptionCBDQuery {
    byte OpCode;
    byte pageCode;
    byte subPageCode;
    byte[] allocationLen = new byte[2];
    byte ctrlByte;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncryptionCBDQuery.class";

    EncryptionCBDQuery(byte sPC) throws KeyManagerException {
        this.debug.entry("logic", className, "EncryptionCBDQuery-Create");
        this.subPageCode = sPC;
        this.create(this.subPageCode);
        this.debug.exit("logic", className, "EncryptionCBDQuery-Create");
    }

    void create(byte subPageCode) {
        this.debug.entry("logic", className, "create");
        this.msglen = new BigInteger("16");
        this.origMsg = new byte[this.msglen.intValue()];
        this.origMsg[0] = 90;
        this.OpCode = (byte)90;
        this.origMsg[1] = 8;
        this.origMsg[2] = 37;
        this.pageCode = (byte)37;
        this.origMsg[3] = subPageCode;
        this.allocationLen[0] = -1;
        this.allocationLen[1] = -1;
        System.arraycopy(this.allocationLen, 0, this.origMsg, 7, 2);
        this.origMsg[9] = this.ctrlByte = 0;
        this.debug.exit("logic", className, "create");
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte getOperationCode() {
        this.debug.entry("logic", className, "getOperationCode");
        this.debug.exit("logic", className, "getOperationCode");
        return this.OpCode;
    }

    byte getPageCode() {
        this.debug.entry("logic", className, "getPageCode");
        this.debug.exit("logic", className, "getPageCode");
        return this.pageCode;
    }

    byte getSubPageCode() {
        this.debug.entry("logic", className, "getSubPageCode");
        this.debug.exit("logic", className, "getSubPageCode");
        return this.subPageCode;
    }

    byte[] allocationLen() {
        this.debug.entry("logic", className, "allocationLen");
        this.debug.exit("logic", className, "allocationLen");
        return this.allocationLen;
    }

    byte getControlByte() {
        this.debug.entry("logic", className, "getControlByte");
        this.debug.exit("logic", className, "getControlByte");
        return this.ctrlByte;
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

