/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Crypto;
import com.ibm.keymanager.logic.EncryptionSubPageWrapper;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.logic.MediumInfo;
import com.ibm.keymanager.logic.MsgHeader;
import com.ibm.keymanager.logic.ProxyRoutingInfo;
import com.ibm.keymanager.logic.RoutingInfo;
import com.ibm.keymanager.logic.SigningInfo;
import java.math.BigInteger;

public class EncSubPageStatusWrapper {
    BigInteger encMsgLen;
    BigInteger signedMsgLen;
    ProxyRoutingInfo pri = null;
    MsgHeader header;
    EncryptionSubPageWrapper esp;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EncSubPageStatusWrapper.class";

    EncSubPageStatusWrapper(ProxyRoutingInfo priIn, RoutingInfo ri, MediumInfo medInfo, byte payLoadType, byte respCode, byte senseKey, byte asc, byte ascq, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "EncSubPageStatusWrapper-Create");
        this.esp = new EncryptionSubPageWrapper(ri, medInfo, payLoadType, null, null, null, null, 0, null, 0, null, null, 0, respCode, senseKey, asc, ascq, crypto);
        int len = 0;
        len = crypto == null ? this.esp.getMsgLen() + 8 + 4 + priIn.getMsgLen() + SigningInfo.getLength(0) : this.esp.getMsgLen() + 8 + 4 + priIn.getMsgLen() + SigningInfo.getLength(1024);
        int signlen = this.esp.getMsgLen() + priIn.getMsgLen() + 4;
        this.msglen = new BigInteger("" + len);
        this.origMsg = new byte[len];
        this.pri = new ProxyRoutingInfo(priIn, 0, false);
        this.header = new MsgHeader(this.pri, len - 4, signlen);
        int pos = 0;
        System.arraycopy(this.header.getMessage(), 0, this.origMsg, pos, this.header.getHeaderLen());
        this.origMsg[pos += this.header.getHeaderLen()] = 33;
        this.origMsg[++pos] = -2;
        System.arraycopy(Logic.IntToByteArray(this.esp.getMsgLen(), 2), 0, this.origMsg, ++pos, 2);
        System.arraycopy(this.esp.getMessage(), 0, this.origMsg, pos += 2, this.esp.getMsgLen());
        SigningInfo si = null;
        si = crypto == null ? new SigningInfo(this.origMsg, 8, signlen, 0, crypto) : new SigningInfo(this.origMsg, 8, signlen, 1024, crypto);
        System.arraycopy(si.getMessage(), 0, this.origMsg, pos += this.esp.getMsgLen(), si.getMsgLen());
        this.debug.exit("logic", className, "EncSubPageStatusWrapper-Create");
    }

    EncSubPageStatusWrapper(byte[] msg, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "EncSubPageStatusWrapper-Parse");
        this.origMsg = new byte[msg.length];
        System.arraycopy(msg, 0, this.origMsg, 0, msg.length);
        this.parse(msg, crypto);
        this.debug.exit("logic", className, "EncSubPageStatusWrapper-Parse");
    }

    void parse(byte[] msg, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "parse");
        this.header = new MsgHeader(msg);
        int pos = this.header.getHeaderLen();
        if (msg[pos] != 33 || msg[pos + 1] != -2) {
            this.debug.exit("logic", className, "parse", "Exception: Message type not X21FE");
            throw new KeyManagerException(2, 1, "Message type not X21FE");
        }
        byte[] tmp = new byte[2];
        System.arraycopy(msg, pos += 2, tmp, 0, 2);
        BigInteger subPayloadLen = new BigInteger(tmp);
        this.esp = new EncryptionSubPageWrapper(msg, pos += 2, false, crypto);
        SigningInfo si = new SigningInfo(msg, pos += this.esp.getMsgLen());
        if (!si.verify(msg, this.header.getHeaderLen(), this.header.getSignedMsgLen().intValue(), crypto)) {
            this.debug.exit("logic", className, "parse", "Exception: essage has been tammpered with");
            throw new KeyManagerException(2, 2, "Message has been tammpered with");
        }
        this.debug.exit("logic", className, "parse");
    }

    EncryptionSubPageWrapper getEncryptionSubPageWrapper() {
        this.debug.entry("logic", className, "getEncryptionSubPageWrapper");
        this.debug.exit("logic", className, "getEncryptionSubPageWrapper");
        return this.esp;
    }

    MsgHeader getMessageHeader() {
        this.debug.entry("logic", className, "getMessageHeader");
        this.debug.exit("logic", className, "getMessageHeader");
        return this.header;
    }

    BigInteger getEncMsgLen() {
        this.debug.entry("logic", className, "getEncMsgLen");
        this.debug.exit("logic", className, "getEncMsgLen");
        return this.encMsgLen;
    }

    BigInteger getSignedMsgLen() {
        this.debug.entry("logic", className, "getSignedMsgLen");
        this.debug.exit("logic", className, "getSignedMsgLen");
        return this.signedMsgLen;
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.pri.getMsgLen() + 8;
    }
}

