/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.crypto.provider.AESKeySpec;
import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.logic.MESData;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;

public class EEDK {
    byte[] structType = new byte[2];
    BigInteger structLen;
    byte[] origMsg;
    SecretKey key;
    byte[] keyData;
    String keyLabel;
    byte[] keySKI;
    int keyType;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "EEDK.class";

    EEDK(String label, byte[] hash, byte[] edk, int keyType) throws KeyManagerException {
        this.debug.entry("logic", className, "EEDK-Create");
        this.structType[0] = 16;
        this.structType[1] = 1;
        this.keyData = edk;
        this.keyType = keyType;
        if (this.keySKI == null) {
            this.keyLabel = label;
        } else {
            this.keySKI = hash;
        }
        byte[] data = hash != null ? new MESData(edk, keyType, 0, null, hash).encode() : new MESData(edk, keyType, 0, null, label).encode();
        int len = data.length + 4;
        this.origMsg = new byte[len];
        this.msglen = new BigInteger("" + len);
        System.arraycopy(this.structType, 0, this.origMsg, 0, this.structType.length);
        int pos = 2;
        System.arraycopy(Logic.IntToByteArray(data.length, 2), 0, this.origMsg, pos, 2);
        System.arraycopy(data, 0, this.origMsg, pos += 2, data.length);
        this.debug.exit("logic", className, "EEDK-Create");
    }

    EEDK(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "EEDK-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "EEDK-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        int pos = offset;
        this.debug.entry("logic", className, "parse");
        System.arraycopy(msg, pos, this.structType, 0, this.structType.length);
        pos += this.structType.length;
        if (this.structType[0] != 16) {
            this.debug.exit("logic", className, "parse", "Message type not X10");
            throw new KeyManagerException(2, 1, "Message type not X10");
        }
        byte[] tmp = new byte[]{msg[pos], msg[++pos]};
        ++pos;
        this.structLen = new BigInteger(tmp);
        this.msglen = this.structLen.add(new BigInteger("4"));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        if (this.structLen.intValue() > 0) {
            if (this.structType[1] == 1) {
                MESData data = new MESData(msg, pos, this.structLen.intValue());
                this.keyData = data.getEEDKey();
                this.keyLabel = data.getSubjectKeyLabel();
                this.keySKI = data.getSubjectKeyId();
                this.keyType = data.getEncAlgo();
            } else if (this.structType[1] == 32 && this.structLen.intValue() != 0) {
                tmp = new byte[this.structLen.intValue()];
                System.arraycopy(msg, pos, tmp, 0, tmp.length);
                AESKeySpec aesKeySpec = null;
                try {
                    aesKeySpec = new AESKeySpec(tmp);
                    SecretKeyFactory keyFactory = SecretKeyFactory.getInstance("AES");
                    this.key = keyFactory.generateSecret((KeySpec)aesKeySpec);
                    this.keyType = 2;
                }
                catch (NoSuchAlgorithmException e) {
                    this.debug.exit("logic", className, "parse", "Exception: " + e.getMessage());
                    throw new KeyManagerException(2, 5, e.getMessage());
                }
                catch (InvalidKeyException e1) {
                    this.debug.exit("logic", className, "parse", "Exception: " + e1.getMessage());
                    throw new KeyManagerException(2, 5, e1.getMessage());
                }
                catch (InvalidKeySpecException e2) {
                    this.debug.exit("logic", className, "parse", "Exception: " + e2.getMessage());
                    throw new KeyManagerException(2, 5, e2.getMessage());
                }
            }
        }
        this.debug.exit("logic", className, "parse");
    }

    SecretKey getKey() {
        this.debug.entry("logic", className, "getKey");
        this.debug.exit("logic", className, "getKey");
        return this.key;
    }

    byte[] getKeyData() {
        this.debug.entry("logic", className, "getKeyData");
        this.debug.exit("logic", className, "getKeyData");
        return this.keyData;
    }

    String getEncKeyLabel() {
        this.debug.entry("logic", className, "getEncKeyLabel");
        this.debug.exit("logic", className, "getEncKeyLabel");
        return this.keyLabel;
    }

    byte[] getEncKeySKI() {
        this.debug.entry("logic", className, "getEncKeySKI");
        this.debug.exit("logic", className, "getEncKeySKI");
        return this.keySKI;
    }

    int getKeyType() {
        this.debug.entry("logic", className, "getKeyType");
        this.debug.exit("logic", className, "getKeyType");
        return this.keyType;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

