/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.logic.Crypto;
import com.ibm.keymanager.logic.DKxEEDKUKI;
import com.ibm.keymanager.logic.EncryptionCBDIssue;
import com.ibm.keymanager.logic.EncryptionSubPageWrapper;
import com.ibm.keymanager.logic.Logic;
import com.ibm.keymanager.logic.MediumInfo;
import com.ibm.keymanager.logic.MsgHeader;
import com.ibm.keymanager.logic.ProxyRoutingInfo;
import com.ibm.keymanager.logic.RoutingInfo;
import com.ibm.keymanager.logic.SigningInfo;
import java.math.BigInteger;

public class DriveErrorNotify {
    BigInteger encMsgLen;
    BigInteger signedMsgLen;
    ProxyRoutingInfo pri = null;
    MsgHeader header;
    EncryptionCBDIssue encCBD;
    EncryptionSubPageWrapper esp;
    byte[] modeParamHdr;
    byte[] origMsg;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "DriveErrorNotify.class";

    DriveErrorNotify(ProxyRoutingInfo pri, RoutingInfo ri, MediumInfo medInfo, byte payloadType, String[] labels, byte[][] skis, byte[][] edks, DKxEEDKUKI oldEEDKs, byte alterAction, byte[] dki, int keyType, byte[] sedk, byte[] publicKeyHash, byte[] modeHdr, Crypto crypto) throws KeyManagerException {
        this.debug.entry("logic", className, "DriveErrorNotify-Create");
        this.createMsg(pri, ri, medInfo, payloadType, labels, skis, edks, oldEEDKs, alterAction, dki, keyType, sedk, publicKeyHash, modeHdr, crypto);
        this.debug.entry("logic", className, "DriveErrorNotify Create");
    }

    DriveErrorNotify(byte[] msg, Crypto crypto) throws KeyManagerException {
        this.debug.entry("audit", className, "DriveErrorNotify-Decode");
        this.origMsg = new byte[msg.length];
        System.arraycopy(msg, 0, this.origMsg, 0, msg.length);
        this.parse(msg, crypto);
        this.debug.exit("audit", className, "DriveErrorNotify-Decode");
    }

    void createMsg(ProxyRoutingInfo priIn, RoutingInfo riIn, MediumInfo medInfoIn, byte payloadType, String[] labels, byte[][] skis, byte[][] edks, DKxEEDKUKI oldEEDKs, byte alterAction, byte[] dki, int keyType, byte[] sedk, byte[] publicKeyHash, byte[] modeHdr, Crypto crypto) throws KeyManagerException {
        EncryptionCBDIssue ecbd;
        this.debug.entry("audit", className, "createMsg");
        int encLen = 0;
        int signMsgLen = 0;
        this.modeParamHdr = modeHdr;
        encLen = 4;
        ProxyRoutingInfo pri = new ProxyRoutingInfo(priIn, -128, true);
        encLen += pri.getMsgLen();
        this.esp = new EncryptionSubPageWrapper(riIn, medInfoIn, payloadType, labels, skis, edks, oldEEDKs, alterAction, dki, keyType, sedk, publicKeyHash, -128, 0, 0, 0, 0, crypto);
        encLen += this.esp.getMsgLen();
        this.encCBD = ecbd = new EncryptionCBDIssue(this.esp.getMsgLen() + modeHdr.length);
        encLen = encLen + 2 + 2 + 2 + 2 + ecbd.getMsgLen() + modeHdr.length;
        signMsgLen = encLen - 4;
        this.origMsg = new byte[(encLen += SigningInfo.getLength(1024)) + 4];
        this.encMsgLen = new BigInteger("" + encLen);
        this.signedMsgLen = new BigInteger("" + signMsgLen);
        System.arraycopy(Logic.IntToByteArray(encLen, 4), 0, this.origMsg, 0, 4);
        int pos = 4;
        System.arraycopy(Logic.IntToByteArray(signMsgLen, 4), 0, this.origMsg, pos, 4);
        System.arraycopy(pri.getMessage(), 0, this.origMsg, pos += 4, pri.getMsgLen());
        this.origMsg[pos += pri.getMsgLen()] = 32;
        this.origMsg[++pos] = 32;
        System.arraycopy(Logic.IntToByteArray(this.esp.getMsgLen(), 2), 0, this.origMsg, ++pos, 2);
        pos += 2;
        System.arraycopy(Logic.IntToByteArray(ecbd.getMsgLen(), 2), 0, this.origMsg, pos += 2, 2);
        System.arraycopy(ecbd.getMessage(), 0, this.origMsg, pos += 2, ecbd.getMsgLen());
        System.arraycopy(modeHdr, 0, this.origMsg, pos += ecbd.getMsgLen(), modeHdr.length);
        System.arraycopy(this.esp.getMessage(), 0, this.origMsg, pos += modeHdr.length, this.esp.getMsgLen());
        SigningInfo si = new SigningInfo(this.origMsg, 8, signMsgLen, 1024, crypto);
        System.arraycopy(si.getMessage(), 0, this.origMsg, pos += this.esp.getMsgLen(), si.getMsgLen());
        this.header = new MsgHeader(this.origMsg);
        this.debug.exit("audit", className, "createMsg");
    }

    void parse(byte[] msg, Crypto crypto) throws KeyManagerException {
        this.debug.entry("audit", className, "parse");
        this.header = new MsgHeader(msg);
        int pos = this.header.getHeaderLen();
        if (msg[pos] != 32 || msg[pos + 1] != 32) {
            this.debug.trace("audit", className, "parse", "Message type not X2020");
            this.debug.exit("audit", className, "parse");
            throw new KeyManagerException(2, 1, "Message type not X2020");
        }
        byte[] tmp = new byte[2];
        System.arraycopy(msg, pos += 2, tmp, 0, 2);
        BigInteger subPayloadLen = new BigInteger(tmp);
        pos += 2;
        tmp = new byte[2];
        System.arraycopy(msg, pos += 2, tmp, 0, 2);
        BigInteger encCBDLen = new BigInteger(tmp);
        this.encCBD = new EncryptionCBDIssue(msg, pos += 2, encCBDLen.intValue());
        this.modeParamHdr = new byte[8];
        System.arraycopy(msg, pos += encCBDLen.intValue(), this.modeParamHdr, 0, 8);
        this.esp = new EncryptionSubPageWrapper(msg, pos += 8, crypto);
        SigningInfo si = new SigningInfo(msg, pos += this.esp.getMsgLen());
        if (!si.verify(msg, 8, this.header.getSignedMsgLen().intValue(), crypto)) {
            this.debug.trace("audit", className, "parse", "Message signature does not verify");
            this.debug.exit("audit", className, "parse");
            throw new KeyManagerException(2, 2, "Message signature does not verify");
        }
        this.debug.exit("audit", className, "parse");
    }

    MsgHeader getMessageHeader() {
        return this.header;
    }

    BigInteger getEncMsgLen() {
        return this.encMsgLen;
    }

    BigInteger getSignedMsgLen() {
        return this.signedMsgLen;
    }

    EncryptionCBDIssue getEncryptionCDB() {
        return this.encCBD;
    }

    EncryptionSubPageWrapper getEncryptionSubPageWrapper() {
        return this.esp;
    }

    byte[] getModeParameterHeader() {
        return this.modeParamHdr;
    }

    byte[] getMessage() {
        return this.origMsg;
    }

    int getMsgLen() {
        return this.pri.getMsgLen() + 8;
    }
}

