/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.logic;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import java.math.BigInteger;

public class DSK {
    byte[] structType = new byte[2];
    BigInteger structLen;
    byte[] keyData;
    byte[] origMsg;
    BigInteger msglen;
    private KMSDebug debug = KMSDebug.getInstance();
    private static String className = "DSK.class";

    public DSK(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "DSK-Parse");
        this.parse(msg, offset);
        this.debug.exit("logic", className, "DSK-Parse");
    }

    void parse(byte[] msg, int offset) throws KeyManagerException {
        this.debug.entry("logic", className, "parse");
        int pos = offset;
        System.arraycopy(msg, pos, this.structType, 0, this.structType.length);
        pos += this.structType.length;
        if (this.structType[0] != 12 && this.structType[1] != 1) {
            this.debug.trace("audit", className, "parse", "Message type not X0C01");
            this.debug.exit("audit", className, "parse");
            throw new KeyManagerException(2, 1, "Message type not X0C01");
        }
        byte[] tmp = new byte[]{msg[pos], msg[++pos]};
        this.structLen = new BigInteger(tmp);
        tmp = new byte[this.structLen.intValue()];
        System.arraycopy(msg, ++pos, tmp, 0, this.structLen.intValue());
        this.parseKeyASN1(tmp);
        this.msglen = this.structLen.add(new BigInteger("4"));
        this.origMsg = new byte[this.msglen.intValue()];
        System.arraycopy(msg, offset, this.origMsg, 0, this.msglen.intValue());
        this.debug.exit("logic", className, "parse");
    }

    void parseKeyASN1(byte[] asn1) throws KeyManagerException {
        this.debug.entry("logic", className, "parseKeyASN1");
        int pos = 0;
        pos = asn1[1] == -126 ? 4 : 3;
        if (asn1[pos += 2] != 0) {
            throw new KeyManagerException(2, 1, "Message does not contain correct encoding for key.");
        }
        BigInteger len = null;
        if (asn1[++pos + 1] == -126) {
            byte[] tmp = new byte[]{asn1[pos + 2], asn1[pos + 3]};
            len = new BigInteger(tmp).add(new BigInteger("4"));
        } else {
            byte[] tmp = new byte[]{0, asn1[pos + 2]};
            len = new BigInteger(tmp).add(new BigInteger("3"));
        }
        this.keyData = new byte[len.intValue()];
        System.arraycopy(asn1, pos, this.keyData, 0, len.intValue());
        this.debug.exit("logic", className, "parseKeyASN1");
    }

    byte[] getKeyData() {
        this.debug.entry("logic", className, "getKeyData");
        this.debug.exit("logic", className, "getKeyData");
        return this.keyData;
    }

    byte[] getStructType() {
        this.debug.entry("logic", className, "getStructType");
        this.debug.exit("logic", className, "getStructType");
        return this.structType;
    }

    int getMsgLen() {
        this.debug.entry("logic", className, "getMsgLen");
        this.debug.exit("logic", className, "getMsgLen");
        return this.msglen.intValue();
    }

    byte[] getMessage() {
        this.debug.entry("logic", className, "getMessage");
        this.debug.exit("logic", className, "getMessage");
        return this.origMsg;
    }
}

