/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.i18n;

import com.ibm.keymanager.i18n.I18NResource;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public final class PropertyResource
extends I18NResource {
    public static final String PROPERTIES_FILE = "com.ibm.keymanager.i18n.keymanageri18n";
    private static PropertyResource exceptionInstance;
    private static PropertyResource instance;
    private static ResourceBundle bundle;
    private static Locale locale;
    private String prefix;

    private PropertyResource() {
    }

    private PropertyResource(String prefix) {
        this.prefix = prefix;
    }

    public static synchronized void setLocale(Locale newLocale) {
        if (newLocale == null) {
            throw new IllegalArgumentException("Null locale");
        }
        if (locale.equals(newLocale)) {
            return;
        }
        locale = newLocale;
        bundle = ResourceBundle.getBundle(PROPERTIES_FILE, locale);
    }

    public static synchronized PropertyResource getExceptionInstance() {
        if (exceptionInstance != null) {
            return exceptionInstance;
        }
        exceptionInstance = new PropertyResource("com.ibm.keymanager.i18n.");
        return exceptionInstance;
    }

    public static synchronized PropertyResource getInstance(String prefix) {
        if (instance != null) {
            return instance;
        }
        instance = new PropertyResource(prefix);
        return instance;
    }

    public ResourceBundle getBundle() {
        return bundle;
    }

    public Locale getLocale() {
        return (Locale)locale.clone();
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFile() {
        return PROPERTIES_FILE;
    }

    public String getString(String key) {
        if (this.prefix != null && key != null) {
            return bundle.getString(this.prefix + key);
        }
        return bundle.getString(key);
    }

    public String getFormattedString(String key, Object[] positionalParams) {
        if (this.prefix != null && key != null) {
            key = this.prefix + key;
        }
        String message = bundle.getString(key);
        if (positionalParams == null) {
            return message;
        }
        return MessageFormat.format(message, positionalParams);
    }

    static {
        bundle = ResourceBundle.getBundle(PROPERTIES_FILE);
        locale = bundle.getLocale();
    }
}

