/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.drivetable;

import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.Audit;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.drivetable.DriveTableEntrySpi;
import java.util.Date;
import java.util.Map;

public class DriveTableEntry
extends DriveTableEntrySpi {
    private DriveTableEntrySpi dte = null;

    public DriveTableEntry(Config conf, Audit aud) throws KeyManagerException {
        if (conf == null) {
            throw new KeyManagerException("Null config object");
        }
        if (aud == null) {
            throw new KeyManagerException("Null Audit object");
        }
        String driveEntryClass = (String)conf.get("config.drivetable.table.entry.provider");
        if (driveEntryClass == null) {
            driveEntryClass = "com.ibm.keymanager.drivetable.file.TapeDriveTableEntry";
        }
        this.dte = this.loadDriveTableEntry(driveEntryClass);
    }

    public String toEntryString() throws KeyManagerException {
        return this.dte.toEntryString();
    }

    public void init(byte[] WorldWideName, byte[] DriveSN, Map mapObjects) throws KeyManagerException {
        this.dte.init(WorldWideName, DriveSN, mapObjects);
    }

    public void init(byte[] encoding) throws KeyManagerException {
        this.dte.init(encoding);
    }

    private DriveTableEntrySpi loadDriveTableEntry(String className) throws KeyManagerException {
        try {
            return this.loadClass(className);
        }
        catch (Exception exc) {
            throw new KeyManagerException(exc.toString());
        }
    }

    private DriveTableEntrySpi loadClass(String className) throws Exception {
        Class<?> implementation = null;
        ClassLoader loader = null;
        implementation = loader == null ? Class.forName(className) : loader.loadClass(className);
        return (DriveTableEntrySpi)implementation.newInstance();
    }

    public byte[] getWWName() throws KeyManagerException {
        return this.dte.getWWName();
    }

    public void setWWName(byte[] WorldWideName) throws KeyManagerException {
        this.dte.setWWName(WorldWideName);
    }

    public byte[] getSN() throws KeyManagerException {
        return this.dte.getSN();
    }

    public void setSN(byte[] SerialNumber) throws KeyManagerException {
        this.dte.setSN(SerialNumber);
    }

    public boolean isUpdated() throws KeyManagerException {
        return this.dte.isUpdated();
    }

    public boolean isDeleted() throws KeyManagerException {
        return this.dte.isDeleted();
    }

    public void setDeleted() throws KeyManagerException {
        this.dte.setDeleted();
    }

    public boolean equalsEntry(String tableEntry, Object comparisonObject) throws KeyManagerException {
        return this.dte.equalsEntry(tableEntry, comparisonObject);
    }

    public Object getObject(String tableType) throws KeyManagerException {
        return this.dte.getObject(tableType);
    }

    public void setObject(String tableType, Object tableObject) throws KeyManagerException {
        this.dte.setObject(tableType, tableObject);
    }

    public Date getTimeStamp() throws KeyManagerException {
        return this.dte.getTimeStamp();
    }

    public boolean isValidEntryType(String type) throws KeyManagerException {
        return this.dte.isValidEntryType(type);
    }

    public byte[] exportData() throws KeyManagerException {
        return this.dte.exportData();
    }

    public void setUpdated() throws KeyManagerException {
        this.dte.setUpdated();
    }
}

