/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit.file;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.SecurityEventHandlerSpi;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.config.Config;
import com.ibm.keymanager.i18n.PropertyResource;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Date;

public class SimpleFileSecurityEventHandler
extends SecurityEventHandlerSpi {
    public static final String DIRECTORY_NAME = "Audit.handler.file.directory";
    public static final String FILE_MAX_SIZE = "Audit.handler.file.size";
    public static final String FILE_NAME = "Audit.handler.file.name";
    public static final String MULTITHREADS = "Audit.handler.file.multithreads";
    public static final String THREAD_LIFESPAN = "Audit.handler.file.threadlifespan";
    private String directory;
    private String fileName;
    private long fileSize;
    private long fileMaxSize;
    private File auditFile;
    private FileOutputStream fos;
    private boolean useMultiThreads;
    private long threadLifespan;
    private String new_directory;
    private String new_file_name;
    private KMSDebug debug = KMSDebug.getInstance();
    private ArrayList threadQueue = new ArrayList();
    private Object writeLock = new Object();
    private PropertyResource pr = PropertyResource.getExceptionInstance();

    public void init(Config properties) throws KeyManagerException {
        try {
            this.fileName = (String)properties.get(FILE_NAME);
            this.fileMaxSize = new Long((String)properties.get(FILE_MAX_SIZE)) * 1000L;
        }
        catch (KeyManagerException ex) {
            this.debug.trace("audit", "SimpleFileSecurityEventHandler", "init", ex);
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        catch (NumberFormatException ex) {
            this.debug.trace("audit", "SimpleFileSecurityEventHandler", "init", ex);
            this.fileMaxSize = 100000L;
        }
        if (this.fileMaxSize < 0L) {
            throw new KeyManagerException(this.pr.getString("filesize"));
        }
        try {
            this.directory = (String)properties.get(DIRECTORY_NAME);
        }
        catch (KeyManagerException ex) {
            throw (KeyManagerException)new KeyManagerException().initCause(ex);
        }
        if (this.fileName == null) {
            throw new KeyManagerException(this.pr.getString("auditfile"));
        }
        this.initFile(this.directory, this.fileName);
        this.initThreads(properties, true);
    }

    private void initFile(String directory, String fileName) throws KeyManagerException {
        File dir = null;
        if (directory != null && !(dir = new File(directory)).exists() && !dir.mkdirs()) {
            throw new KeyManagerException(this.pr.getString("specdir") + " " + directory + " " + this.pr.getString("noexist"));
        }
        File file = new File(dir, fileName);
        if (file.exists()) {
            this.fileSize = file.length();
            if (this.fileSize > this.fileMaxSize) {
                this.archive(file);
                this.auditFile = new File(dir, fileName);
                this.fileSize = 0L;
            } else {
                this.auditFile = file;
                if (!this.auditFile.canWrite()) {
                    throw new KeyManagerException(this.pr.getString("fileread"));
                }
                this.fileSize = file.length();
            }
        } else {
            try {
                file.createNewFile();
            }
            catch (IOException ex) {
                throw (KeyManagerException)new KeyManagerException().initCause(ex);
            }
            this.auditFile = file;
            this.fileSize = file.length();
        }
    }

    private void archive(File file) throws KeyManagerException {
        this.debug.entry("audit", "SimpleFileSecurityEventHandler", "archive");
        if (this.fos != null) {
            try {
                this.fos.close();
            }
            catch (IOException ex) {
                throw (KeyManagerException)new KeyManagerException(this.pr.getString("closefile")).initCause(ex);
            }
        }
        String thistime = new Long(new Date().getTime()).toString();
        File newFile = new File(file.getAbsolutePath() + "." + thistime);
        if (!file.renameTo(newFile)) {
            throw new KeyManagerException(this.pr.getString("failarchive"));
        }
        boolean result = file.setReadOnly();
        this.debug.trace("audit", "SimpleFileSecurityEventHandler", "archive", "set file read only? " + result);
    }

    public void handleEvent(Security_Event event) {
        this.handleEvents(new Security_Event[]{event});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvents(Security_Event[] events) {
        if (events.length > 0) {
            ByteBuffer[] eventData = this.parseEvents(events);
            if (this.useMultiThreads) {
                WriteThread writeThread = null;
                ArrayList arrayList = this.threadQueue;
                synchronized (arrayList) {
                    while (this.threadQueue.size() > 0) {
                        WriteThread thread = (WriteThread)this.threadQueue.get(0);
                        if (thread.isAlive()) continue;
                        this.threadQueue.remove(0);
                    }
                    writeThread = new WriteThread(eventData);
                    this.threadQueue.add(writeThread);
                }
                writeThread.start();
            } else {
                WriteThread writeThread = new WriteThread(eventData);
                writeThread.run();
            }
        }
    }

    private ByteBuffer[] parseEvents(Security_Event[] events) {
        ByteBuffer[] result = new ByteBuffer[events.length];
        for (int i = 0; i < events.length; ++i) {
            byte[] eventData = ((Object)events[i]).toString().getBytes();
            result[i] = ByteBuffer.wrap(eventData);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Config config) {
        block40: {
            this.debug.entry("audit", "SimpleFileSecurityEventHandler", "refresh");
            boolean updateDir = false;
            boolean updateFile = false;
            try {
                this.new_directory = (String)config.get(DIRECTORY_NAME);
                if (this.new_directory == null) {
                    if (this.directory != null) {
                        this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "update directory");
                        updateDir = true;
                    }
                } else if (!this.new_directory.equals(this.directory)) {
                    this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "update directory, new dir=" + this.new_directory);
                    updateDir = true;
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", ex);
            }
            try {
                this.new_file_name = (String)config.get(FILE_NAME);
                if (this.new_file_name != null && !this.new_file_name.equals(this.fileName)) {
                    this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "update file, new file name=" + this.new_file_name);
                    updateFile = true;
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", ex);
            }
            if (updateDir || updateFile) {
                Object ex = this.writeLock;
                synchronized (ex) {
                    if (updateDir) {
                        if (this.new_directory != null) {
                            File dir = new File(this.new_directory);
                            if (!dir.exists()) {
                                this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "new directory does not exist");
                                updateDir = false;
                            } else {
                                this.directory = this.new_directory;
                            }
                        } else {
                            this.directory = this.new_directory;
                        }
                    }
                    File file = null;
                    if (updateFile) {
                        file = new File(this.directory, this.new_file_name);
                    } else if (updateDir) {
                        file = new File(this.directory, this.fileName);
                    }
                    if (file != null) {
                        if (file.exists()) {
                            this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "file exists");
                            this.fileSize = file.length();
                            if (this.fileSize > this.fileMaxSize) {
                                try {
                                    this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "file exists, archive it");
                                    this.archive(file);
                                    this.auditFile = new File(this.directory, this.fileName);
                                    this.fileSize = 0L;
                                }
                                catch (KeyManagerException ex2) {
                                    this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", ex2);
                                }
                            } else if (!file.canWrite()) {
                                this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "file can not be written");
                            } else {
                                this.auditFile = file;
                                this.fileSize = file.length();
                            }
                        } else {
                            try {
                                this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "file does not exists, try to create it");
                                file.createNewFile();
                                this.auditFile = file;
                                this.fileSize = file.length();
                            }
                            catch (IOException ex3) {
                                this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", ex3);
                            }
                        }
                    }
                }
            }
            try {
                String new_fileSize = (String)config.get(FILE_MAX_SIZE);
                if (new_fileSize == null) {
                    this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "new file size is not set");
                    break block40;
                }
                long new_file_maxsize = 0L;
                try {
                    new_file_maxsize = new Long(new_fileSize);
                }
                catch (NumberFormatException ex) {
                    this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", ex);
                }
                if (new_file_maxsize > 0L && new_file_maxsize != this.fileSize) {
                    this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", "set new file max size=" + new_file_maxsize);
                    this.fileSize = new_file_maxsize;
                }
            }
            catch (KeyManagerException ex) {
                this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", ex);
            }
        }
        try {
            this.initThreads(config, false);
        }
        catch (KeyManagerException ex) {
            this.debug.trace("audit", "SimpleFileSecurityEventHandler", "refresh", ex);
        }
    }

    private void initThreads(Config config, boolean init) throws KeyManagerException {
        block15: {
            block14: {
                try {
                    String useMultiThreadsSt = (String)config.get(MULTITHREADS);
                    if (useMultiThreadsSt == null) {
                        if (init) {
                            this.useMultiThreads = true;
                        }
                    } else {
                        boolean temp = new Boolean(useMultiThreadsSt);
                        if (temp != this.useMultiThreads) {
                            this.useMultiThreads = temp;
                        }
                    }
                }
                catch (KeyManagerException ex) {
                    if (!init) break block14;
                    this.useMultiThreads = true;
                }
            }
            try {
                String lifespan = (String)config.get(THREAD_LIFESPAN);
                if (lifespan == null) {
                    if (init) {
                        this.threadLifespan = 10000L;
                    }
                    break block15;
                }
                long temp = 0L;
                try {
                    temp = new Long(lifespan);
                }
                catch (NumberFormatException ex) {
                    if (init) {
                        this.threadLifespan = 10000L;
                    }
                    temp = -1L;
                }
                if (temp >= 0L && temp != this.threadLifespan) {
                    this.threadLifespan = temp;
                }
            }
            catch (KeyManagerException ex) {
                if (!init) break block15;
                this.threadLifespan = 10000L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.debug.entry("audit", "SimpleFileSecurityEventHandler", "shutdown");
        ArrayList arrayList = this.threadQueue;
        synchronized (arrayList) {
            while (this.threadQueue.size() > 0) {
                WriteThread thread = (WriteThread)this.threadQueue.get(0);
                int count = 0;
                while (thread.isAlive()) {
                    long currentTime;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException ex) {
                        this.debug.trace("audit", "SimpleFileSecurityEventHandler", "shutdown", ex);
                    }
                    if ((currentTime = new Date().getTime()) - thread.getStartTime() < this.threadLifespan * 1000L) continue;
                    if (count > 2) break;
                    try {
                        thread.interrupt();
                        ++count;
                    }
                    catch (SecurityException ex) {
                        this.debug.trace("audit", "SimpleFileSecurityEventHandler", "shutdown", ex);
                    }
                }
                this.threadQueue.remove(0);
            }
        }
        try {
            if (this.fos != null) {
                this.fos.getChannel().close();
                this.fos.close();
            }
        }
        catch (IOException ex) {
            this.debug.trace("audit", this.getClass().getName(), "shutdown", ex);
        }
        catch (RuntimeException ex) {
            this.debug.trace("audit", this.getClass().getName(), "shutdown", ex);
        }
    }

    public String getType() {
        return "SimpleFile";
    }

    class WriteThread
    extends Thread {
        private ByteBuffer[] eventData;
        private long startTime;

        public WriteThread(ByteBuffer[] eventData) {
            this.eventData = eventData;
            this.startTime = new Date().getTime();
        }

        public long getStartTime() {
            return this.startTime;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            if (SimpleFileSecurityEventHandler.this.fos == null) {
                try {
                    SimpleFileSecurityEventHandler.this.fos = new FileOutputStream(SimpleFileSecurityEventHandler.this.auditFile, true);
                }
                catch (IOException ex) {
                    SimpleFileSecurityEventHandler.this.debug.trace("audit", "WriteThread", "run", ex);
                    return;
                }
            }
            Object object = SimpleFileSecurityEventHandler.this.writeLock;
            synchronized (object) {
                FileChannel fc = SimpleFileSecurityEventHandler.this.fos.getChannel();
                SimpleFileSecurityEventHandler.this.debug.trace("audit", "WriteThread", "run", "file channel open?" + fc.isOpen() + ", thread=" + Thread.currentThread());
                long size = SimpleFileSecurityEventHandler.this.fileSize;
                for (int i = 0; i < this.eventData.length; ++i) {
                    if (size + (long)this.eventData[i].remaining() > SimpleFileSecurityEventHandler.this.fileMaxSize) {
                        try {
                            SimpleFileSecurityEventHandler.this.archive(SimpleFileSecurityEventHandler.this.auditFile);
                            SimpleFileSecurityEventHandler.this.auditFile = new File(SimpleFileSecurityEventHandler.this.directory, SimpleFileSecurityEventHandler.this.fileName);
                            SimpleFileSecurityEventHandler.this.auditFile.createNewFile();
                            SimpleFileSecurityEventHandler.this.fos = new FileOutputStream(SimpleFileSecurityEventHandler.this.auditFile, true);
                            fc = SimpleFileSecurityEventHandler.this.fos.getChannel();
                            size = this.eventData[i].remaining();
                            fc.write(this.eventData[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            SimpleFileSecurityEventHandler.this.debug.trace("audit", "WriteThread", "run", ex);
                            return;
                        }
                    }
                    size += (long)this.eventData[i].remaining();
                    try {
                        fc.write(this.eventData[i]);
                        continue;
                    }
                    catch (IOException ex) {
                        SimpleFileSecurityEventHandler.this.debug.trace("audit", "WriteThread", "run", ex);
                        return;
                    }
                }
                SimpleFileSecurityEventHandler.this.fileSize = size;
                SimpleFileSecurityEventHandler.this.debug.trace("audit", "WriteThread", "run", "audit log size is " + SimpleFileSecurityEventHandler.this.fileSize);
            }
        }
    }
}

