/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.keymanager.audit;

import com.ibm.keymanager.KMSDebug;
import com.ibm.keymanager.KeyManagerException;
import com.ibm.keymanager.audit.AuditMgmt_Event;
import com.ibm.keymanager.audit.AuthnTerminate_Event;
import com.ibm.keymanager.audit.Authn_Event;
import com.ibm.keymanager.audit.Authz_Event;
import com.ibm.keymanager.audit.ConfigMgmt_Event;
import com.ibm.keymanager.audit.DataSync_Event;
import com.ibm.keymanager.audit.ResourceMgmt_Event;
import com.ibm.keymanager.audit.Runtime_Event;
import com.ibm.keymanager.audit.SecurityEventHandler;
import com.ibm.keymanager.audit.Security_Event;
import com.ibm.keymanager.config.Config;
import java.util.LinkedList;
import java.util.List;

class SecurityEventListener {
    private static SecurityEventListener listener;
    private SecurityEventHandler handler;
    private int maxInMemoryEvents;
    private LinkedList eventQueue = new LinkedList();
    static final String AUDIT_HANDLER_CLASS = "Audit.handler.class";
    static final String AUDIT_MAX_EVENTS = "Audit.eventQueue.max";
    private Config new_km_config;
    private String handlerClass;
    private boolean needUpdate;
    private KMSDebug debug = KMSDebug.getInstance();

    public static SecurityEventListener getInstance() {
        if (listener == null) {
            listener = new SecurityEventListener();
        }
        return listener;
    }

    private SecurityEventListener() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyEvent(Security_Event event) throws KeyManagerException {
        this.debug.entry("audit", "SecurityEventListener", "notifyEvent");
        if (event.getEventSource() == null) {
            throw new KeyManagerException("Event source can not be null");
        }
        if (event.getOutcome() == null) {
            throw new KeyManagerException("Event outcome can not be null");
        }
        if (event.getTimestamp() == null) {
            throw new KeyManagerException("Event timestamp can not be null");
        }
        if (event instanceof Authz_Event) {
            this.checkAuthzEvent((Authz_Event)event);
        }
        if (event instanceof ConfigMgmt_Event) {
            this.checkConfigEvent((ConfigMgmt_Event)event);
        }
        if (event instanceof Authn_Event) {
            this.checkAuthnEvent((Authn_Event)event);
        }
        if (event instanceof AuditMgmt_Event) {
            this.checkAuditMgmtEvent((AuditMgmt_Event)event);
        }
        if (event instanceof DataSync_Event) {
            this.checkDataSyncEvent((DataSync_Event)event);
        }
        if (event instanceof ResourceMgmt_Event) {
            this.checkResourceMgmtEvent((ResourceMgmt_Event)event);
        }
        if (event instanceof AuthnTerminate_Event) {
            this.checkAuthnTerminateEvent((AuthnTerminate_Event)event);
        }
        if (event instanceof Runtime_Event) {
            this.checkRuntimeEvent((Runtime_Event)event);
        }
        int max = this.maxInMemoryEvents;
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (max == 0) {
                this.eventQueue.add(event);
                this.recordEvents(this.eventQueue);
            } else if (this.eventQueue.size() < max) {
                this.eventQueue.addLast(event);
            } else {
                this.recordEvents(this.eventQueue);
                this.eventQueue.addLast(event);
            }
        }
    }

    private void checkRuntimeEvent(Runtime_Event event) throws KeyManagerException {
        if (event.getAction() == null) {
            throw new KeyManagerException("Event action can not be null");
        }
        if (event.getResource() == null) {
            throw new KeyManagerException("Event resource information can not be null");
        }
    }

    private void checkAuthnTerminateEvent(AuthnTerminate_Event event) throws KeyManagerException {
        if (event.getUsers() == null) {
            throw new KeyManagerException("Event user information can not be null");
        }
        if (event.getAuthnType() == null) {
            throw new KeyManagerException("Event authentication type can not be null");
        }
        if (event.getTerminateReason() == null) {
            throw new KeyManagerException("Event terminate reason can not be null");
        }
    }

    private void checkResourceMgmtEvent(ResourceMgmt_Event event) throws KeyManagerException {
        if (event.getUser() == null) {
            throw new KeyManagerException("Event user information can not be null");
        }
        if (event.getResource() == null) {
            throw new KeyManagerException("Event resource information can not be null");
        }
        if (event.getAction() == null) {
            throw new KeyManagerException("Event action can not be null");
        }
    }

    private void checkDataSyncEvent(DataSync_Event event) throws KeyManagerException {
        if (event.getAction() == null) {
            throw new KeyManagerException("Event action can not be null");
        }
        if (event.getResource() == null) {
            throw new KeyManagerException("Event action can not be null");
        }
    }

    private void checkAuditMgmtEvent(AuditMgmt_Event event) throws KeyManagerException {
        if (event.getAction() == null) {
            throw new KeyManagerException("Event action can not be null");
        }
        if (event.getType() == null) {
            throw new KeyManagerException("Event type of change can not be null");
        }
        if (event.getUser() == null) {
            throw new KeyManagerException("Event user can not be null");
        }
    }

    private void checkAuthnEvent(Authn_Event event) throws KeyManagerException {
        if (event.getAuthnType() == null) {
            throw new KeyManagerException("Event authentication type can not be null");
        }
        if (event.getUsers() == null) {
            throw new KeyManagerException("Event user information can not be null");
        }
    }

    private void checkConfigEvent(ConfigMgmt_Event event) throws KeyManagerException {
        if (event.getAction() == null) {
            throw new KeyManagerException("Event action can not be null");
        }
        if (event.getType() == null) {
            throw new KeyManagerException("Event action can not be null");
        }
        if (event.getUser() == null) {
            throw new KeyManagerException("Event user can not be null");
        }
    }

    private void checkAuthzEvent(Authz_Event aevent) throws KeyManagerException {
        if (aevent.getOutcome().getResult() && aevent.getAccessDecision() == null) {
            throw new KeyManagerException("Access decision can not be null");
        }
        if (aevent.getUsers() == null) {
            throw new KeyManagerException("User information can not be null");
        }
        if (aevent.getResource() == null) {
            throw new KeyManagerException("Resource information can not be null");
        }
        if (aevent.getCheckedPermissionTypes() == null) {
            throw new KeyManagerException("permission types being checked can not be null");
        }
        if (aevent.getAccessDecision().equals("denied") && aevent.getAccessDecisionReason() == null) {
            throw new KeyManagerException("Access decision reason can not be null");
        }
    }

    public SecurityEventHandler getEventHandler() {
        return this.handler;
    }

    void recordEvents(List events) throws KeyManagerException {
        this.debug.entry("audit", "SecurityEventListener", "recordEvents");
        int count = 0;
        Security_Event[] sevents = new Security_Event[events.size()];
        while (events.size() != 0) {
            sevents[count++] = (Security_Event)events.remove(0);
        }
        if (this.needUpdate) {
            this.debug.trace("audit", "SecurityEventListener", "recordEvents", "need to get new handler");
            SecurityEventHandler temp = null;
            try {
                temp = SecurityEventHandler.getInstance(this.handlerClass);
                temp.init(this.new_km_config);
                this.handler = temp;
            }
            catch (KeyManagerException ex) {
                // empty catch block
            }
            this.new_km_config = null;
            this.needUpdate = false;
        }
        this.handler.handleEvents(sevents);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() throws KeyManagerException {
        this.debug.entry("audit", "SecurityEventListener", "shutdown");
        LinkedList linkedList = this.eventQueue;
        synchronized (linkedList) {
            if (this.eventQueue.size() > 0) {
                this.recordEvents(this.eventQueue);
            }
        }
        this.handler.shutdown();
        listener = null;
    }

    public void init(Config kmconfig) throws KeyManagerException {
        try {
            this.handlerClass = (String)kmconfig.get(AUDIT_HANDLER_CLASS);
        }
        catch (KeyManagerException ex) {
            this.handlerClass = null;
        }
        if (this.handlerClass == null) {
            this.handlerClass = "com.ibm.keymanager.audit.file.SimpleFileSecurityEventHandler";
        }
        this.handler = SecurityEventHandler.getInstance(this.handlerClass);
        if (this.handler == null) {
            throw new KeyManagerException("Unable to get an instance of SecurityEventHandler");
        }
        this.handler.init(kmconfig);
        String maxNumString = null;
        try {
            maxNumString = (String)kmconfig.get(AUDIT_MAX_EVENTS);
            if (maxNumString == null) {
                maxNumString = "0";
            }
        }
        catch (KeyManagerException ex) {
            maxNumString = "0";
        }
        try {
            this.maxInMemoryEvents = new Integer(maxNumString);
        }
        catch (NumberFormatException ex) {
            this.debug.trace("audit", "SecurityEventListener", "init", ex);
            this.maxInMemoryEvents = 0;
        }
    }

    public void refresh(Config kmconfig) {
        this.debug.entry("audit", "SecurityEventListener", "refresh");
        String handler_class = null;
        try {
            handler_class = (String)kmconfig.get(AUDIT_HANDLER_CLASS);
            if (handler_class != null && !handler_class.equals(this.handlerClass)) {
                this.debug.trace("audit", "SecurityEventListener", "refresh", "change handler class to be: " + handler_class);
                this.handlerClass = handler_class;
                this.needUpdate = true;
                this.new_km_config = kmconfig;
            } else {
                this.handler.refresh(kmconfig);
            }
        }
        catch (KeyManagerException ex) {
            this.handler.refresh(kmconfig);
        }
        String maxNumString = null;
        try {
            maxNumString = (String)kmconfig.get(AUDIT_MAX_EVENTS);
        }
        catch (KeyManagerException ex) {
            this.debug.trace("audit", "SecurityEventListener", "refresh", ex);
        }
        if (maxNumString != null) {
            try {
                int new_max = new Integer(maxNumString);
                this.debug.trace("audit", "SecurityEventListener", "refresh", "new event queue max=" + new_max + ", current event queue max=" + this.maxInMemoryEvents);
                if (new_max > 0 && new_max != this.maxInMemoryEvents) {
                    this.maxInMemoryEvents = new_max;
                }
            }
            catch (NumberFormatException ex) {
                this.debug.trace("audit", "SecurityEventListener", "refresh", ex);
            }
        }
    }
}

